//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package authz

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/weaviate/weaviate/entities/models"
)

// AddPermissionsOKCode is the HTTP code returned for type AddPermissionsOK
const AddPermissionsOKCode int = 200

/*
AddPermissionsOK Permissions added successfully.

swagger:response addPermissionsOK
*/
type AddPermissionsOK struct {
}

// NewAddPermissionsOK creates AddPermissionsOK with default headers values
func NewAddPermissionsOK() *AddPermissionsOK {

	return &AddPermissionsOK{}
}

// WriteResponse to the client
func (o *AddPermissionsOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(200)
}

// AddPermissionsBadRequestCode is the HTTP code returned for type AddPermissionsBadRequest
const AddPermissionsBadRequestCode int = 400

/*
AddPermissionsBadRequest Malformed request.

swagger:response addPermissionsBadRequest
*/
type AddPermissionsBadRequest struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewAddPermissionsBadRequest creates AddPermissionsBadRequest with default headers values
func NewAddPermissionsBadRequest() *AddPermissionsBadRequest {

	return &AddPermissionsBadRequest{}
}

// WithPayload adds the payload to the add permissions bad request response
func (o *AddPermissionsBadRequest) WithPayload(payload *models.ErrorResponse) *AddPermissionsBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the add permissions bad request response
func (o *AddPermissionsBadRequest) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *AddPermissionsBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// AddPermissionsUnauthorizedCode is the HTTP code returned for type AddPermissionsUnauthorized
const AddPermissionsUnauthorizedCode int = 401

/*
AddPermissionsUnauthorized Unauthorized or invalid credentials.

swagger:response addPermissionsUnauthorized
*/
type AddPermissionsUnauthorized struct {
}

// NewAddPermissionsUnauthorized creates AddPermissionsUnauthorized with default headers values
func NewAddPermissionsUnauthorized() *AddPermissionsUnauthorized {

	return &AddPermissionsUnauthorized{}
}

// WriteResponse to the client
func (o *AddPermissionsUnauthorized) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(401)
}

// AddPermissionsForbiddenCode is the HTTP code returned for type AddPermissionsForbidden
const AddPermissionsForbiddenCode int = 403

/*
AddPermissionsForbidden Forbidden

swagger:response addPermissionsForbidden
*/
type AddPermissionsForbidden struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewAddPermissionsForbidden creates AddPermissionsForbidden with default headers values
func NewAddPermissionsForbidden() *AddPermissionsForbidden {

	return &AddPermissionsForbidden{}
}

// WithPayload adds the payload to the add permissions forbidden response
func (o *AddPermissionsForbidden) WithPayload(payload *models.ErrorResponse) *AddPermissionsForbidden {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the add permissions forbidden response
func (o *AddPermissionsForbidden) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *AddPermissionsForbidden) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(403)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// AddPermissionsNotFoundCode is the HTTP code returned for type AddPermissionsNotFound
const AddPermissionsNotFoundCode int = 404

/*
AddPermissionsNotFound No role found.

swagger:response addPermissionsNotFound
*/
type AddPermissionsNotFound struct {
}

// NewAddPermissionsNotFound creates AddPermissionsNotFound with default headers values
func NewAddPermissionsNotFound() *AddPermissionsNotFound {

	return &AddPermissionsNotFound{}
}

// WriteResponse to the client
func (o *AddPermissionsNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(404)
}

// AddPermissionsUnprocessableEntityCode is the HTTP code returned for type AddPermissionsUnprocessableEntity
const AddPermissionsUnprocessableEntityCode int = 422

/*
AddPermissionsUnprocessableEntity The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request.

swagger:response addPermissionsUnprocessableEntity
*/
type AddPermissionsUnprocessableEntity struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewAddPermissionsUnprocessableEntity creates AddPermissionsUnprocessableEntity with default headers values
func NewAddPermissionsUnprocessableEntity() *AddPermissionsUnprocessableEntity {

	return &AddPermissionsUnprocessableEntity{}
}

// WithPayload adds the payload to the add permissions unprocessable entity response
func (o *AddPermissionsUnprocessableEntity) WithPayload(payload *models.ErrorResponse) *AddPermissionsUnprocessableEntity {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the add permissions unprocessable entity response
func (o *AddPermissionsUnprocessableEntity) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *AddPermissionsUnprocessableEntity) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(422)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// AddPermissionsInternalServerErrorCode is the HTTP code returned for type AddPermissionsInternalServerError
const AddPermissionsInternalServerErrorCode int = 500

/*
AddPermissionsInternalServerError An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.

swagger:response addPermissionsInternalServerError
*/
type AddPermissionsInternalServerError struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewAddPermissionsInternalServerError creates AddPermissionsInternalServerError with default headers values
func NewAddPermissionsInternalServerError() *AddPermissionsInternalServerError {

	return &AddPermissionsInternalServerError{}
}

// WithPayload adds the payload to the add permissions internal server error response
func (o *AddPermissionsInternalServerError) WithPayload(payload *models.ErrorResponse) *AddPermissionsInternalServerError {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the add permissions internal server error response
func (o *AddPermissionsInternalServerError) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *AddPermissionsInternalServerError) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(500)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
