//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package authz

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the generate command

import (
	"context"
	"net/http"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime/middleware"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/weaviate/weaviate/entities/models"
)

// AssignRoleToGroupHandlerFunc turns a function with the right signature into a assign role to group handler
type AssignRoleToGroupHandlerFunc func(AssignRoleToGroupParams, *models.Principal) middleware.Responder

// Handle executing the request and returning a response
func (fn AssignRoleToGroupHandlerFunc) Handle(params AssignRoleToGroupParams, principal *models.Principal) middleware.Responder {
	return fn(params, principal)
}

// AssignRoleToGroupHandler interface for that can handle valid assign role to group params
type AssignRoleToGroupHandler interface {
	Handle(AssignRoleToGroupParams, *models.Principal) middleware.Responder
}

// NewAssignRoleToGroup creates a new http.Handler for the assign role to group operation
func NewAssignRoleToGroup(ctx *middleware.Context, handler AssignRoleToGroupHandler) *AssignRoleToGroup {
	return &AssignRoleToGroup{Context: ctx, Handler: handler}
}

/*
	AssignRoleToGroup swagger:route POST /authz/groups/{id}/assign authz assignRoleToGroup

# Assign a role to a group

Assign roles to the specified group.
*/
type AssignRoleToGroup struct {
	Context *middleware.Context
	Handler AssignRoleToGroupHandler
}

func (o *AssignRoleToGroup) ServeHTTP(rw http.ResponseWriter, r *http.Request) {
	route, rCtx, _ := o.Context.RouteInfo(r)
	if rCtx != nil {
		*r = *rCtx
	}
	var Params = NewAssignRoleToGroupParams()
	uprinc, aCtx, err := o.Context.Authorize(r, route)
	if err != nil {
		o.Context.Respond(rw, r, route.Produces, route, err)
		return
	}
	if aCtx != nil {
		*r = *aCtx
	}
	var principal *models.Principal
	if uprinc != nil {
		principal = uprinc.(*models.Principal) // this is really a models.Principal, I promise
	}

	if err := o.Context.BindValidRequest(r, route, &Params); err != nil { // bind params
		o.Context.Respond(rw, r, route.Produces, route, err)
		return
	}

	res := o.Handler.Handle(Params, principal) // actually handle the request
	o.Context.Respond(rw, r, route.Produces, route, res)

}

// AssignRoleToGroupBody assign role to group body
//
// swagger:model AssignRoleToGroupBody
type AssignRoleToGroupBody struct {

	// group type
	GroupType models.GroupType `json:"groupType,omitempty" yaml:"groupType,omitempty"`

	// The roles to assign to the specified group.
	Roles []string `json:"roles" yaml:"roles"`
}

// Validate validates this assign role to group body
func (o *AssignRoleToGroupBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateGroupType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AssignRoleToGroupBody) validateGroupType(formats strfmt.Registry) error {
	if swag.IsZero(o.GroupType) { // not required
		return nil
	}

	if err := o.GroupType.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("body" + "." + "groupType")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("body" + "." + "groupType")
		}
		return err
	}

	return nil
}

// ContextValidate validate this assign role to group body based on the context it is used
func (o *AssignRoleToGroupBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateGroupType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AssignRoleToGroupBody) contextValidateGroupType(ctx context.Context, formats strfmt.Registry) error {

	if err := o.GroupType.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("body" + "." + "groupType")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("body" + "." + "groupType")
		}
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *AssignRoleToGroupBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *AssignRoleToGroupBody) UnmarshalBinary(b []byte) error {
	var res AssignRoleToGroupBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
