//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package authz

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/weaviate/weaviate/entities/models"
)

// AssignRoleToGroupOKCode is the HTTP code returned for type AssignRoleToGroupOK
const AssignRoleToGroupOKCode int = 200

/*
AssignRoleToGroupOK Roles assigned successfully.

swagger:response assignRoleToGroupOK
*/
type AssignRoleToGroupOK struct {
}

// NewAssignRoleToGroupOK creates AssignRoleToGroupOK with default headers values
func NewAssignRoleToGroupOK() *AssignRoleToGroupOK {

	return &AssignRoleToGroupOK{}
}

// WriteResponse to the client
func (o *AssignRoleToGroupOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(200)
}

// AssignRoleToGroupBadRequestCode is the HTTP code returned for type AssignRoleToGroupBadRequest
const AssignRoleToGroupBadRequestCode int = 400

/*
AssignRoleToGroupBadRequest Malformed request.

swagger:response assignRoleToGroupBadRequest
*/
type AssignRoleToGroupBadRequest struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewAssignRoleToGroupBadRequest creates AssignRoleToGroupBadRequest with default headers values
func NewAssignRoleToGroupBadRequest() *AssignRoleToGroupBadRequest {

	return &AssignRoleToGroupBadRequest{}
}

// WithPayload adds the payload to the assign role to group bad request response
func (o *AssignRoleToGroupBadRequest) WithPayload(payload *models.ErrorResponse) *AssignRoleToGroupBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the assign role to group bad request response
func (o *AssignRoleToGroupBadRequest) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *AssignRoleToGroupBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// AssignRoleToGroupUnauthorizedCode is the HTTP code returned for type AssignRoleToGroupUnauthorized
const AssignRoleToGroupUnauthorizedCode int = 401

/*
AssignRoleToGroupUnauthorized Unauthorized or invalid credentials.

swagger:response assignRoleToGroupUnauthorized
*/
type AssignRoleToGroupUnauthorized struct {
}

// NewAssignRoleToGroupUnauthorized creates AssignRoleToGroupUnauthorized with default headers values
func NewAssignRoleToGroupUnauthorized() *AssignRoleToGroupUnauthorized {

	return &AssignRoleToGroupUnauthorized{}
}

// WriteResponse to the client
func (o *AssignRoleToGroupUnauthorized) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(401)
}

// AssignRoleToGroupForbiddenCode is the HTTP code returned for type AssignRoleToGroupForbidden
const AssignRoleToGroupForbiddenCode int = 403

/*
AssignRoleToGroupForbidden Forbidden

swagger:response assignRoleToGroupForbidden
*/
type AssignRoleToGroupForbidden struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewAssignRoleToGroupForbidden creates AssignRoleToGroupForbidden with default headers values
func NewAssignRoleToGroupForbidden() *AssignRoleToGroupForbidden {

	return &AssignRoleToGroupForbidden{}
}

// WithPayload adds the payload to the assign role to group forbidden response
func (o *AssignRoleToGroupForbidden) WithPayload(payload *models.ErrorResponse) *AssignRoleToGroupForbidden {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the assign role to group forbidden response
func (o *AssignRoleToGroupForbidden) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *AssignRoleToGroupForbidden) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(403)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// AssignRoleToGroupNotFoundCode is the HTTP code returned for type AssignRoleToGroupNotFound
const AssignRoleToGroupNotFoundCode int = 404

/*
AssignRoleToGroupNotFound Role or group not found.

swagger:response assignRoleToGroupNotFound
*/
type AssignRoleToGroupNotFound struct {
}

// NewAssignRoleToGroupNotFound creates AssignRoleToGroupNotFound with default headers values
func NewAssignRoleToGroupNotFound() *AssignRoleToGroupNotFound {

	return &AssignRoleToGroupNotFound{}
}

// WriteResponse to the client
func (o *AssignRoleToGroupNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(404)
}

// AssignRoleToGroupInternalServerErrorCode is the HTTP code returned for type AssignRoleToGroupInternalServerError
const AssignRoleToGroupInternalServerErrorCode int = 500

/*
AssignRoleToGroupInternalServerError An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.

swagger:response assignRoleToGroupInternalServerError
*/
type AssignRoleToGroupInternalServerError struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewAssignRoleToGroupInternalServerError creates AssignRoleToGroupInternalServerError with default headers values
func NewAssignRoleToGroupInternalServerError() *AssignRoleToGroupInternalServerError {

	return &AssignRoleToGroupInternalServerError{}
}

// WithPayload adds the payload to the assign role to group internal server error response
func (o *AssignRoleToGroupInternalServerError) WithPayload(payload *models.ErrorResponse) *AssignRoleToGroupInternalServerError {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the assign role to group internal server error response
func (o *AssignRoleToGroupInternalServerError) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *AssignRoleToGroupInternalServerError) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(500)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
