//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package authz

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/weaviate/weaviate/entities/models"
)

// AssignRoleToUserOKCode is the HTTP code returned for type AssignRoleToUserOK
const AssignRoleToUserOKCode int = 200

/*
AssignRoleToUserOK Role assigned successfully.

swagger:response assignRoleToUserOK
*/
type AssignRoleToUserOK struct {
}

// NewAssignRoleToUserOK creates AssignRoleToUserOK with default headers values
func NewAssignRoleToUserOK() *AssignRoleToUserOK {

	return &AssignRoleToUserOK{}
}

// WriteResponse to the client
func (o *AssignRoleToUserOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(200)
}

// AssignRoleToUserBadRequestCode is the HTTP code returned for type AssignRoleToUserBadRequest
const AssignRoleToUserBadRequestCode int = 400

/*
AssignRoleToUserBadRequest Malformed request.

swagger:response assignRoleToUserBadRequest
*/
type AssignRoleToUserBadRequest struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewAssignRoleToUserBadRequest creates AssignRoleToUserBadRequest with default headers values
func NewAssignRoleToUserBadRequest() *AssignRoleToUserBadRequest {

	return &AssignRoleToUserBadRequest{}
}

// WithPayload adds the payload to the assign role to user bad request response
func (o *AssignRoleToUserBadRequest) WithPayload(payload *models.ErrorResponse) *AssignRoleToUserBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the assign role to user bad request response
func (o *AssignRoleToUserBadRequest) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *AssignRoleToUserBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// AssignRoleToUserUnauthorizedCode is the HTTP code returned for type AssignRoleToUserUnauthorized
const AssignRoleToUserUnauthorizedCode int = 401

/*
AssignRoleToUserUnauthorized Unauthorized or invalid credentials.

swagger:response assignRoleToUserUnauthorized
*/
type AssignRoleToUserUnauthorized struct {
}

// NewAssignRoleToUserUnauthorized creates AssignRoleToUserUnauthorized with default headers values
func NewAssignRoleToUserUnauthorized() *AssignRoleToUserUnauthorized {

	return &AssignRoleToUserUnauthorized{}
}

// WriteResponse to the client
func (o *AssignRoleToUserUnauthorized) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(401)
}

// AssignRoleToUserForbiddenCode is the HTTP code returned for type AssignRoleToUserForbidden
const AssignRoleToUserForbiddenCode int = 403

/*
AssignRoleToUserForbidden Forbidden

swagger:response assignRoleToUserForbidden
*/
type AssignRoleToUserForbidden struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewAssignRoleToUserForbidden creates AssignRoleToUserForbidden with default headers values
func NewAssignRoleToUserForbidden() *AssignRoleToUserForbidden {

	return &AssignRoleToUserForbidden{}
}

// WithPayload adds the payload to the assign role to user forbidden response
func (o *AssignRoleToUserForbidden) WithPayload(payload *models.ErrorResponse) *AssignRoleToUserForbidden {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the assign role to user forbidden response
func (o *AssignRoleToUserForbidden) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *AssignRoleToUserForbidden) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(403)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// AssignRoleToUserNotFoundCode is the HTTP code returned for type AssignRoleToUserNotFound
const AssignRoleToUserNotFoundCode int = 404

/*
AssignRoleToUserNotFound Specified role or user not found.

swagger:response assignRoleToUserNotFound
*/
type AssignRoleToUserNotFound struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewAssignRoleToUserNotFound creates AssignRoleToUserNotFound with default headers values
func NewAssignRoleToUserNotFound() *AssignRoleToUserNotFound {

	return &AssignRoleToUserNotFound{}
}

// WithPayload adds the payload to the assign role to user not found response
func (o *AssignRoleToUserNotFound) WithPayload(payload *models.ErrorResponse) *AssignRoleToUserNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the assign role to user not found response
func (o *AssignRoleToUserNotFound) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *AssignRoleToUserNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// AssignRoleToUserInternalServerErrorCode is the HTTP code returned for type AssignRoleToUserInternalServerError
const AssignRoleToUserInternalServerErrorCode int = 500

/*
AssignRoleToUserInternalServerError An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.

swagger:response assignRoleToUserInternalServerError
*/
type AssignRoleToUserInternalServerError struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewAssignRoleToUserInternalServerError creates AssignRoleToUserInternalServerError with default headers values
func NewAssignRoleToUserInternalServerError() *AssignRoleToUserInternalServerError {

	return &AssignRoleToUserInternalServerError{}
}

// WithPayload adds the payload to the assign role to user internal server error response
func (o *AssignRoleToUserInternalServerError) WithPayload(payload *models.ErrorResponse) *AssignRoleToUserInternalServerError {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the assign role to user internal server error response
func (o *AssignRoleToUserInternalServerError) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *AssignRoleToUserInternalServerError) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(500)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
