//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package authz

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime/middleware"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/validate"
)

// NewGetGroupsParams creates a new GetGroupsParams object
//
// There are no default values defined in the spec.
func NewGetGroupsParams() GetGroupsParams {

	return GetGroupsParams{}
}

// GetGroupsParams contains all the bound params for the get groups operation
// typically these are obtained from a http.Request
//
// swagger:parameters getGroups
type GetGroupsParams struct {

	// HTTP Request Object
	HTTPRequest *http.Request `json:"-"`

	/*The type of group to retrieve.
	  Required: true
	  In: path
	*/
	GroupType string
}

// BindRequest both binds and validates a request, it assumes that complex things implement a Validatable(strfmt.Registry) error interface
// for simple values it will use straight method calls.
//
// To ensure default values, the struct must have been initialized with NewGetGroupsParams() beforehand.
func (o *GetGroupsParams) BindRequest(r *http.Request, route *middleware.MatchedRoute) error {
	var res []error

	o.HTTPRequest = r

	rGroupType, rhkGroupType, _ := route.Params.GetOK("groupType")
	if err := o.bindGroupType(rGroupType, rhkGroupType, route.Formats); err != nil {
		res = append(res, err)
	}
	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindGroupType binds and validates parameter GroupType from path.
func (o *GetGroupsParams) bindGroupType(rawData []string, hasKey bool, formats strfmt.Registry) error {
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}

	// Required: true
	// Parameter is provided by construction from the route
	o.GroupType = raw

	if err := o.validateGroupType(formats); err != nil {
		return err
	}

	return nil
}

// validateGroupType carries on validations for parameter GroupType
func (o *GetGroupsParams) validateGroupType(formats strfmt.Registry) error {

	if err := validate.EnumCase("groupType", "path", o.GroupType, []interface{}{"oidc"}, true); err != nil {
		return err
	}

	return nil
}
