//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package authz

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the generate command

import (
	"net/http"

	"github.com/go-openapi/runtime/middleware"

	"github.com/weaviate/weaviate/entities/models"
)

// GetRolesForGroupHandlerFunc turns a function with the right signature into a get roles for group handler
type GetRolesForGroupHandlerFunc func(GetRolesForGroupParams, *models.Principal) middleware.Responder

// Handle executing the request and returning a response
func (fn GetRolesForGroupHandlerFunc) Handle(params GetRolesForGroupParams, principal *models.Principal) middleware.Responder {
	return fn(params, principal)
}

// GetRolesForGroupHandler interface for that can handle valid get roles for group params
type GetRolesForGroupHandler interface {
	Handle(GetRolesForGroupParams, *models.Principal) middleware.Responder
}

// NewGetRolesForGroup creates a new http.Handler for the get roles for group operation
func NewGetRolesForGroup(ctx *middleware.Context, handler GetRolesForGroupHandler) *GetRolesForGroup {
	return &GetRolesForGroup{Context: ctx, Handler: handler}
}

/*
	GetRolesForGroup swagger:route GET /authz/groups/{id}/roles/{groupType} authz getRolesForGroup

# Get roles assigned to a specific group

Retrieves a list of all roles assigned to a specific group. The group must be identified by both its name (`id`) and its type (`db` or `oidc`).
*/
type GetRolesForGroup struct {
	Context *middleware.Context
	Handler GetRolesForGroupHandler
}

func (o *GetRolesForGroup) ServeHTTP(rw http.ResponseWriter, r *http.Request) {
	route, rCtx, _ := o.Context.RouteInfo(r)
	if rCtx != nil {
		*r = *rCtx
	}
	var Params = NewGetRolesForGroupParams()
	uprinc, aCtx, err := o.Context.Authorize(r, route)
	if err != nil {
		o.Context.Respond(rw, r, route.Produces, route, err)
		return
	}
	if aCtx != nil {
		*r = *aCtx
	}
	var principal *models.Principal
	if uprinc != nil {
		principal = uprinc.(*models.Principal) // this is really a models.Principal, I promise
	}

	if err := o.Context.BindValidRequest(r, route, &Params); err != nil { // bind params
		o.Context.Respond(rw, r, route.Produces, route, err)
		return
	}

	res := o.Handler.Handle(Params, principal) // actually handle the request
	o.Context.Respond(rw, r, route.Produces, route, res)

}
