//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package authz

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/weaviate/weaviate/entities/models"
)

// GetRolesForGroupOKCode is the HTTP code returned for type GetRolesForGroupOK
const GetRolesForGroupOKCode int = 200

/*
GetRolesForGroupOK A list of roles assigned to the specified group.

swagger:response getRolesForGroupOK
*/
type GetRolesForGroupOK struct {

	/*
	  In: Body
	*/
	Payload models.RolesListResponse `json:"body,omitempty"`
}

// NewGetRolesForGroupOK creates GetRolesForGroupOK with default headers values
func NewGetRolesForGroupOK() *GetRolesForGroupOK {

	return &GetRolesForGroupOK{}
}

// WithPayload adds the payload to the get roles for group o k response
func (o *GetRolesForGroupOK) WithPayload(payload models.RolesListResponse) *GetRolesForGroupOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get roles for group o k response
func (o *GetRolesForGroupOK) SetPayload(payload models.RolesListResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetRolesForGroupOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.RolesListResponse{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

// GetRolesForGroupBadRequestCode is the HTTP code returned for type GetRolesForGroupBadRequest
const GetRolesForGroupBadRequestCode int = 400

/*
GetRolesForGroupBadRequest Bad request

swagger:response getRolesForGroupBadRequest
*/
type GetRolesForGroupBadRequest struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewGetRolesForGroupBadRequest creates GetRolesForGroupBadRequest with default headers values
func NewGetRolesForGroupBadRequest() *GetRolesForGroupBadRequest {

	return &GetRolesForGroupBadRequest{}
}

// WithPayload adds the payload to the get roles for group bad request response
func (o *GetRolesForGroupBadRequest) WithPayload(payload *models.ErrorResponse) *GetRolesForGroupBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get roles for group bad request response
func (o *GetRolesForGroupBadRequest) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetRolesForGroupBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// GetRolesForGroupUnauthorizedCode is the HTTP code returned for type GetRolesForGroupUnauthorized
const GetRolesForGroupUnauthorizedCode int = 401

/*
GetRolesForGroupUnauthorized Unauthorized or invalid credentials.

swagger:response getRolesForGroupUnauthorized
*/
type GetRolesForGroupUnauthorized struct {
}

// NewGetRolesForGroupUnauthorized creates GetRolesForGroupUnauthorized with default headers values
func NewGetRolesForGroupUnauthorized() *GetRolesForGroupUnauthorized {

	return &GetRolesForGroupUnauthorized{}
}

// WriteResponse to the client
func (o *GetRolesForGroupUnauthorized) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(401)
}

// GetRolesForGroupForbiddenCode is the HTTP code returned for type GetRolesForGroupForbidden
const GetRolesForGroupForbiddenCode int = 403

/*
GetRolesForGroupForbidden Forbidden

swagger:response getRolesForGroupForbidden
*/
type GetRolesForGroupForbidden struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewGetRolesForGroupForbidden creates GetRolesForGroupForbidden with default headers values
func NewGetRolesForGroupForbidden() *GetRolesForGroupForbidden {

	return &GetRolesForGroupForbidden{}
}

// WithPayload adds the payload to the get roles for group forbidden response
func (o *GetRolesForGroupForbidden) WithPayload(payload *models.ErrorResponse) *GetRolesForGroupForbidden {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get roles for group forbidden response
func (o *GetRolesForGroupForbidden) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetRolesForGroupForbidden) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(403)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// GetRolesForGroupNotFoundCode is the HTTP code returned for type GetRolesForGroupNotFound
const GetRolesForGroupNotFoundCode int = 404

/*
GetRolesForGroupNotFound The specified group was not found.

swagger:response getRolesForGroupNotFound
*/
type GetRolesForGroupNotFound struct {
}

// NewGetRolesForGroupNotFound creates GetRolesForGroupNotFound with default headers values
func NewGetRolesForGroupNotFound() *GetRolesForGroupNotFound {

	return &GetRolesForGroupNotFound{}
}

// WriteResponse to the client
func (o *GetRolesForGroupNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(404)
}

// GetRolesForGroupUnprocessableEntityCode is the HTTP code returned for type GetRolesForGroupUnprocessableEntity
const GetRolesForGroupUnprocessableEntityCode int = 422

/*
GetRolesForGroupUnprocessableEntity The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request.

swagger:response getRolesForGroupUnprocessableEntity
*/
type GetRolesForGroupUnprocessableEntity struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewGetRolesForGroupUnprocessableEntity creates GetRolesForGroupUnprocessableEntity with default headers values
func NewGetRolesForGroupUnprocessableEntity() *GetRolesForGroupUnprocessableEntity {

	return &GetRolesForGroupUnprocessableEntity{}
}

// WithPayload adds the payload to the get roles for group unprocessable entity response
func (o *GetRolesForGroupUnprocessableEntity) WithPayload(payload *models.ErrorResponse) *GetRolesForGroupUnprocessableEntity {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get roles for group unprocessable entity response
func (o *GetRolesForGroupUnprocessableEntity) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetRolesForGroupUnprocessableEntity) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(422)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// GetRolesForGroupInternalServerErrorCode is the HTTP code returned for type GetRolesForGroupInternalServerError
const GetRolesForGroupInternalServerErrorCode int = 500

/*
GetRolesForGroupInternalServerError An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.

swagger:response getRolesForGroupInternalServerError
*/
type GetRolesForGroupInternalServerError struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewGetRolesForGroupInternalServerError creates GetRolesForGroupInternalServerError with default headers values
func NewGetRolesForGroupInternalServerError() *GetRolesForGroupInternalServerError {

	return &GetRolesForGroupInternalServerError{}
}

// WithPayload adds the payload to the get roles for group internal server error response
func (o *GetRolesForGroupInternalServerError) WithPayload(payload *models.ErrorResponse) *GetRolesForGroupInternalServerError {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get roles for group internal server error response
func (o *GetRolesForGroupInternalServerError) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetRolesForGroupInternalServerError) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(500)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
