//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package authz

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/runtime/middleware"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// NewGetRolesForUserParams creates a new GetRolesForUserParams object
// with the default values initialized.
func NewGetRolesForUserParams() GetRolesForUserParams {

	var (
		// initialize parameters with default values

		includeFullRolesDefault = bool(false)
	)

	return GetRolesForUserParams{
		IncludeFullRoles: &includeFullRolesDefault,
	}
}

// GetRolesForUserParams contains all the bound params for the get roles for user operation
// typically these are obtained from a http.Request
//
// swagger:parameters getRolesForUser
type GetRolesForUserParams struct {

	// HTTP Request Object
	HTTPRequest *http.Request `json:"-"`

	/*The name of the user.
	  Required: true
	  In: path
	*/
	ID string
	/*Whether to include detailed role information like its assigned permissions.
	  In: query
	  Default: false
	*/
	IncludeFullRoles *bool
	/*The type of the user.
	  Required: true
	  In: path
	*/
	UserType string
}

// BindRequest both binds and validates a request, it assumes that complex things implement a Validatable(strfmt.Registry) error interface
// for simple values it will use straight method calls.
//
// To ensure default values, the struct must have been initialized with NewGetRolesForUserParams() beforehand.
func (o *GetRolesForUserParams) BindRequest(r *http.Request, route *middleware.MatchedRoute) error {
	var res []error

	o.HTTPRequest = r

	qs := runtime.Values(r.URL.Query())

	rID, rhkID, _ := route.Params.GetOK("id")
	if err := o.bindID(rID, rhkID, route.Formats); err != nil {
		res = append(res, err)
	}

	qIncludeFullRoles, qhkIncludeFullRoles, _ := qs.GetOK("includeFullRoles")
	if err := o.bindIncludeFullRoles(qIncludeFullRoles, qhkIncludeFullRoles, route.Formats); err != nil {
		res = append(res, err)
	}

	rUserType, rhkUserType, _ := route.Params.GetOK("userType")
	if err := o.bindUserType(rUserType, rhkUserType, route.Formats); err != nil {
		res = append(res, err)
	}
	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindID binds and validates parameter ID from path.
func (o *GetRolesForUserParams) bindID(rawData []string, hasKey bool, formats strfmt.Registry) error {
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}

	// Required: true
	// Parameter is provided by construction from the route
	o.ID = raw

	return nil
}

// bindIncludeFullRoles binds and validates parameter IncludeFullRoles from query.
func (o *GetRolesForUserParams) bindIncludeFullRoles(rawData []string, hasKey bool, formats strfmt.Registry) error {
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}

	// Required: false
	// AllowEmptyValue: false

	if raw == "" { // empty values pass all other validations
		// Default values have been previously initialized by NewGetRolesForUserParams()
		return nil
	}

	value, err := swag.ConvertBool(raw)
	if err != nil {
		return errors.InvalidType("includeFullRoles", "query", "bool", raw)
	}
	o.IncludeFullRoles = &value

	return nil
}

// bindUserType binds and validates parameter UserType from path.
func (o *GetRolesForUserParams) bindUserType(rawData []string, hasKey bool, formats strfmt.Registry) error {
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}

	// Required: true
	// Parameter is provided by construction from the route
	o.UserType = raw

	if err := o.validateUserType(formats); err != nil {
		return err
	}

	return nil
}

// validateUserType carries on validations for parameter UserType
func (o *GetRolesForUserParams) validateUserType(formats strfmt.Registry) error {

	if err := validate.EnumCase("userType", "path", o.UserType, []interface{}{"oidc", "db"}, true); err != nil {
		return err
	}

	return nil
}
