//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package authz

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/weaviate/weaviate/entities/models"
)

// RevokeRoleFromGroupOKCode is the HTTP code returned for type RevokeRoleFromGroupOK
const RevokeRoleFromGroupOKCode int = 200

/*
RevokeRoleFromGroupOK Roles revoked successfully.

swagger:response revokeRoleFromGroupOK
*/
type RevokeRoleFromGroupOK struct {
}

// NewRevokeRoleFromGroupOK creates RevokeRoleFromGroupOK with default headers values
func NewRevokeRoleFromGroupOK() *RevokeRoleFromGroupOK {

	return &RevokeRoleFromGroupOK{}
}

// WriteResponse to the client
func (o *RevokeRoleFromGroupOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(200)
}

// RevokeRoleFromGroupBadRequestCode is the HTTP code returned for type RevokeRoleFromGroupBadRequest
const RevokeRoleFromGroupBadRequestCode int = 400

/*
RevokeRoleFromGroupBadRequest Malformed request.

swagger:response revokeRoleFromGroupBadRequest
*/
type RevokeRoleFromGroupBadRequest struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewRevokeRoleFromGroupBadRequest creates RevokeRoleFromGroupBadRequest with default headers values
func NewRevokeRoleFromGroupBadRequest() *RevokeRoleFromGroupBadRequest {

	return &RevokeRoleFromGroupBadRequest{}
}

// WithPayload adds the payload to the revoke role from group bad request response
func (o *RevokeRoleFromGroupBadRequest) WithPayload(payload *models.ErrorResponse) *RevokeRoleFromGroupBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the revoke role from group bad request response
func (o *RevokeRoleFromGroupBadRequest) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *RevokeRoleFromGroupBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// RevokeRoleFromGroupUnauthorizedCode is the HTTP code returned for type RevokeRoleFromGroupUnauthorized
const RevokeRoleFromGroupUnauthorizedCode int = 401

/*
RevokeRoleFromGroupUnauthorized Unauthorized or invalid credentials.

swagger:response revokeRoleFromGroupUnauthorized
*/
type RevokeRoleFromGroupUnauthorized struct {
}

// NewRevokeRoleFromGroupUnauthorized creates RevokeRoleFromGroupUnauthorized with default headers values
func NewRevokeRoleFromGroupUnauthorized() *RevokeRoleFromGroupUnauthorized {

	return &RevokeRoleFromGroupUnauthorized{}
}

// WriteResponse to the client
func (o *RevokeRoleFromGroupUnauthorized) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(401)
}

// RevokeRoleFromGroupForbiddenCode is the HTTP code returned for type RevokeRoleFromGroupForbidden
const RevokeRoleFromGroupForbiddenCode int = 403

/*
RevokeRoleFromGroupForbidden Forbidden

swagger:response revokeRoleFromGroupForbidden
*/
type RevokeRoleFromGroupForbidden struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewRevokeRoleFromGroupForbidden creates RevokeRoleFromGroupForbidden with default headers values
func NewRevokeRoleFromGroupForbidden() *RevokeRoleFromGroupForbidden {

	return &RevokeRoleFromGroupForbidden{}
}

// WithPayload adds the payload to the revoke role from group forbidden response
func (o *RevokeRoleFromGroupForbidden) WithPayload(payload *models.ErrorResponse) *RevokeRoleFromGroupForbidden {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the revoke role from group forbidden response
func (o *RevokeRoleFromGroupForbidden) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *RevokeRoleFromGroupForbidden) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(403)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// RevokeRoleFromGroupNotFoundCode is the HTTP code returned for type RevokeRoleFromGroupNotFound
const RevokeRoleFromGroupNotFoundCode int = 404

/*
RevokeRoleFromGroupNotFound Role or group not found.

swagger:response revokeRoleFromGroupNotFound
*/
type RevokeRoleFromGroupNotFound struct {
}

// NewRevokeRoleFromGroupNotFound creates RevokeRoleFromGroupNotFound with default headers values
func NewRevokeRoleFromGroupNotFound() *RevokeRoleFromGroupNotFound {

	return &RevokeRoleFromGroupNotFound{}
}

// WriteResponse to the client
func (o *RevokeRoleFromGroupNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(404)
}

// RevokeRoleFromGroupInternalServerErrorCode is the HTTP code returned for type RevokeRoleFromGroupInternalServerError
const RevokeRoleFromGroupInternalServerErrorCode int = 500

/*
RevokeRoleFromGroupInternalServerError An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.

swagger:response revokeRoleFromGroupInternalServerError
*/
type RevokeRoleFromGroupInternalServerError struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewRevokeRoleFromGroupInternalServerError creates RevokeRoleFromGroupInternalServerError with default headers values
func NewRevokeRoleFromGroupInternalServerError() *RevokeRoleFromGroupInternalServerError {

	return &RevokeRoleFromGroupInternalServerError{}
}

// WithPayload adds the payload to the revoke role from group internal server error response
func (o *RevokeRoleFromGroupInternalServerError) WithPayload(payload *models.ErrorResponse) *RevokeRoleFromGroupInternalServerError {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the revoke role from group internal server error response
func (o *RevokeRoleFromGroupInternalServerError) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *RevokeRoleFromGroupInternalServerError) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(500)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
