//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package backups

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the generate command

import (
	"net/http"

	"github.com/go-openapi/runtime/middleware"

	"github.com/weaviate/weaviate/entities/models"
)

// BackupsCancelHandlerFunc turns a function with the right signature into a backups cancel handler
type BackupsCancelHandlerFunc func(BackupsCancelParams, *models.Principal) middleware.Responder

// Handle executing the request and returning a response
func (fn BackupsCancelHandlerFunc) Handle(params BackupsCancelParams, principal *models.Principal) middleware.Responder {
	return fn(params, principal)
}

// BackupsCancelHandler interface for that can handle valid backups cancel params
type BackupsCancelHandler interface {
	Handle(BackupsCancelParams, *models.Principal) middleware.Responder
}

// NewBackupsCancel creates a new http.Handler for the backups cancel operation
func NewBackupsCancel(ctx *middleware.Context, handler BackupsCancelHandler) *BackupsCancel {
	return &BackupsCancel{Context: ctx, Handler: handler}
}

/*
	BackupsCancel swagger:route DELETE /backups/{backend}/{id} backups backupsCancel

# Cancel a backup

Cancels an ongoing backup operation identified by its ID.
*/
type BackupsCancel struct {
	Context *middleware.Context
	Handler BackupsCancelHandler
}

func (o *BackupsCancel) ServeHTTP(rw http.ResponseWriter, r *http.Request) {
	route, rCtx, _ := o.Context.RouteInfo(r)
	if rCtx != nil {
		*r = *rCtx
	}
	var Params = NewBackupsCancelParams()
	uprinc, aCtx, err := o.Context.Authorize(r, route)
	if err != nil {
		o.Context.Respond(rw, r, route.Produces, route, err)
		return
	}
	if aCtx != nil {
		*r = *aCtx
	}
	var principal *models.Principal
	if uprinc != nil {
		principal = uprinc.(*models.Principal) // this is really a models.Principal, I promise
	}

	if err := o.Context.BindValidRequest(r, route, &Params); err != nil { // bind params
		o.Context.Respond(rw, r, route.Produces, route, err)
		return
	}

	res := o.Handler.Handle(Params, principal) // actually handle the request
	o.Context.Respond(rw, r, route.Produces, route, res)

}
