//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package backups

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/weaviate/weaviate/entities/models"
)

// BackupsCreateOKCode is the HTTP code returned for type BackupsCreateOK
const BackupsCreateOKCode int = 200

/*
BackupsCreateOK Backup creation process initiated successfully. Check the status endpoint for progress.

swagger:response backupsCreateOK
*/
type BackupsCreateOK struct {

	/*
	  In: Body
	*/
	Payload *models.BackupCreateResponse `json:"body,omitempty"`
}

// NewBackupsCreateOK creates BackupsCreateOK with default headers values
func NewBackupsCreateOK() *BackupsCreateOK {

	return &BackupsCreateOK{}
}

// WithPayload adds the payload to the backups create o k response
func (o *BackupsCreateOK) WithPayload(payload *models.BackupCreateResponse) *BackupsCreateOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the backups create o k response
func (o *BackupsCreateOK) SetPayload(payload *models.BackupCreateResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *BackupsCreateOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// BackupsCreateUnauthorizedCode is the HTTP code returned for type BackupsCreateUnauthorized
const BackupsCreateUnauthorizedCode int = 401

/*
BackupsCreateUnauthorized Unauthorized or invalid credentials.

swagger:response backupsCreateUnauthorized
*/
type BackupsCreateUnauthorized struct {
}

// NewBackupsCreateUnauthorized creates BackupsCreateUnauthorized with default headers values
func NewBackupsCreateUnauthorized() *BackupsCreateUnauthorized {

	return &BackupsCreateUnauthorized{}
}

// WriteResponse to the client
func (o *BackupsCreateUnauthorized) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(401)
}

// BackupsCreateForbiddenCode is the HTTP code returned for type BackupsCreateForbidden
const BackupsCreateForbiddenCode int = 403

/*
BackupsCreateForbidden Forbidden

swagger:response backupsCreateForbidden
*/
type BackupsCreateForbidden struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewBackupsCreateForbidden creates BackupsCreateForbidden with default headers values
func NewBackupsCreateForbidden() *BackupsCreateForbidden {

	return &BackupsCreateForbidden{}
}

// WithPayload adds the payload to the backups create forbidden response
func (o *BackupsCreateForbidden) WithPayload(payload *models.ErrorResponse) *BackupsCreateForbidden {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the backups create forbidden response
func (o *BackupsCreateForbidden) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *BackupsCreateForbidden) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(403)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// BackupsCreateUnprocessableEntityCode is the HTTP code returned for type BackupsCreateUnprocessableEntity
const BackupsCreateUnprocessableEntityCode int = 422

/*
BackupsCreateUnprocessableEntity Invalid backup creation request. Check the request body and backend configuration.

swagger:response backupsCreateUnprocessableEntity
*/
type BackupsCreateUnprocessableEntity struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewBackupsCreateUnprocessableEntity creates BackupsCreateUnprocessableEntity with default headers values
func NewBackupsCreateUnprocessableEntity() *BackupsCreateUnprocessableEntity {

	return &BackupsCreateUnprocessableEntity{}
}

// WithPayload adds the payload to the backups create unprocessable entity response
func (o *BackupsCreateUnprocessableEntity) WithPayload(payload *models.ErrorResponse) *BackupsCreateUnprocessableEntity {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the backups create unprocessable entity response
func (o *BackupsCreateUnprocessableEntity) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *BackupsCreateUnprocessableEntity) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(422)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// BackupsCreateInternalServerErrorCode is the HTTP code returned for type BackupsCreateInternalServerError
const BackupsCreateInternalServerErrorCode int = 500

/*
BackupsCreateInternalServerError An internal server error occurred during backup initiation. Check the ErrorResponse for details.

swagger:response backupsCreateInternalServerError
*/
type BackupsCreateInternalServerError struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewBackupsCreateInternalServerError creates BackupsCreateInternalServerError with default headers values
func NewBackupsCreateInternalServerError() *BackupsCreateInternalServerError {

	return &BackupsCreateInternalServerError{}
}

// WithPayload adds the payload to the backups create internal server error response
func (o *BackupsCreateInternalServerError) WithPayload(payload *models.ErrorResponse) *BackupsCreateInternalServerError {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the backups create internal server error response
func (o *BackupsCreateInternalServerError) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *BackupsCreateInternalServerError) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(500)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
