//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package backups

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/runtime/middleware"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/validate"
)

// NewBackupsListParams creates a new BackupsListParams object
// with the default values initialized.
func NewBackupsListParams() BackupsListParams {

	var (
		// initialize parameters with default values

		orderDefault = string("desc")
	)

	return BackupsListParams{
		Order: &orderDefault,
	}
}

// BackupsListParams contains all the bound params for the backups list operation
// typically these are obtained from a http.Request
//
// swagger:parameters backups.list
type BackupsListParams struct {

	// HTTP Request Object
	HTTPRequest *http.Request `json:"-"`

	/*Specifies the backend storage system to list backups from (e.g., `filesystem`, `gcs`, `s3`, `azure`).
	  Required: true
	  In: path
	*/
	Backend string
	/*Order of returned list of backups based on creation time. (asc or desc)
	  In: query
	  Default: "desc"
	*/
	Order *string
}

// BindRequest both binds and validates a request, it assumes that complex things implement a Validatable(strfmt.Registry) error interface
// for simple values it will use straight method calls.
//
// To ensure default values, the struct must have been initialized with NewBackupsListParams() beforehand.
func (o *BackupsListParams) BindRequest(r *http.Request, route *middleware.MatchedRoute) error {
	var res []error

	o.HTTPRequest = r

	qs := runtime.Values(r.URL.Query())

	rBackend, rhkBackend, _ := route.Params.GetOK("backend")
	if err := o.bindBackend(rBackend, rhkBackend, route.Formats); err != nil {
		res = append(res, err)
	}

	qOrder, qhkOrder, _ := qs.GetOK("order")
	if err := o.bindOrder(qOrder, qhkOrder, route.Formats); err != nil {
		res = append(res, err)
	}
	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindBackend binds and validates parameter Backend from path.
func (o *BackupsListParams) bindBackend(rawData []string, hasKey bool, formats strfmt.Registry) error {
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}

	// Required: true
	// Parameter is provided by construction from the route
	o.Backend = raw

	return nil
}

// bindOrder binds and validates parameter Order from query.
func (o *BackupsListParams) bindOrder(rawData []string, hasKey bool, formats strfmt.Registry) error {
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}

	// Required: false
	// AllowEmptyValue: false

	if raw == "" { // empty values pass all other validations
		// Default values have been previously initialized by NewBackupsListParams()
		return nil
	}
	o.Order = &raw

	if err := o.validateOrder(formats); err != nil {
		return err
	}

	return nil
}

// validateOrder carries on validations for parameter Order
func (o *BackupsListParams) validateOrder(formats strfmt.Registry) error {

	if err := validate.EnumCase("order", "query", *o.Order, []interface{}{"asc", "desc"}, true); err != nil {
		return err
	}

	return nil
}
