//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the generate command

import (
	"net/http"

	"github.com/go-openapi/runtime/middleware"

	"github.com/weaviate/weaviate/entities/models"
)

// ClusterGetStatisticsHandlerFunc turns a function with the right signature into a cluster get statistics handler
type ClusterGetStatisticsHandlerFunc func(ClusterGetStatisticsParams, *models.Principal) middleware.Responder

// Handle executing the request and returning a response
func (fn ClusterGetStatisticsHandlerFunc) Handle(params ClusterGetStatisticsParams, principal *models.Principal) middleware.Responder {
	return fn(params, principal)
}

// ClusterGetStatisticsHandler interface for that can handle valid cluster get statistics params
type ClusterGetStatisticsHandler interface {
	Handle(ClusterGetStatisticsParams, *models.Principal) middleware.Responder
}

// NewClusterGetStatistics creates a new http.Handler for the cluster get statistics operation
func NewClusterGetStatistics(ctx *middleware.Context, handler ClusterGetStatisticsHandler) *ClusterGetStatistics {
	return &ClusterGetStatistics{Context: ctx, Handler: handler}
}

/*
	ClusterGetStatistics swagger:route GET /cluster/statistics cluster clusterGetStatistics

# Get cluster statistics

Provides statistics about the internal Raft consensus protocol state for the Weaviate cluster.
*/
type ClusterGetStatistics struct {
	Context *middleware.Context
	Handler ClusterGetStatisticsHandler
}

func (o *ClusterGetStatistics) ServeHTTP(rw http.ResponseWriter, r *http.Request) {
	route, rCtx, _ := o.Context.RouteInfo(r)
	if rCtx != nil {
		*r = *rCtx
	}
	var Params = NewClusterGetStatisticsParams()
	uprinc, aCtx, err := o.Context.Authorize(r, route)
	if err != nil {
		o.Context.Respond(rw, r, route.Produces, route, err)
		return
	}
	if aCtx != nil {
		*r = *aCtx
	}
	var principal *models.Principal
	if uprinc != nil {
		principal = uprinc.(*models.Principal) // this is really a models.Principal, I promise
	}

	if err := o.Context.BindValidRequest(r, route, &Params); err != nil { // bind params
		o.Context.Respond(rw, r, route.Produces, route, err)
		return
	}

	res := o.Handler.Handle(Params, principal) // actually handle the request
	o.Context.Respond(rw, r, route.Produces, route, res)

}
