//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package distributed_tasks

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the generate command

import (
	"net/http"

	"github.com/go-openapi/runtime/middleware"

	"github.com/weaviate/weaviate/entities/models"
)

// DistributedTasksGetHandlerFunc turns a function with the right signature into a distributed tasks get handler
type DistributedTasksGetHandlerFunc func(DistributedTasksGetParams, *models.Principal) middleware.Responder

// Handle executing the request and returning a response
func (fn DistributedTasksGetHandlerFunc) Handle(params DistributedTasksGetParams, principal *models.Principal) middleware.Responder {
	return fn(params, principal)
}

// DistributedTasksGetHandler interface for that can handle valid distributed tasks get params
type DistributedTasksGetHandler interface {
	Handle(DistributedTasksGetParams, *models.Principal) middleware.Responder
}

// NewDistributedTasksGet creates a new http.Handler for the distributed tasks get operation
func NewDistributedTasksGet(ctx *middleware.Context, handler DistributedTasksGetHandler) *DistributedTasksGet {
	return &DistributedTasksGet{Context: ctx, Handler: handler}
}

/*
	DistributedTasksGet swagger:route GET /tasks distributedTasks distributedTasksGet

Lists all distributed tasks in the cluster
*/
type DistributedTasksGet struct {
	Context *middleware.Context
	Handler DistributedTasksGetHandler
}

func (o *DistributedTasksGet) ServeHTTP(rw http.ResponseWriter, r *http.Request) {
	route, rCtx, _ := o.Context.RouteInfo(r)
	if rCtx != nil {
		*r = *rCtx
	}
	var Params = NewDistributedTasksGetParams()
	uprinc, aCtx, err := o.Context.Authorize(r, route)
	if err != nil {
		o.Context.Respond(rw, r, route.Produces, route, err)
		return
	}
	if aCtx != nil {
		*r = *aCtx
	}
	var principal *models.Principal
	if uprinc != nil {
		principal = uprinc.(*models.Principal) // this is really a models.Principal, I promise
	}

	if err := o.Context.BindValidRequest(r, route, &Params); err != nil { // bind params
		o.Context.Respond(rw, r, route.Produces, route, err)
		return
	}

	res := o.Handler.Handle(Params, principal) // actually handle the request
	o.Context.Respond(rw, r, route.Produces, route, res)

}
