//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package distributed_tasks

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/weaviate/weaviate/entities/models"
)

// DistributedTasksGetOKCode is the HTTP code returned for type DistributedTasksGetOK
const DistributedTasksGetOKCode int = 200

/*
DistributedTasksGetOK Distributed tasks successfully returned.

swagger:response distributedTasksGetOK
*/
type DistributedTasksGetOK struct {

	/*
	  In: Body
	*/
	Payload models.DistributedTasks `json:"body,omitempty"`
}

// NewDistributedTasksGetOK creates DistributedTasksGetOK with default headers values
func NewDistributedTasksGetOK() *DistributedTasksGetOK {

	return &DistributedTasksGetOK{}
}

// WithPayload adds the payload to the distributed tasks get o k response
func (o *DistributedTasksGetOK) WithPayload(payload models.DistributedTasks) *DistributedTasksGetOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the distributed tasks get o k response
func (o *DistributedTasksGetOK) SetPayload(payload models.DistributedTasks) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DistributedTasksGetOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	payload := o.Payload
	if payload == nil {
		// return empty map
		payload = models.DistributedTasks{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

// DistributedTasksGetForbiddenCode is the HTTP code returned for type DistributedTasksGetForbidden
const DistributedTasksGetForbiddenCode int = 403

/*
DistributedTasksGetForbidden Unauthorized or invalid credentials.

swagger:response distributedTasksGetForbidden
*/
type DistributedTasksGetForbidden struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewDistributedTasksGetForbidden creates DistributedTasksGetForbidden with default headers values
func NewDistributedTasksGetForbidden() *DistributedTasksGetForbidden {

	return &DistributedTasksGetForbidden{}
}

// WithPayload adds the payload to the distributed tasks get forbidden response
func (o *DistributedTasksGetForbidden) WithPayload(payload *models.ErrorResponse) *DistributedTasksGetForbidden {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the distributed tasks get forbidden response
func (o *DistributedTasksGetForbidden) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DistributedTasksGetForbidden) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(403)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// DistributedTasksGetInternalServerErrorCode is the HTTP code returned for type DistributedTasksGetInternalServerError
const DistributedTasksGetInternalServerErrorCode int = 500

/*
DistributedTasksGetInternalServerError An internal server error occurred while retrieving distributed tasks. Check the ErrorResponse for details.

swagger:response distributedTasksGetInternalServerError
*/
type DistributedTasksGetInternalServerError struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewDistributedTasksGetInternalServerError creates DistributedTasksGetInternalServerError with default headers values
func NewDistributedTasksGetInternalServerError() *DistributedTasksGetInternalServerError {

	return &DistributedTasksGetInternalServerError{}
}

// WithPayload adds the payload to the distributed tasks get internal server error response
func (o *DistributedTasksGetInternalServerError) WithPayload(payload *models.ErrorResponse) *DistributedTasksGetInternalServerError {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the distributed tasks get internal server error response
func (o *DistributedTasksGetInternalServerError) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DistributedTasksGetInternalServerError) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(500)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
