//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package objects

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the generate command

import (
	"net/http"

	"github.com/go-openapi/runtime/middleware"

	"github.com/weaviate/weaviate/entities/models"
)

// ObjectsClassPatchHandlerFunc turns a function with the right signature into a objects class patch handler
type ObjectsClassPatchHandlerFunc func(ObjectsClassPatchParams, *models.Principal) middleware.Responder

// Handle executing the request and returning a response
func (fn ObjectsClassPatchHandlerFunc) Handle(params ObjectsClassPatchParams, principal *models.Principal) middleware.Responder {
	return fn(params, principal)
}

// ObjectsClassPatchHandler interface for that can handle valid objects class patch params
type ObjectsClassPatchHandler interface {
	Handle(ObjectsClassPatchParams, *models.Principal) middleware.Responder
}

// NewObjectsClassPatch creates a new http.Handler for the objects class patch operation
func NewObjectsClassPatch(ctx *middleware.Context, handler ObjectsClassPatchHandler) *ObjectsClassPatch {
	return &ObjectsClassPatch{Context: ctx, Handler: handler}
}

/*
	ObjectsClassPatch swagger:route PATCH /objects/{className}/{id} objects objectsClassPatch

# Patch an object

Updates specific properties of an existing data object using JSON merge patch semantics (RFC 7396). The object is identified by its collection name (`className`) and UUID (`id`). Only the fields provided in the request body are modified. Metadata and schema values are validated, and the object's `lastUpdateTimeUnix` is updated.
*/
type ObjectsClassPatch struct {
	Context *middleware.Context
	Handler ObjectsClassPatchHandler
}

func (o *ObjectsClassPatch) ServeHTTP(rw http.ResponseWriter, r *http.Request) {
	route, rCtx, _ := o.Context.RouteInfo(r)
	if rCtx != nil {
		*r = *rCtx
	}
	var Params = NewObjectsClassPatchParams()
	uprinc, aCtx, err := o.Context.Authorize(r, route)
	if err != nil {
		o.Context.Respond(rw, r, route.Produces, route, err)
		return
	}
	if aCtx != nil {
		*r = *aCtx
	}
	var principal *models.Principal
	if uprinc != nil {
		principal = uprinc.(*models.Principal) // this is really a models.Principal, I promise
	}

	if err := o.Context.BindValidRequest(r, route, &Params); err != nil { // bind params
		o.Context.Respond(rw, r, route.Produces, route, err)
		return
	}

	res := o.Handler.Handle(Params, principal) // actually handle the request
	o.Context.Respond(rw, r, route.Produces, route, res)

}
