//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package objects

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the generate command

import (
	"net/http"

	"github.com/go-openapi/runtime/middleware"

	"github.com/weaviate/weaviate/entities/models"
)

// ObjectsClassReferencesDeleteHandlerFunc turns a function with the right signature into a objects class references delete handler
type ObjectsClassReferencesDeleteHandlerFunc func(ObjectsClassReferencesDeleteParams, *models.Principal) middleware.Responder

// Handle executing the request and returning a response
func (fn ObjectsClassReferencesDeleteHandlerFunc) Handle(params ObjectsClassReferencesDeleteParams, principal *models.Principal) middleware.Responder {
	return fn(params, principal)
}

// ObjectsClassReferencesDeleteHandler interface for that can handle valid objects class references delete params
type ObjectsClassReferencesDeleteHandler interface {
	Handle(ObjectsClassReferencesDeleteParams, *models.Principal) middleware.Responder
}

// NewObjectsClassReferencesDelete creates a new http.Handler for the objects class references delete operation
func NewObjectsClassReferencesDelete(ctx *middleware.Context, handler ObjectsClassReferencesDeleteHandler) *ObjectsClassReferencesDelete {
	return &ObjectsClassReferencesDelete{Context: ctx, Handler: handler}
}

/*
	ObjectsClassReferencesDelete swagger:route DELETE /objects/{className}/{id}/references/{propertyName} objects objectsClassReferencesDelete

# Delete an object reference

Removes a specific reference from a reference property (`propertyName`) of a source data object. The source object is identified by its collection name (`className`) and UUID (`id`). The reference to remove is specified in the request body.
*/
type ObjectsClassReferencesDelete struct {
	Context *middleware.Context
	Handler ObjectsClassReferencesDeleteHandler
}

func (o *ObjectsClassReferencesDelete) ServeHTTP(rw http.ResponseWriter, r *http.Request) {
	route, rCtx, _ := o.Context.RouteInfo(r)
	if rCtx != nil {
		*r = *rCtx
	}
	var Params = NewObjectsClassReferencesDeleteParams()
	uprinc, aCtx, err := o.Context.Authorize(r, route)
	if err != nil {
		o.Context.Respond(rw, r, route.Produces, route, err)
		return
	}
	if aCtx != nil {
		*r = *aCtx
	}
	var principal *models.Principal
	if uprinc != nil {
		principal = uprinc.(*models.Principal) // this is really a models.Principal, I promise
	}

	if err := o.Context.BindValidRequest(r, route, &Params); err != nil { // bind params
		o.Context.Respond(rw, r, route.Produces, route, err)
		return
	}

	res := o.Handler.Handle(Params, principal) // actually handle the request
	o.Context.Respond(rw, r, route.Produces, route, res)

}
