//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package objects

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/weaviate/weaviate/entities/models"
)

// ObjectsClassReferencesPutOKCode is the HTTP code returned for type ObjectsClassReferencesPutOK
const ObjectsClassReferencesPutOKCode int = 200

/*
ObjectsClassReferencesPutOK References replaced successfully.

swagger:response objectsClassReferencesPutOK
*/
type ObjectsClassReferencesPutOK struct {
}

// NewObjectsClassReferencesPutOK creates ObjectsClassReferencesPutOK with default headers values
func NewObjectsClassReferencesPutOK() *ObjectsClassReferencesPutOK {

	return &ObjectsClassReferencesPutOK{}
}

// WriteResponse to the client
func (o *ObjectsClassReferencesPutOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(200)
}

// ObjectsClassReferencesPutBadRequestCode is the HTTP code returned for type ObjectsClassReferencesPutBadRequest
const ObjectsClassReferencesPutBadRequestCode int = 400

/*
ObjectsClassReferencesPutBadRequest Malformed request.

swagger:response objectsClassReferencesPutBadRequest
*/
type ObjectsClassReferencesPutBadRequest struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewObjectsClassReferencesPutBadRequest creates ObjectsClassReferencesPutBadRequest with default headers values
func NewObjectsClassReferencesPutBadRequest() *ObjectsClassReferencesPutBadRequest {

	return &ObjectsClassReferencesPutBadRequest{}
}

// WithPayload adds the payload to the objects class references put bad request response
func (o *ObjectsClassReferencesPutBadRequest) WithPayload(payload *models.ErrorResponse) *ObjectsClassReferencesPutBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the objects class references put bad request response
func (o *ObjectsClassReferencesPutBadRequest) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ObjectsClassReferencesPutBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ObjectsClassReferencesPutUnauthorizedCode is the HTTP code returned for type ObjectsClassReferencesPutUnauthorized
const ObjectsClassReferencesPutUnauthorizedCode int = 401

/*
ObjectsClassReferencesPutUnauthorized Unauthorized or invalid credentials.

swagger:response objectsClassReferencesPutUnauthorized
*/
type ObjectsClassReferencesPutUnauthorized struct {
}

// NewObjectsClassReferencesPutUnauthorized creates ObjectsClassReferencesPutUnauthorized with default headers values
func NewObjectsClassReferencesPutUnauthorized() *ObjectsClassReferencesPutUnauthorized {

	return &ObjectsClassReferencesPutUnauthorized{}
}

// WriteResponse to the client
func (o *ObjectsClassReferencesPutUnauthorized) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(401)
}

// ObjectsClassReferencesPutForbiddenCode is the HTTP code returned for type ObjectsClassReferencesPutForbidden
const ObjectsClassReferencesPutForbiddenCode int = 403

/*
ObjectsClassReferencesPutForbidden Forbidden

swagger:response objectsClassReferencesPutForbidden
*/
type ObjectsClassReferencesPutForbidden struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewObjectsClassReferencesPutForbidden creates ObjectsClassReferencesPutForbidden with default headers values
func NewObjectsClassReferencesPutForbidden() *ObjectsClassReferencesPutForbidden {

	return &ObjectsClassReferencesPutForbidden{}
}

// WithPayload adds the payload to the objects class references put forbidden response
func (o *ObjectsClassReferencesPutForbidden) WithPayload(payload *models.ErrorResponse) *ObjectsClassReferencesPutForbidden {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the objects class references put forbidden response
func (o *ObjectsClassReferencesPutForbidden) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ObjectsClassReferencesPutForbidden) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(403)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ObjectsClassReferencesPutNotFoundCode is the HTTP code returned for type ObjectsClassReferencesPutNotFound
const ObjectsClassReferencesPutNotFoundCode int = 404

/*
ObjectsClassReferencesPutNotFound Source object not found.

swagger:response objectsClassReferencesPutNotFound
*/
type ObjectsClassReferencesPutNotFound struct {
}

// NewObjectsClassReferencesPutNotFound creates ObjectsClassReferencesPutNotFound with default headers values
func NewObjectsClassReferencesPutNotFound() *ObjectsClassReferencesPutNotFound {

	return &ObjectsClassReferencesPutNotFound{}
}

// WriteResponse to the client
func (o *ObjectsClassReferencesPutNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(404)
}

// ObjectsClassReferencesPutUnprocessableEntityCode is the HTTP code returned for type ObjectsClassReferencesPutUnprocessableEntity
const ObjectsClassReferencesPutUnprocessableEntityCode int = 422

/*
ObjectsClassReferencesPutUnprocessableEntity The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request. Ensure the property exists and is a reference type.

swagger:response objectsClassReferencesPutUnprocessableEntity
*/
type ObjectsClassReferencesPutUnprocessableEntity struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewObjectsClassReferencesPutUnprocessableEntity creates ObjectsClassReferencesPutUnprocessableEntity with default headers values
func NewObjectsClassReferencesPutUnprocessableEntity() *ObjectsClassReferencesPutUnprocessableEntity {

	return &ObjectsClassReferencesPutUnprocessableEntity{}
}

// WithPayload adds the payload to the objects class references put unprocessable entity response
func (o *ObjectsClassReferencesPutUnprocessableEntity) WithPayload(payload *models.ErrorResponse) *ObjectsClassReferencesPutUnprocessableEntity {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the objects class references put unprocessable entity response
func (o *ObjectsClassReferencesPutUnprocessableEntity) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ObjectsClassReferencesPutUnprocessableEntity) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(422)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ObjectsClassReferencesPutInternalServerErrorCode is the HTTP code returned for type ObjectsClassReferencesPutInternalServerError
const ObjectsClassReferencesPutInternalServerErrorCode int = 500

/*
ObjectsClassReferencesPutInternalServerError An error occurred while trying to fulfill the request. Check the ErrorResponse for details.

swagger:response objectsClassReferencesPutInternalServerError
*/
type ObjectsClassReferencesPutInternalServerError struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewObjectsClassReferencesPutInternalServerError creates ObjectsClassReferencesPutInternalServerError with default headers values
func NewObjectsClassReferencesPutInternalServerError() *ObjectsClassReferencesPutInternalServerError {

	return &ObjectsClassReferencesPutInternalServerError{}
}

// WithPayload adds the payload to the objects class references put internal server error response
func (o *ObjectsClassReferencesPutInternalServerError) WithPayload(payload *models.ErrorResponse) *ObjectsClassReferencesPutInternalServerError {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the objects class references put internal server error response
func (o *ObjectsClassReferencesPutInternalServerError) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ObjectsClassReferencesPutInternalServerError) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(500)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
