//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package objects

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/weaviate/weaviate/entities/models"
)

// ObjectsDeleteNoContentCode is the HTTP code returned for type ObjectsDeleteNoContent
const ObjectsDeleteNoContentCode int = 204

/*
ObjectsDeleteNoContent Object deleted successfully.

swagger:response objectsDeleteNoContent
*/
type ObjectsDeleteNoContent struct {
}

// NewObjectsDeleteNoContent creates ObjectsDeleteNoContent with default headers values
func NewObjectsDeleteNoContent() *ObjectsDeleteNoContent {

	return &ObjectsDeleteNoContent{}
}

// WriteResponse to the client
func (o *ObjectsDeleteNoContent) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(204)
}

// ObjectsDeleteUnauthorizedCode is the HTTP code returned for type ObjectsDeleteUnauthorized
const ObjectsDeleteUnauthorizedCode int = 401

/*
ObjectsDeleteUnauthorized Unauthorized or invalid credentials.

swagger:response objectsDeleteUnauthorized
*/
type ObjectsDeleteUnauthorized struct {
}

// NewObjectsDeleteUnauthorized creates ObjectsDeleteUnauthorized with default headers values
func NewObjectsDeleteUnauthorized() *ObjectsDeleteUnauthorized {

	return &ObjectsDeleteUnauthorized{}
}

// WriteResponse to the client
func (o *ObjectsDeleteUnauthorized) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(401)
}

// ObjectsDeleteForbiddenCode is the HTTP code returned for type ObjectsDeleteForbidden
const ObjectsDeleteForbiddenCode int = 403

/*
ObjectsDeleteForbidden Forbidden

swagger:response objectsDeleteForbidden
*/
type ObjectsDeleteForbidden struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewObjectsDeleteForbidden creates ObjectsDeleteForbidden with default headers values
func NewObjectsDeleteForbidden() *ObjectsDeleteForbidden {

	return &ObjectsDeleteForbidden{}
}

// WithPayload adds the payload to the objects delete forbidden response
func (o *ObjectsDeleteForbidden) WithPayload(payload *models.ErrorResponse) *ObjectsDeleteForbidden {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the objects delete forbidden response
func (o *ObjectsDeleteForbidden) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ObjectsDeleteForbidden) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(403)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ObjectsDeleteNotFoundCode is the HTTP code returned for type ObjectsDeleteNotFound
const ObjectsDeleteNotFoundCode int = 404

/*
ObjectsDeleteNotFound Object not found.

swagger:response objectsDeleteNotFound
*/
type ObjectsDeleteNotFound struct {
}

// NewObjectsDeleteNotFound creates ObjectsDeleteNotFound with default headers values
func NewObjectsDeleteNotFound() *ObjectsDeleteNotFound {

	return &ObjectsDeleteNotFound{}
}

// WriteResponse to the client
func (o *ObjectsDeleteNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(404)
}

// ObjectsDeleteInternalServerErrorCode is the HTTP code returned for type ObjectsDeleteInternalServerError
const ObjectsDeleteInternalServerErrorCode int = 500

/*
ObjectsDeleteInternalServerError An error occurred while trying to fulfill the request. Check the ErrorResponse for details.

swagger:response objectsDeleteInternalServerError
*/
type ObjectsDeleteInternalServerError struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewObjectsDeleteInternalServerError creates ObjectsDeleteInternalServerError with default headers values
func NewObjectsDeleteInternalServerError() *ObjectsDeleteInternalServerError {

	return &ObjectsDeleteInternalServerError{}
}

// WithPayload adds the payload to the objects delete internal server error response
func (o *ObjectsDeleteInternalServerError) WithPayload(payload *models.ErrorResponse) *ObjectsDeleteInternalServerError {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the objects delete internal server error response
func (o *ObjectsDeleteInternalServerError) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ObjectsDeleteInternalServerError) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(500)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
