//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package replication

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the generate command

import (
	"net/http"

	"github.com/go-openapi/runtime/middleware"

	"github.com/weaviate/weaviate/entities/models"
)

// ApplyReplicationScalePlanHandlerFunc turns a function with the right signature into a apply replication scale plan handler
type ApplyReplicationScalePlanHandlerFunc func(ApplyReplicationScalePlanParams, *models.Principal) middleware.Responder

// Handle executing the request and returning a response
func (fn ApplyReplicationScalePlanHandlerFunc) Handle(params ApplyReplicationScalePlanParams, principal *models.Principal) middleware.Responder {
	return fn(params, principal)
}

// ApplyReplicationScalePlanHandler interface for that can handle valid apply replication scale plan params
type ApplyReplicationScalePlanHandler interface {
	Handle(ApplyReplicationScalePlanParams, *models.Principal) middleware.Responder
}

// NewApplyReplicationScalePlan creates a new http.Handler for the apply replication scale plan operation
func NewApplyReplicationScalePlan(ctx *middleware.Context, handler ApplyReplicationScalePlanHandler) *ApplyReplicationScalePlan {
	return &ApplyReplicationScalePlan{Context: ctx, Handler: handler}
}

/*
	ApplyReplicationScalePlan swagger:route POST /replication/scale replication applyReplicationScalePlan

# Apply replication scaling plan

Apply a replication scaling plan that specifies nodes to add or remove per shard for a given collection.
*/
type ApplyReplicationScalePlan struct {
	Context *middleware.Context
	Handler ApplyReplicationScalePlanHandler
}

func (o *ApplyReplicationScalePlan) ServeHTTP(rw http.ResponseWriter, r *http.Request) {
	route, rCtx, _ := o.Context.RouteInfo(r)
	if rCtx != nil {
		*r = *rCtx
	}
	var Params = NewApplyReplicationScalePlanParams()
	uprinc, aCtx, err := o.Context.Authorize(r, route)
	if err != nil {
		o.Context.Respond(rw, r, route.Produces, route, err)
		return
	}
	if aCtx != nil {
		*r = *aCtx
	}
	var principal *models.Principal
	if uprinc != nil {
		principal = uprinc.(*models.Principal) // this is really a models.Principal, I promise
	}

	if err := o.Context.BindValidRequest(r, route, &Params); err != nil { // bind params
		o.Context.Respond(rw, r, route.Produces, route, err)
		return
	}

	res := o.Handler.Handle(Params, principal) // actually handle the request
	o.Context.Respond(rw, r, route.Produces, route, res)

}
