//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package replication

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the generate command

import (
	"net/http"

	"github.com/go-openapi/runtime/middleware"

	"github.com/weaviate/weaviate/entities/models"
)

// DeleteReplicationHandlerFunc turns a function with the right signature into a delete replication handler
type DeleteReplicationHandlerFunc func(DeleteReplicationParams, *models.Principal) middleware.Responder

// Handle executing the request and returning a response
func (fn DeleteReplicationHandlerFunc) Handle(params DeleteReplicationParams, principal *models.Principal) middleware.Responder {
	return fn(params, principal)
}

// DeleteReplicationHandler interface for that can handle valid delete replication params
type DeleteReplicationHandler interface {
	Handle(DeleteReplicationParams, *models.Principal) middleware.Responder
}

// NewDeleteReplication creates a new http.Handler for the delete replication operation
func NewDeleteReplication(ctx *middleware.Context, handler DeleteReplicationHandler) *DeleteReplication {
	return &DeleteReplication{Context: ctx, Handler: handler}
}

/*
	DeleteReplication swagger:route DELETE /replication/replicate/{id} replication deleteReplication

# Delete a replication operation

Removes a specific replication operation. If the operation is currently active, it will be cancelled and its resources cleaned up before the operation is deleted.
*/
type DeleteReplication struct {
	Context *middleware.Context
	Handler DeleteReplicationHandler
}

func (o *DeleteReplication) ServeHTTP(rw http.ResponseWriter, r *http.Request) {
	route, rCtx, _ := o.Context.RouteInfo(r)
	if rCtx != nil {
		*r = *rCtx
	}
	var Params = NewDeleteReplicationParams()
	uprinc, aCtx, err := o.Context.Authorize(r, route)
	if err != nil {
		o.Context.Respond(rw, r, route.Produces, route, err)
		return
	}
	if aCtx != nil {
		*r = *aCtx
	}
	var principal *models.Principal
	if uprinc != nil {
		principal = uprinc.(*models.Principal) // this is really a models.Principal, I promise
	}

	if err := o.Context.BindValidRequest(r, route, &Params); err != nil { // bind params
		o.Context.Respond(rw, r, route.Produces, route, err)
		return
	}

	res := o.Handler.Handle(Params, principal) // actually handle the request
	o.Context.Respond(rw, r, route.Produces, route, res)

}
