//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package replication

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/weaviate/weaviate/entities/models"
)

// DeleteReplicationNoContentCode is the HTTP code returned for type DeleteReplicationNoContent
const DeleteReplicationNoContentCode int = 204

/*
DeleteReplicationNoContent Successfully deleted.

swagger:response deleteReplicationNoContent
*/
type DeleteReplicationNoContent struct {
}

// NewDeleteReplicationNoContent creates DeleteReplicationNoContent with default headers values
func NewDeleteReplicationNoContent() *DeleteReplicationNoContent {

	return &DeleteReplicationNoContent{}
}

// WriteResponse to the client
func (o *DeleteReplicationNoContent) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(204)
}

// DeleteReplicationUnauthorizedCode is the HTTP code returned for type DeleteReplicationUnauthorized
const DeleteReplicationUnauthorizedCode int = 401

/*
DeleteReplicationUnauthorized Unauthorized or invalid credentials.

swagger:response deleteReplicationUnauthorized
*/
type DeleteReplicationUnauthorized struct {
}

// NewDeleteReplicationUnauthorized creates DeleteReplicationUnauthorized with default headers values
func NewDeleteReplicationUnauthorized() *DeleteReplicationUnauthorized {

	return &DeleteReplicationUnauthorized{}
}

// WriteResponse to the client
func (o *DeleteReplicationUnauthorized) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(401)
}

// DeleteReplicationForbiddenCode is the HTTP code returned for type DeleteReplicationForbidden
const DeleteReplicationForbiddenCode int = 403

/*
DeleteReplicationForbidden Forbidden.

swagger:response deleteReplicationForbidden
*/
type DeleteReplicationForbidden struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewDeleteReplicationForbidden creates DeleteReplicationForbidden with default headers values
func NewDeleteReplicationForbidden() *DeleteReplicationForbidden {

	return &DeleteReplicationForbidden{}
}

// WithPayload adds the payload to the delete replication forbidden response
func (o *DeleteReplicationForbidden) WithPayload(payload *models.ErrorResponse) *DeleteReplicationForbidden {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete replication forbidden response
func (o *DeleteReplicationForbidden) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteReplicationForbidden) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(403)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// DeleteReplicationNotFoundCode is the HTTP code returned for type DeleteReplicationNotFound
const DeleteReplicationNotFoundCode int = 404

/*
DeleteReplicationNotFound Shard replica operation not found.

swagger:response deleteReplicationNotFound
*/
type DeleteReplicationNotFound struct {
}

// NewDeleteReplicationNotFound creates DeleteReplicationNotFound with default headers values
func NewDeleteReplicationNotFound() *DeleteReplicationNotFound {

	return &DeleteReplicationNotFound{}
}

// WriteResponse to the client
func (o *DeleteReplicationNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(404)
}

// DeleteReplicationConflictCode is the HTTP code returned for type DeleteReplicationConflict
const DeleteReplicationConflictCode int = 409

/*
DeleteReplicationConflict The operation is not in a deletable state, e.g. it is a MOVE op in the DEHYDRATING state.

swagger:response deleteReplicationConflict
*/
type DeleteReplicationConflict struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewDeleteReplicationConflict creates DeleteReplicationConflict with default headers values
func NewDeleteReplicationConflict() *DeleteReplicationConflict {

	return &DeleteReplicationConflict{}
}

// WithPayload adds the payload to the delete replication conflict response
func (o *DeleteReplicationConflict) WithPayload(payload *models.ErrorResponse) *DeleteReplicationConflict {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete replication conflict response
func (o *DeleteReplicationConflict) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteReplicationConflict) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(409)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// DeleteReplicationUnprocessableEntityCode is the HTTP code returned for type DeleteReplicationUnprocessableEntity
const DeleteReplicationUnprocessableEntityCode int = 422

/*
DeleteReplicationUnprocessableEntity The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request.

swagger:response deleteReplicationUnprocessableEntity
*/
type DeleteReplicationUnprocessableEntity struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewDeleteReplicationUnprocessableEntity creates DeleteReplicationUnprocessableEntity with default headers values
func NewDeleteReplicationUnprocessableEntity() *DeleteReplicationUnprocessableEntity {

	return &DeleteReplicationUnprocessableEntity{}
}

// WithPayload adds the payload to the delete replication unprocessable entity response
func (o *DeleteReplicationUnprocessableEntity) WithPayload(payload *models.ErrorResponse) *DeleteReplicationUnprocessableEntity {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete replication unprocessable entity response
func (o *DeleteReplicationUnprocessableEntity) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteReplicationUnprocessableEntity) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(422)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// DeleteReplicationInternalServerErrorCode is the HTTP code returned for type DeleteReplicationInternalServerError
const DeleteReplicationInternalServerErrorCode int = 500

/*
DeleteReplicationInternalServerError An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.

swagger:response deleteReplicationInternalServerError
*/
type DeleteReplicationInternalServerError struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewDeleteReplicationInternalServerError creates DeleteReplicationInternalServerError with default headers values
func NewDeleteReplicationInternalServerError() *DeleteReplicationInternalServerError {

	return &DeleteReplicationInternalServerError{}
}

// WithPayload adds the payload to the delete replication internal server error response
func (o *DeleteReplicationInternalServerError) WithPayload(payload *models.ErrorResponse) *DeleteReplicationInternalServerError {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete replication internal server error response
func (o *DeleteReplicationInternalServerError) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteReplicationInternalServerError) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(500)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// DeleteReplicationNotImplementedCode is the HTTP code returned for type DeleteReplicationNotImplemented
const DeleteReplicationNotImplementedCode int = 501

/*
DeleteReplicationNotImplemented Replica movement operations are disabled.

swagger:response deleteReplicationNotImplemented
*/
type DeleteReplicationNotImplemented struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewDeleteReplicationNotImplemented creates DeleteReplicationNotImplemented with default headers values
func NewDeleteReplicationNotImplemented() *DeleteReplicationNotImplemented {

	return &DeleteReplicationNotImplemented{}
}

// WithPayload adds the payload to the delete replication not implemented response
func (o *DeleteReplicationNotImplemented) WithPayload(payload *models.ErrorResponse) *DeleteReplicationNotImplemented {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete replication not implemented response
func (o *DeleteReplicationNotImplemented) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteReplicationNotImplemented) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(501)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
