//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package replication

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/weaviate/weaviate/entities/models"
)

// ForceDeleteReplicationsOKCode is the HTTP code returned for type ForceDeleteReplicationsOK
const ForceDeleteReplicationsOKCode int = 200

/*
ForceDeleteReplicationsOK Replication operations force deleted successfully.

swagger:response forceDeleteReplicationsOK
*/
type ForceDeleteReplicationsOK struct {

	/*
	  In: Body
	*/
	Payload *models.ReplicationReplicateForceDeleteResponse `json:"body,omitempty"`
}

// NewForceDeleteReplicationsOK creates ForceDeleteReplicationsOK with default headers values
func NewForceDeleteReplicationsOK() *ForceDeleteReplicationsOK {

	return &ForceDeleteReplicationsOK{}
}

// WithPayload adds the payload to the force delete replications o k response
func (o *ForceDeleteReplicationsOK) WithPayload(payload *models.ReplicationReplicateForceDeleteResponse) *ForceDeleteReplicationsOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the force delete replications o k response
func (o *ForceDeleteReplicationsOK) SetPayload(payload *models.ReplicationReplicateForceDeleteResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ForceDeleteReplicationsOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ForceDeleteReplicationsBadRequestCode is the HTTP code returned for type ForceDeleteReplicationsBadRequest
const ForceDeleteReplicationsBadRequestCode int = 400

/*
ForceDeleteReplicationsBadRequest Malformed request.

swagger:response forceDeleteReplicationsBadRequest
*/
type ForceDeleteReplicationsBadRequest struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewForceDeleteReplicationsBadRequest creates ForceDeleteReplicationsBadRequest with default headers values
func NewForceDeleteReplicationsBadRequest() *ForceDeleteReplicationsBadRequest {

	return &ForceDeleteReplicationsBadRequest{}
}

// WithPayload adds the payload to the force delete replications bad request response
func (o *ForceDeleteReplicationsBadRequest) WithPayload(payload *models.ErrorResponse) *ForceDeleteReplicationsBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the force delete replications bad request response
func (o *ForceDeleteReplicationsBadRequest) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ForceDeleteReplicationsBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ForceDeleteReplicationsUnauthorizedCode is the HTTP code returned for type ForceDeleteReplicationsUnauthorized
const ForceDeleteReplicationsUnauthorizedCode int = 401

/*
ForceDeleteReplicationsUnauthorized Unauthorized or invalid credentials.

swagger:response forceDeleteReplicationsUnauthorized
*/
type ForceDeleteReplicationsUnauthorized struct {
}

// NewForceDeleteReplicationsUnauthorized creates ForceDeleteReplicationsUnauthorized with default headers values
func NewForceDeleteReplicationsUnauthorized() *ForceDeleteReplicationsUnauthorized {

	return &ForceDeleteReplicationsUnauthorized{}
}

// WriteResponse to the client
func (o *ForceDeleteReplicationsUnauthorized) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(401)
}

// ForceDeleteReplicationsForbiddenCode is the HTTP code returned for type ForceDeleteReplicationsForbidden
const ForceDeleteReplicationsForbiddenCode int = 403

/*
ForceDeleteReplicationsForbidden Forbidden

swagger:response forceDeleteReplicationsForbidden
*/
type ForceDeleteReplicationsForbidden struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewForceDeleteReplicationsForbidden creates ForceDeleteReplicationsForbidden with default headers values
func NewForceDeleteReplicationsForbidden() *ForceDeleteReplicationsForbidden {

	return &ForceDeleteReplicationsForbidden{}
}

// WithPayload adds the payload to the force delete replications forbidden response
func (o *ForceDeleteReplicationsForbidden) WithPayload(payload *models.ErrorResponse) *ForceDeleteReplicationsForbidden {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the force delete replications forbidden response
func (o *ForceDeleteReplicationsForbidden) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ForceDeleteReplicationsForbidden) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(403)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ForceDeleteReplicationsUnprocessableEntityCode is the HTTP code returned for type ForceDeleteReplicationsUnprocessableEntity
const ForceDeleteReplicationsUnprocessableEntityCode int = 422

/*
ForceDeleteReplicationsUnprocessableEntity The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request.

swagger:response forceDeleteReplicationsUnprocessableEntity
*/
type ForceDeleteReplicationsUnprocessableEntity struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewForceDeleteReplicationsUnprocessableEntity creates ForceDeleteReplicationsUnprocessableEntity with default headers values
func NewForceDeleteReplicationsUnprocessableEntity() *ForceDeleteReplicationsUnprocessableEntity {

	return &ForceDeleteReplicationsUnprocessableEntity{}
}

// WithPayload adds the payload to the force delete replications unprocessable entity response
func (o *ForceDeleteReplicationsUnprocessableEntity) WithPayload(payload *models.ErrorResponse) *ForceDeleteReplicationsUnprocessableEntity {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the force delete replications unprocessable entity response
func (o *ForceDeleteReplicationsUnprocessableEntity) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ForceDeleteReplicationsUnprocessableEntity) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(422)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ForceDeleteReplicationsInternalServerErrorCode is the HTTP code returned for type ForceDeleteReplicationsInternalServerError
const ForceDeleteReplicationsInternalServerErrorCode int = 500

/*
ForceDeleteReplicationsInternalServerError An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.

swagger:response forceDeleteReplicationsInternalServerError
*/
type ForceDeleteReplicationsInternalServerError struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewForceDeleteReplicationsInternalServerError creates ForceDeleteReplicationsInternalServerError with default headers values
func NewForceDeleteReplicationsInternalServerError() *ForceDeleteReplicationsInternalServerError {

	return &ForceDeleteReplicationsInternalServerError{}
}

// WithPayload adds the payload to the force delete replications internal server error response
func (o *ForceDeleteReplicationsInternalServerError) WithPayload(payload *models.ErrorResponse) *ForceDeleteReplicationsInternalServerError {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the force delete replications internal server error response
func (o *ForceDeleteReplicationsInternalServerError) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ForceDeleteReplicationsInternalServerError) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(500)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
