//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package replication

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the generate command

import (
	"net/http"

	"github.com/go-openapi/runtime/middleware"

	"github.com/weaviate/weaviate/entities/models"
)

// GetReplicationScalePlanHandlerFunc turns a function with the right signature into a get replication scale plan handler
type GetReplicationScalePlanHandlerFunc func(GetReplicationScalePlanParams, *models.Principal) middleware.Responder

// Handle executing the request and returning a response
func (fn GetReplicationScalePlanHandlerFunc) Handle(params GetReplicationScalePlanParams, principal *models.Principal) middleware.Responder {
	return fn(params, principal)
}

// GetReplicationScalePlanHandler interface for that can handle valid get replication scale plan params
type GetReplicationScalePlanHandler interface {
	Handle(GetReplicationScalePlanParams, *models.Principal) middleware.Responder
}

// NewGetReplicationScalePlan creates a new http.Handler for the get replication scale plan operation
func NewGetReplicationScalePlan(ctx *middleware.Context, handler GetReplicationScalePlanHandler) *GetReplicationScalePlan {
	return &GetReplicationScalePlan{Context: ctx, Handler: handler}
}

/*
	GetReplicationScalePlan swagger:route GET /replication/scale replication getReplicationScalePlan

# Get replication scale plan

Computes and returns a replication scale plan for a given collection and desired replication factor. The plan includes, for each shard, a list of nodes to be added and a list of nodes to be removed.
*/
type GetReplicationScalePlan struct {
	Context *middleware.Context
	Handler GetReplicationScalePlanHandler
}

func (o *GetReplicationScalePlan) ServeHTTP(rw http.ResponseWriter, r *http.Request) {
	route, rCtx, _ := o.Context.RouteInfo(r)
	if rCtx != nil {
		*r = *rCtx
	}
	var Params = NewGetReplicationScalePlanParams()
	uprinc, aCtx, err := o.Context.Authorize(r, route)
	if err != nil {
		o.Context.Respond(rw, r, route.Produces, route, err)
		return
	}
	if aCtx != nil {
		*r = *aCtx
	}
	var principal *models.Principal
	if uprinc != nil {
		principal = uprinc.(*models.Principal) // this is really a models.Principal, I promise
	}

	if err := o.Context.BindValidRequest(r, route, &Params); err != nil { // bind params
		o.Context.Respond(rw, r, route.Produces, route, err)
		return
	}

	res := o.Handler.Handle(Params, principal) // actually handle the request
	o.Context.Respond(rw, r, route.Produces, route, res)

}
