//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package replication

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/runtime/middleware"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// NewGetReplicationScalePlanParams creates a new GetReplicationScalePlanParams object
//
// There are no default values defined in the spec.
func NewGetReplicationScalePlanParams() GetReplicationScalePlanParams {

	return GetReplicationScalePlanParams{}
}

// GetReplicationScalePlanParams contains all the bound params for the get replication scale plan operation
// typically these are obtained from a http.Request
//
// swagger:parameters getReplicationScalePlan
type GetReplicationScalePlanParams struct {

	// HTTP Request Object
	HTTPRequest *http.Request `json:"-"`

	/*The collection name to get the scaling plan for.
	  Required: true
	  In: query
	*/
	Collection string
	/*The desired replication factor to scale to. Must be a positive integer greater than zero.
	  Required: true
	  Minimum: 1
	  In: query
	*/
	ReplicationFactor int64
}

// BindRequest both binds and validates a request, it assumes that complex things implement a Validatable(strfmt.Registry) error interface
// for simple values it will use straight method calls.
//
// To ensure default values, the struct must have been initialized with NewGetReplicationScalePlanParams() beforehand.
func (o *GetReplicationScalePlanParams) BindRequest(r *http.Request, route *middleware.MatchedRoute) error {
	var res []error

	o.HTTPRequest = r

	qs := runtime.Values(r.URL.Query())

	qCollection, qhkCollection, _ := qs.GetOK("collection")
	if err := o.bindCollection(qCollection, qhkCollection, route.Formats); err != nil {
		res = append(res, err)
	}

	qReplicationFactor, qhkReplicationFactor, _ := qs.GetOK("replicationFactor")
	if err := o.bindReplicationFactor(qReplicationFactor, qhkReplicationFactor, route.Formats); err != nil {
		res = append(res, err)
	}
	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindCollection binds and validates parameter Collection from query.
func (o *GetReplicationScalePlanParams) bindCollection(rawData []string, hasKey bool, formats strfmt.Registry) error {
	if !hasKey {
		return errors.Required("collection", "query", rawData)
	}
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}

	// Required: true
	// AllowEmptyValue: false

	if err := validate.RequiredString("collection", "query", raw); err != nil {
		return err
	}
	o.Collection = raw

	return nil
}

// bindReplicationFactor binds and validates parameter ReplicationFactor from query.
func (o *GetReplicationScalePlanParams) bindReplicationFactor(rawData []string, hasKey bool, formats strfmt.Registry) error {
	if !hasKey {
		return errors.Required("replicationFactor", "query", rawData)
	}
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}

	// Required: true
	// AllowEmptyValue: false

	if err := validate.RequiredString("replicationFactor", "query", raw); err != nil {
		return err
	}

	value, err := swag.ConvertInt64(raw)
	if err != nil {
		return errors.InvalidType("replicationFactor", "query", "int64", raw)
	}
	o.ReplicationFactor = value

	if err := o.validateReplicationFactor(formats); err != nil {
		return err
	}

	return nil
}

// validateReplicationFactor carries on validations for parameter ReplicationFactor
func (o *GetReplicationScalePlanParams) validateReplicationFactor(formats strfmt.Registry) error {

	if err := validate.MinimumInt("replicationFactor", "query", o.ReplicationFactor, 1, false); err != nil {
		return err
	}

	return nil
}
