//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package replication

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/weaviate/weaviate/entities/models"
)

// GetReplicationScalePlanOKCode is the HTTP code returned for type GetReplicationScalePlanOK
const GetReplicationScalePlanOKCode int = 200

/*
GetReplicationScalePlanOK Replication scale plan showing node additions and removals per shard.

swagger:response getReplicationScalePlanOK
*/
type GetReplicationScalePlanOK struct {

	/*
	  In: Body
	*/
	Payload *models.ReplicationScalePlan `json:"body,omitempty"`
}

// NewGetReplicationScalePlanOK creates GetReplicationScalePlanOK with default headers values
func NewGetReplicationScalePlanOK() *GetReplicationScalePlanOK {

	return &GetReplicationScalePlanOK{}
}

// WithPayload adds the payload to the get replication scale plan o k response
func (o *GetReplicationScalePlanOK) WithPayload(payload *models.ReplicationScalePlan) *GetReplicationScalePlanOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get replication scale plan o k response
func (o *GetReplicationScalePlanOK) SetPayload(payload *models.ReplicationScalePlan) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetReplicationScalePlanOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// GetReplicationScalePlanBadRequestCode is the HTTP code returned for type GetReplicationScalePlanBadRequest
const GetReplicationScalePlanBadRequestCode int = 400

/*
GetReplicationScalePlanBadRequest Bad request.

swagger:response getReplicationScalePlanBadRequest
*/
type GetReplicationScalePlanBadRequest struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewGetReplicationScalePlanBadRequest creates GetReplicationScalePlanBadRequest with default headers values
func NewGetReplicationScalePlanBadRequest() *GetReplicationScalePlanBadRequest {

	return &GetReplicationScalePlanBadRequest{}
}

// WithPayload adds the payload to the get replication scale plan bad request response
func (o *GetReplicationScalePlanBadRequest) WithPayload(payload *models.ErrorResponse) *GetReplicationScalePlanBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get replication scale plan bad request response
func (o *GetReplicationScalePlanBadRequest) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetReplicationScalePlanBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// GetReplicationScalePlanUnauthorizedCode is the HTTP code returned for type GetReplicationScalePlanUnauthorized
const GetReplicationScalePlanUnauthorizedCode int = 401

/*
GetReplicationScalePlanUnauthorized Unauthorized or invalid credentials.

swagger:response getReplicationScalePlanUnauthorized
*/
type GetReplicationScalePlanUnauthorized struct {
}

// NewGetReplicationScalePlanUnauthorized creates GetReplicationScalePlanUnauthorized with default headers values
func NewGetReplicationScalePlanUnauthorized() *GetReplicationScalePlanUnauthorized {

	return &GetReplicationScalePlanUnauthorized{}
}

// WriteResponse to the client
func (o *GetReplicationScalePlanUnauthorized) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(401)
}

// GetReplicationScalePlanForbiddenCode is the HTTP code returned for type GetReplicationScalePlanForbidden
const GetReplicationScalePlanForbiddenCode int = 403

/*
GetReplicationScalePlanForbidden Forbidden

swagger:response getReplicationScalePlanForbidden
*/
type GetReplicationScalePlanForbidden struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewGetReplicationScalePlanForbidden creates GetReplicationScalePlanForbidden with default headers values
func NewGetReplicationScalePlanForbidden() *GetReplicationScalePlanForbidden {

	return &GetReplicationScalePlanForbidden{}
}

// WithPayload adds the payload to the get replication scale plan forbidden response
func (o *GetReplicationScalePlanForbidden) WithPayload(payload *models.ErrorResponse) *GetReplicationScalePlanForbidden {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get replication scale plan forbidden response
func (o *GetReplicationScalePlanForbidden) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetReplicationScalePlanForbidden) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(403)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// GetReplicationScalePlanNotFoundCode is the HTTP code returned for type GetReplicationScalePlanNotFound
const GetReplicationScalePlanNotFoundCode int = 404

/*
GetReplicationScalePlanNotFound Collection not found.

swagger:response getReplicationScalePlanNotFound
*/
type GetReplicationScalePlanNotFound struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewGetReplicationScalePlanNotFound creates GetReplicationScalePlanNotFound with default headers values
func NewGetReplicationScalePlanNotFound() *GetReplicationScalePlanNotFound {

	return &GetReplicationScalePlanNotFound{}
}

// WithPayload adds the payload to the get replication scale plan not found response
func (o *GetReplicationScalePlanNotFound) WithPayload(payload *models.ErrorResponse) *GetReplicationScalePlanNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get replication scale plan not found response
func (o *GetReplicationScalePlanNotFound) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetReplicationScalePlanNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// GetReplicationScalePlanInternalServerErrorCode is the HTTP code returned for type GetReplicationScalePlanInternalServerError
const GetReplicationScalePlanInternalServerErrorCode int = 500

/*
GetReplicationScalePlanInternalServerError An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.

swagger:response getReplicationScalePlanInternalServerError
*/
type GetReplicationScalePlanInternalServerError struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewGetReplicationScalePlanInternalServerError creates GetReplicationScalePlanInternalServerError with default headers values
func NewGetReplicationScalePlanInternalServerError() *GetReplicationScalePlanInternalServerError {

	return &GetReplicationScalePlanInternalServerError{}
}

// WithPayload adds the payload to the get replication scale plan internal server error response
func (o *GetReplicationScalePlanInternalServerError) WithPayload(payload *models.ErrorResponse) *GetReplicationScalePlanInternalServerError {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get replication scale plan internal server error response
func (o *GetReplicationScalePlanInternalServerError) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetReplicationScalePlanInternalServerError) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(500)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// GetReplicationScalePlanNotImplementedCode is the HTTP code returned for type GetReplicationScalePlanNotImplemented
const GetReplicationScalePlanNotImplementedCode int = 501

/*
GetReplicationScalePlanNotImplemented Replica movement operations are disabled.

swagger:response getReplicationScalePlanNotImplemented
*/
type GetReplicationScalePlanNotImplemented struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewGetReplicationScalePlanNotImplemented creates GetReplicationScalePlanNotImplemented with default headers values
func NewGetReplicationScalePlanNotImplemented() *GetReplicationScalePlanNotImplemented {

	return &GetReplicationScalePlanNotImplemented{}
}

// WithPayload adds the payload to the get replication scale plan not implemented response
func (o *GetReplicationScalePlanNotImplemented) WithPayload(payload *models.ErrorResponse) *GetReplicationScalePlanNotImplemented {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get replication scale plan not implemented response
func (o *GetReplicationScalePlanNotImplemented) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetReplicationScalePlanNotImplemented) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(501)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
