//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package replication

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/weaviate/weaviate/entities/models"
)

// ReplicateOKCode is the HTTP code returned for type ReplicateOK
const ReplicateOKCode int = 200

/*
ReplicateOK Replication operation registered successfully. ID of the operation is returned.

swagger:response replicateOK
*/
type ReplicateOK struct {

	/*
	  In: Body
	*/
	Payload *models.ReplicationReplicateReplicaResponse `json:"body,omitempty"`
}

// NewReplicateOK creates ReplicateOK with default headers values
func NewReplicateOK() *ReplicateOK {

	return &ReplicateOK{}
}

// WithPayload adds the payload to the replicate o k response
func (o *ReplicateOK) WithPayload(payload *models.ReplicationReplicateReplicaResponse) *ReplicateOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replicate o k response
func (o *ReplicateOK) SetPayload(payload *models.ReplicationReplicateReplicaResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplicateOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplicateBadRequestCode is the HTTP code returned for type ReplicateBadRequest
const ReplicateBadRequestCode int = 400

/*
ReplicateBadRequest Malformed request.

swagger:response replicateBadRequest
*/
type ReplicateBadRequest struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewReplicateBadRequest creates ReplicateBadRequest with default headers values
func NewReplicateBadRequest() *ReplicateBadRequest {

	return &ReplicateBadRequest{}
}

// WithPayload adds the payload to the replicate bad request response
func (o *ReplicateBadRequest) WithPayload(payload *models.ErrorResponse) *ReplicateBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replicate bad request response
func (o *ReplicateBadRequest) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplicateBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplicateUnauthorizedCode is the HTTP code returned for type ReplicateUnauthorized
const ReplicateUnauthorizedCode int = 401

/*
ReplicateUnauthorized Unauthorized or invalid credentials.

swagger:response replicateUnauthorized
*/
type ReplicateUnauthorized struct {
}

// NewReplicateUnauthorized creates ReplicateUnauthorized with default headers values
func NewReplicateUnauthorized() *ReplicateUnauthorized {

	return &ReplicateUnauthorized{}
}

// WriteResponse to the client
func (o *ReplicateUnauthorized) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(401)
}

// ReplicateForbiddenCode is the HTTP code returned for type ReplicateForbidden
const ReplicateForbiddenCode int = 403

/*
ReplicateForbidden Forbidden

swagger:response replicateForbidden
*/
type ReplicateForbidden struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewReplicateForbidden creates ReplicateForbidden with default headers values
func NewReplicateForbidden() *ReplicateForbidden {

	return &ReplicateForbidden{}
}

// WithPayload adds the payload to the replicate forbidden response
func (o *ReplicateForbidden) WithPayload(payload *models.ErrorResponse) *ReplicateForbidden {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replicate forbidden response
func (o *ReplicateForbidden) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplicateForbidden) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(403)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplicateUnprocessableEntityCode is the HTTP code returned for type ReplicateUnprocessableEntity
const ReplicateUnprocessableEntityCode int = 422

/*
ReplicateUnprocessableEntity The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request.

swagger:response replicateUnprocessableEntity
*/
type ReplicateUnprocessableEntity struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewReplicateUnprocessableEntity creates ReplicateUnprocessableEntity with default headers values
func NewReplicateUnprocessableEntity() *ReplicateUnprocessableEntity {

	return &ReplicateUnprocessableEntity{}
}

// WithPayload adds the payload to the replicate unprocessable entity response
func (o *ReplicateUnprocessableEntity) WithPayload(payload *models.ErrorResponse) *ReplicateUnprocessableEntity {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replicate unprocessable entity response
func (o *ReplicateUnprocessableEntity) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplicateUnprocessableEntity) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(422)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplicateInternalServerErrorCode is the HTTP code returned for type ReplicateInternalServerError
const ReplicateInternalServerErrorCode int = 500

/*
ReplicateInternalServerError An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.

swagger:response replicateInternalServerError
*/
type ReplicateInternalServerError struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewReplicateInternalServerError creates ReplicateInternalServerError with default headers values
func NewReplicateInternalServerError() *ReplicateInternalServerError {

	return &ReplicateInternalServerError{}
}

// WithPayload adds the payload to the replicate internal server error response
func (o *ReplicateInternalServerError) WithPayload(payload *models.ErrorResponse) *ReplicateInternalServerError {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replicate internal server error response
func (o *ReplicateInternalServerError) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplicateInternalServerError) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(500)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplicateNotImplementedCode is the HTTP code returned for type ReplicateNotImplemented
const ReplicateNotImplementedCode int = 501

/*
ReplicateNotImplemented Replica movement operations are disabled.

swagger:response replicateNotImplemented
*/
type ReplicateNotImplemented struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewReplicateNotImplemented creates ReplicateNotImplemented with default headers values
func NewReplicateNotImplemented() *ReplicateNotImplemented {

	return &ReplicateNotImplemented{}
}

// WithPayload adds the payload to the replicate not implemented response
func (o *ReplicateNotImplemented) WithPayload(payload *models.ErrorResponse) *ReplicateNotImplemented {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replicate not implemented response
func (o *ReplicateNotImplemented) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplicateNotImplemented) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(501)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
