//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package replication

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the generate command

import (
	"net/http"

	"github.com/go-openapi/runtime/middleware"

	"github.com/weaviate/weaviate/entities/models"
)

// ReplicationDetailsHandlerFunc turns a function with the right signature into a replication details handler
type ReplicationDetailsHandlerFunc func(ReplicationDetailsParams, *models.Principal) middleware.Responder

// Handle executing the request and returning a response
func (fn ReplicationDetailsHandlerFunc) Handle(params ReplicationDetailsParams, principal *models.Principal) middleware.Responder {
	return fn(params, principal)
}

// ReplicationDetailsHandler interface for that can handle valid replication details params
type ReplicationDetailsHandler interface {
	Handle(ReplicationDetailsParams, *models.Principal) middleware.Responder
}

// NewReplicationDetails creates a new http.Handler for the replication details operation
func NewReplicationDetails(ctx *middleware.Context, handler ReplicationDetailsHandler) *ReplicationDetails {
	return &ReplicationDetails{Context: ctx, Handler: handler}
}

/*
	ReplicationDetails swagger:route GET /replication/replicate/{id} replication replicationDetails

# Retrieve a replication operation

Fetches the current status and detailed information for a specific replication operation, identified by its unique ID. Optionally includes historical data of the operation's progress if requested.
*/
type ReplicationDetails struct {
	Context *middleware.Context
	Handler ReplicationDetailsHandler
}

func (o *ReplicationDetails) ServeHTTP(rw http.ResponseWriter, r *http.Request) {
	route, rCtx, _ := o.Context.RouteInfo(r)
	if rCtx != nil {
		*r = *rCtx
	}
	var Params = NewReplicationDetailsParams()
	uprinc, aCtx, err := o.Context.Authorize(r, route)
	if err != nil {
		o.Context.Respond(rw, r, route.Produces, route, err)
		return
	}
	if aCtx != nil {
		*r = *aCtx
	}
	var principal *models.Principal
	if uprinc != nil {
		principal = uprinc.(*models.Principal) // this is really a models.Principal, I promise
	}

	if err := o.Context.BindValidRequest(r, route, &Params); err != nil { // bind params
		o.Context.Respond(rw, r, route.Produces, route, err)
		return
	}

	res := o.Handler.Handle(Params, principal) // actually handle the request
	o.Context.Respond(rw, r, route.Produces, route, res)

}
