//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package schema

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the generate command

import (
	"net/http"

	"github.com/go-openapi/runtime/middleware"

	"github.com/weaviate/weaviate/entities/models"
)

// AliasesCreateHandlerFunc turns a function with the right signature into a aliases create handler
type AliasesCreateHandlerFunc func(AliasesCreateParams, *models.Principal) middleware.Responder

// Handle executing the request and returning a response
func (fn AliasesCreateHandlerFunc) Handle(params AliasesCreateParams, principal *models.Principal) middleware.Responder {
	return fn(params, principal)
}

// AliasesCreateHandler interface for that can handle valid aliases create params
type AliasesCreateHandler interface {
	Handle(AliasesCreateParams, *models.Principal) middleware.Responder
}

// NewAliasesCreate creates a new http.Handler for the aliases create operation
func NewAliasesCreate(ctx *middleware.Context, handler AliasesCreateHandler) *AliasesCreate {
	return &AliasesCreate{Context: ctx, Handler: handler}
}

/*
	AliasesCreate swagger:route POST /aliases schema aliasesCreate

# Create a new alias

Create a new alias mapping between an alias name and a collection (class). The alias acts as an alternative name for accessing the collection.
*/
type AliasesCreate struct {
	Context *middleware.Context
	Handler AliasesCreateHandler
}

func (o *AliasesCreate) ServeHTTP(rw http.ResponseWriter, r *http.Request) {
	route, rCtx, _ := o.Context.RouteInfo(r)
	if rCtx != nil {
		*r = *rCtx
	}
	var Params = NewAliasesCreateParams()
	uprinc, aCtx, err := o.Context.Authorize(r, route)
	if err != nil {
		o.Context.Respond(rw, r, route.Produces, route, err)
		return
	}
	if aCtx != nil {
		*r = *aCtx
	}
	var principal *models.Principal
	if uprinc != nil {
		principal = uprinc.(*models.Principal) // this is really a models.Principal, I promise
	}

	if err := o.Context.BindValidRequest(r, route, &Params); err != nil { // bind params
		o.Context.Respond(rw, r, route.Produces, route, err)
		return
	}

	res := o.Handler.Handle(Params, principal) // actually handle the request
	o.Context.Respond(rw, r, route.Produces, route, res)

}
