//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package schema

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/weaviate/weaviate/entities/models"
)

// AliasesCreateOKCode is the HTTP code returned for type AliasesCreateOK
const AliasesCreateOKCode int = 200

/*
AliasesCreateOK Successfully created a new alias for the specified collection (class)

swagger:response aliasesCreateOK
*/
type AliasesCreateOK struct {

	/*
	  In: Body
	*/
	Payload *models.Alias `json:"body,omitempty"`
}

// NewAliasesCreateOK creates AliasesCreateOK with default headers values
func NewAliasesCreateOK() *AliasesCreateOK {

	return &AliasesCreateOK{}
}

// WithPayload adds the payload to the aliases create o k response
func (o *AliasesCreateOK) WithPayload(payload *models.Alias) *AliasesCreateOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the aliases create o k response
func (o *AliasesCreateOK) SetPayload(payload *models.Alias) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *AliasesCreateOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// AliasesCreateUnauthorizedCode is the HTTP code returned for type AliasesCreateUnauthorized
const AliasesCreateUnauthorizedCode int = 401

/*
AliasesCreateUnauthorized Unauthorized or invalid credentials.

swagger:response aliasesCreateUnauthorized
*/
type AliasesCreateUnauthorized struct {
}

// NewAliasesCreateUnauthorized creates AliasesCreateUnauthorized with default headers values
func NewAliasesCreateUnauthorized() *AliasesCreateUnauthorized {

	return &AliasesCreateUnauthorized{}
}

// WriteResponse to the client
func (o *AliasesCreateUnauthorized) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(401)
}

// AliasesCreateForbiddenCode is the HTTP code returned for type AliasesCreateForbidden
const AliasesCreateForbiddenCode int = 403

/*
AliasesCreateForbidden Forbidden

swagger:response aliasesCreateForbidden
*/
type AliasesCreateForbidden struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewAliasesCreateForbidden creates AliasesCreateForbidden with default headers values
func NewAliasesCreateForbidden() *AliasesCreateForbidden {

	return &AliasesCreateForbidden{}
}

// WithPayload adds the payload to the aliases create forbidden response
func (o *AliasesCreateForbidden) WithPayload(payload *models.ErrorResponse) *AliasesCreateForbidden {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the aliases create forbidden response
func (o *AliasesCreateForbidden) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *AliasesCreateForbidden) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(403)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// AliasesCreateUnprocessableEntityCode is the HTTP code returned for type AliasesCreateUnprocessableEntity
const AliasesCreateUnprocessableEntityCode int = 422

/*
AliasesCreateUnprocessableEntity Invalid create alias request.

swagger:response aliasesCreateUnprocessableEntity
*/
type AliasesCreateUnprocessableEntity struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewAliasesCreateUnprocessableEntity creates AliasesCreateUnprocessableEntity with default headers values
func NewAliasesCreateUnprocessableEntity() *AliasesCreateUnprocessableEntity {

	return &AliasesCreateUnprocessableEntity{}
}

// WithPayload adds the payload to the aliases create unprocessable entity response
func (o *AliasesCreateUnprocessableEntity) WithPayload(payload *models.ErrorResponse) *AliasesCreateUnprocessableEntity {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the aliases create unprocessable entity response
func (o *AliasesCreateUnprocessableEntity) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *AliasesCreateUnprocessableEntity) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(422)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// AliasesCreateInternalServerErrorCode is the HTTP code returned for type AliasesCreateInternalServerError
const AliasesCreateInternalServerErrorCode int = 500

/*
AliasesCreateInternalServerError An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.

swagger:response aliasesCreateInternalServerError
*/
type AliasesCreateInternalServerError struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewAliasesCreateInternalServerError creates AliasesCreateInternalServerError with default headers values
func NewAliasesCreateInternalServerError() *AliasesCreateInternalServerError {

	return &AliasesCreateInternalServerError{}
}

// WithPayload adds the payload to the aliases create internal server error response
func (o *AliasesCreateInternalServerError) WithPayload(payload *models.ErrorResponse) *AliasesCreateInternalServerError {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the aliases create internal server error response
func (o *AliasesCreateInternalServerError) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *AliasesCreateInternalServerError) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(500)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
