//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package schema

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/weaviate/weaviate/entities/models"
)

// AliasesDeleteNoContentCode is the HTTP code returned for type AliasesDeleteNoContent
const AliasesDeleteNoContentCode int = 204

/*
AliasesDeleteNoContent Successfully deleted the alias.

swagger:response aliasesDeleteNoContent
*/
type AliasesDeleteNoContent struct {
}

// NewAliasesDeleteNoContent creates AliasesDeleteNoContent with default headers values
func NewAliasesDeleteNoContent() *AliasesDeleteNoContent {

	return &AliasesDeleteNoContent{}
}

// WriteResponse to the client
func (o *AliasesDeleteNoContent) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(204)
}

// AliasesDeleteUnauthorizedCode is the HTTP code returned for type AliasesDeleteUnauthorized
const AliasesDeleteUnauthorizedCode int = 401

/*
AliasesDeleteUnauthorized Unauthorized or invalid credentials.

swagger:response aliasesDeleteUnauthorized
*/
type AliasesDeleteUnauthorized struct {
}

// NewAliasesDeleteUnauthorized creates AliasesDeleteUnauthorized with default headers values
func NewAliasesDeleteUnauthorized() *AliasesDeleteUnauthorized {

	return &AliasesDeleteUnauthorized{}
}

// WriteResponse to the client
func (o *AliasesDeleteUnauthorized) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(401)
}

// AliasesDeleteForbiddenCode is the HTTP code returned for type AliasesDeleteForbidden
const AliasesDeleteForbiddenCode int = 403

/*
AliasesDeleteForbidden Forbidden

swagger:response aliasesDeleteForbidden
*/
type AliasesDeleteForbidden struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewAliasesDeleteForbidden creates AliasesDeleteForbidden with default headers values
func NewAliasesDeleteForbidden() *AliasesDeleteForbidden {

	return &AliasesDeleteForbidden{}
}

// WithPayload adds the payload to the aliases delete forbidden response
func (o *AliasesDeleteForbidden) WithPayload(payload *models.ErrorResponse) *AliasesDeleteForbidden {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the aliases delete forbidden response
func (o *AliasesDeleteForbidden) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *AliasesDeleteForbidden) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(403)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// AliasesDeleteNotFoundCode is the HTTP code returned for type AliasesDeleteNotFound
const AliasesDeleteNotFoundCode int = 404

/*
AliasesDeleteNotFound Not Found - Alias does not exist

swagger:response aliasesDeleteNotFound
*/
type AliasesDeleteNotFound struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewAliasesDeleteNotFound creates AliasesDeleteNotFound with default headers values
func NewAliasesDeleteNotFound() *AliasesDeleteNotFound {

	return &AliasesDeleteNotFound{}
}

// WithPayload adds the payload to the aliases delete not found response
func (o *AliasesDeleteNotFound) WithPayload(payload *models.ErrorResponse) *AliasesDeleteNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the aliases delete not found response
func (o *AliasesDeleteNotFound) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *AliasesDeleteNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// AliasesDeleteUnprocessableEntityCode is the HTTP code returned for type AliasesDeleteUnprocessableEntity
const AliasesDeleteUnprocessableEntityCode int = 422

/*
AliasesDeleteUnprocessableEntity Invalid delete alias request.

swagger:response aliasesDeleteUnprocessableEntity
*/
type AliasesDeleteUnprocessableEntity struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewAliasesDeleteUnprocessableEntity creates AliasesDeleteUnprocessableEntity with default headers values
func NewAliasesDeleteUnprocessableEntity() *AliasesDeleteUnprocessableEntity {

	return &AliasesDeleteUnprocessableEntity{}
}

// WithPayload adds the payload to the aliases delete unprocessable entity response
func (o *AliasesDeleteUnprocessableEntity) WithPayload(payload *models.ErrorResponse) *AliasesDeleteUnprocessableEntity {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the aliases delete unprocessable entity response
func (o *AliasesDeleteUnprocessableEntity) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *AliasesDeleteUnprocessableEntity) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(422)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// AliasesDeleteInternalServerErrorCode is the HTTP code returned for type AliasesDeleteInternalServerError
const AliasesDeleteInternalServerErrorCode int = 500

/*
AliasesDeleteInternalServerError An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.

swagger:response aliasesDeleteInternalServerError
*/
type AliasesDeleteInternalServerError struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewAliasesDeleteInternalServerError creates AliasesDeleteInternalServerError with default headers values
func NewAliasesDeleteInternalServerError() *AliasesDeleteInternalServerError {

	return &AliasesDeleteInternalServerError{}
}

// WithPayload adds the payload to the aliases delete internal server error response
func (o *AliasesDeleteInternalServerError) WithPayload(payload *models.ErrorResponse) *AliasesDeleteInternalServerError {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the aliases delete internal server error response
func (o *AliasesDeleteInternalServerError) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *AliasesDeleteInternalServerError) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(500)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
