//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package schema

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/weaviate/weaviate/entities/models"
)

// TenantsUpdateOKCode is the HTTP code returned for type TenantsUpdateOK
const TenantsUpdateOKCode int = 200

/*
TenantsUpdateOK Tenant statuses updated successfully.

swagger:response tenantsUpdateOK
*/
type TenantsUpdateOK struct {

	/*
	  In: Body
	*/
	Payload []*models.Tenant `json:"body,omitempty"`
}

// NewTenantsUpdateOK creates TenantsUpdateOK with default headers values
func NewTenantsUpdateOK() *TenantsUpdateOK {

	return &TenantsUpdateOK{}
}

// WithPayload adds the payload to the tenants update o k response
func (o *TenantsUpdateOK) WithPayload(payload []*models.Tenant) *TenantsUpdateOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the tenants update o k response
func (o *TenantsUpdateOK) SetPayload(payload []*models.Tenant) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *TenantsUpdateOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = make([]*models.Tenant, 0, 50)
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

// TenantsUpdateUnauthorizedCode is the HTTP code returned for type TenantsUpdateUnauthorized
const TenantsUpdateUnauthorizedCode int = 401

/*
TenantsUpdateUnauthorized Unauthorized or invalid credentials.

swagger:response tenantsUpdateUnauthorized
*/
type TenantsUpdateUnauthorized struct {
}

// NewTenantsUpdateUnauthorized creates TenantsUpdateUnauthorized with default headers values
func NewTenantsUpdateUnauthorized() *TenantsUpdateUnauthorized {

	return &TenantsUpdateUnauthorized{}
}

// WriteResponse to the client
func (o *TenantsUpdateUnauthorized) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(401)
}

// TenantsUpdateForbiddenCode is the HTTP code returned for type TenantsUpdateForbidden
const TenantsUpdateForbiddenCode int = 403

/*
TenantsUpdateForbidden Forbidden

swagger:response tenantsUpdateForbidden
*/
type TenantsUpdateForbidden struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewTenantsUpdateForbidden creates TenantsUpdateForbidden with default headers values
func NewTenantsUpdateForbidden() *TenantsUpdateForbidden {

	return &TenantsUpdateForbidden{}
}

// WithPayload adds the payload to the tenants update forbidden response
func (o *TenantsUpdateForbidden) WithPayload(payload *models.ErrorResponse) *TenantsUpdateForbidden {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the tenants update forbidden response
func (o *TenantsUpdateForbidden) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *TenantsUpdateForbidden) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(403)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// TenantsUpdateUnprocessableEntityCode is the HTTP code returned for type TenantsUpdateUnprocessableEntity
const TenantsUpdateUnprocessableEntityCode int = 422

/*
TenantsUpdateUnprocessableEntity Invalid update request.

swagger:response tenantsUpdateUnprocessableEntity
*/
type TenantsUpdateUnprocessableEntity struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewTenantsUpdateUnprocessableEntity creates TenantsUpdateUnprocessableEntity with default headers values
func NewTenantsUpdateUnprocessableEntity() *TenantsUpdateUnprocessableEntity {

	return &TenantsUpdateUnprocessableEntity{}
}

// WithPayload adds the payload to the tenants update unprocessable entity response
func (o *TenantsUpdateUnprocessableEntity) WithPayload(payload *models.ErrorResponse) *TenantsUpdateUnprocessableEntity {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the tenants update unprocessable entity response
func (o *TenantsUpdateUnprocessableEntity) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *TenantsUpdateUnprocessableEntity) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(422)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// TenantsUpdateInternalServerErrorCode is the HTTP code returned for type TenantsUpdateInternalServerError
const TenantsUpdateInternalServerErrorCode int = 500

/*
TenantsUpdateInternalServerError An error occurred while updating tenants. Check the ErrorResponse for details.

swagger:response tenantsUpdateInternalServerError
*/
type TenantsUpdateInternalServerError struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewTenantsUpdateInternalServerError creates TenantsUpdateInternalServerError with default headers values
func NewTenantsUpdateInternalServerError() *TenantsUpdateInternalServerError {

	return &TenantsUpdateInternalServerError{}
}

// WithPayload adds the payload to the tenants update internal server error response
func (o *TenantsUpdateInternalServerError) WithPayload(payload *models.ErrorResponse) *TenantsUpdateInternalServerError {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the tenants update internal server error response
func (o *TenantsUpdateInternalServerError) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *TenantsUpdateInternalServerError) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(500)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
