//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package users

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the generate command

import (
	"net/http"

	"github.com/go-openapi/runtime/middleware"

	"github.com/weaviate/weaviate/entities/models"
)

// ActivateUserHandlerFunc turns a function with the right signature into a activate user handler
type ActivateUserHandlerFunc func(ActivateUserParams, *models.Principal) middleware.Responder

// Handle executing the request and returning a response
func (fn ActivateUserHandlerFunc) Handle(params ActivateUserParams, principal *models.Principal) middleware.Responder {
	return fn(params, principal)
}

// ActivateUserHandler interface for that can handle valid activate user params
type ActivateUserHandler interface {
	Handle(ActivateUserParams, *models.Principal) middleware.Responder
}

// NewActivateUser creates a new http.Handler for the activate user operation
func NewActivateUser(ctx *middleware.Context, handler ActivateUserHandler) *ActivateUser {
	return &ActivateUser{Context: ctx, Handler: handler}
}

/*
	ActivateUser swagger:route POST /users/db/{user_id}/activate users activateUser

# Activate a user

Activate a deactivated database user (`db` user type).
*/
type ActivateUser struct {
	Context *middleware.Context
	Handler ActivateUserHandler
}

func (o *ActivateUser) ServeHTTP(rw http.ResponseWriter, r *http.Request) {
	route, rCtx, _ := o.Context.RouteInfo(r)
	if rCtx != nil {
		*r = *rCtx
	}
	var Params = NewActivateUserParams()
	uprinc, aCtx, err := o.Context.Authorize(r, route)
	if err != nil {
		o.Context.Respond(rw, r, route.Produces, route, err)
		return
	}
	if aCtx != nil {
		*r = *aCtx
	}
	var principal *models.Principal
	if uprinc != nil {
		principal = uprinc.(*models.Principal) // this is really a models.Principal, I promise
	}

	if err := o.Context.BindValidRequest(r, route, &Params); err != nil { // bind params
		o.Context.Respond(rw, r, route.Produces, route, err)
		return
	}

	res := o.Handler.Handle(Params, principal) // actually handle the request
	o.Context.Respond(rw, r, route.Produces, route, res)

}
