//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package users

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the generate command

import (
	"context"
	"net/http"

	"github.com/go-openapi/runtime/middleware"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/weaviate/weaviate/entities/models"
)

// DeactivateUserHandlerFunc turns a function with the right signature into a deactivate user handler
type DeactivateUserHandlerFunc func(DeactivateUserParams, *models.Principal) middleware.Responder

// Handle executing the request and returning a response
func (fn DeactivateUserHandlerFunc) Handle(params DeactivateUserParams, principal *models.Principal) middleware.Responder {
	return fn(params, principal)
}

// DeactivateUserHandler interface for that can handle valid deactivate user params
type DeactivateUserHandler interface {
	Handle(DeactivateUserParams, *models.Principal) middleware.Responder
}

// NewDeactivateUser creates a new http.Handler for the deactivate user operation
func NewDeactivateUser(ctx *middleware.Context, handler DeactivateUserHandler) *DeactivateUser {
	return &DeactivateUser{Context: ctx, Handler: handler}
}

/*
	DeactivateUser swagger:route POST /users/db/{user_id}/deactivate users deactivateUser

# Deactivate a user

Deactivate a database user (`db` user type).
*/
type DeactivateUser struct {
	Context *middleware.Context
	Handler DeactivateUserHandler
}

func (o *DeactivateUser) ServeHTTP(rw http.ResponseWriter, r *http.Request) {
	route, rCtx, _ := o.Context.RouteInfo(r)
	if rCtx != nil {
		*r = *rCtx
	}
	var Params = NewDeactivateUserParams()
	uprinc, aCtx, err := o.Context.Authorize(r, route)
	if err != nil {
		o.Context.Respond(rw, r, route.Produces, route, err)
		return
	}
	if aCtx != nil {
		*r = *aCtx
	}
	var principal *models.Principal
	if uprinc != nil {
		principal = uprinc.(*models.Principal) // this is really a models.Principal, I promise
	}

	if err := o.Context.BindValidRequest(r, route, &Params); err != nil { // bind params
		o.Context.Respond(rw, r, route.Produces, route, err)
		return
	}

	res := o.Handler.Handle(Params, principal) // actually handle the request
	o.Context.Respond(rw, r, route.Produces, route, res)

}

// DeactivateUserBody deactivate user body
//
// swagger:model DeactivateUserBody
type DeactivateUserBody struct {

	// Whether the API key should be revoked when deactivating the user.
	RevokeKey *bool `json:"revoke_key,omitempty" yaml:"revoke_key,omitempty"`
}

// Validate validates this deactivate user body
func (o *DeactivateUserBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this deactivate user body based on context it is used
func (o *DeactivateUserBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *DeactivateUserBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *DeactivateUserBody) UnmarshalBinary(b []byte) error {
	var res DeactivateUserBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
