//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package users

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the generate command

import (
	"net/http"

	"github.com/go-openapi/runtime/middleware"

	"github.com/weaviate/weaviate/entities/models"
)

// GetOwnInfoHandlerFunc turns a function with the right signature into a get own info handler
type GetOwnInfoHandlerFunc func(GetOwnInfoParams, *models.Principal) middleware.Responder

// Handle executing the request and returning a response
func (fn GetOwnInfoHandlerFunc) Handle(params GetOwnInfoParams, principal *models.Principal) middleware.Responder {
	return fn(params, principal)
}

// GetOwnInfoHandler interface for that can handle valid get own info params
type GetOwnInfoHandler interface {
	Handle(GetOwnInfoParams, *models.Principal) middleware.Responder
}

// NewGetOwnInfo creates a new http.Handler for the get own info operation
func NewGetOwnInfo(ctx *middleware.Context, handler GetOwnInfoHandler) *GetOwnInfo {
	return &GetOwnInfo{Context: ctx, Handler: handler}
}

/*
	GetOwnInfo swagger:route GET /users/own-info users getOwnInfo

# Get current user info

Get information about the currently authenticated user, including username and assigned roles.
*/
type GetOwnInfo struct {
	Context *middleware.Context
	Handler GetOwnInfoHandler
}

func (o *GetOwnInfo) ServeHTTP(rw http.ResponseWriter, r *http.Request) {
	route, rCtx, _ := o.Context.RouteInfo(r)
	if rCtx != nil {
		*r = *rCtx
	}
	var Params = NewGetOwnInfoParams()
	uprinc, aCtx, err := o.Context.Authorize(r, route)
	if err != nil {
		o.Context.Respond(rw, r, route.Produces, route, err)
		return
	}
	if aCtx != nil {
		*r = *aCtx
	}
	var principal *models.Principal
	if uprinc != nil {
		principal = uprinc.(*models.Principal) // this is really a models.Principal, I promise
	}

	if err := o.Context.BindValidRequest(r, route, &Params); err != nil { // bind params
		o.Context.Respond(rw, r, route.Produces, route, err)
		return
	}

	res := o.Handler.Handle(Params, principal) // actually handle the request
	o.Context.Respond(rw, r, route.Produces, route, res)

}
