//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package users

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/weaviate/weaviate/entities/models"
)

// GetOwnInfoOKCode is the HTTP code returned for type GetOwnInfoOK
const GetOwnInfoOKCode int = 200

/*
GetOwnInfoOK Info about the user.

swagger:response getOwnInfoOK
*/
type GetOwnInfoOK struct {

	/*
	  In: Body
	*/
	Payload *models.UserOwnInfo `json:"body,omitempty"`
}

// NewGetOwnInfoOK creates GetOwnInfoOK with default headers values
func NewGetOwnInfoOK() *GetOwnInfoOK {

	return &GetOwnInfoOK{}
}

// WithPayload adds the payload to the get own info o k response
func (o *GetOwnInfoOK) WithPayload(payload *models.UserOwnInfo) *GetOwnInfoOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get own info o k response
func (o *GetOwnInfoOK) SetPayload(payload *models.UserOwnInfo) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetOwnInfoOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// GetOwnInfoUnauthorizedCode is the HTTP code returned for type GetOwnInfoUnauthorized
const GetOwnInfoUnauthorizedCode int = 401

/*
GetOwnInfoUnauthorized Unauthorized or invalid credentials.

swagger:response getOwnInfoUnauthorized
*/
type GetOwnInfoUnauthorized struct {
}

// NewGetOwnInfoUnauthorized creates GetOwnInfoUnauthorized with default headers values
func NewGetOwnInfoUnauthorized() *GetOwnInfoUnauthorized {

	return &GetOwnInfoUnauthorized{}
}

// WriteResponse to the client
func (o *GetOwnInfoUnauthorized) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(401)
}

// GetOwnInfoInternalServerErrorCode is the HTTP code returned for type GetOwnInfoInternalServerError
const GetOwnInfoInternalServerErrorCode int = 500

/*
GetOwnInfoInternalServerError An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.

swagger:response getOwnInfoInternalServerError
*/
type GetOwnInfoInternalServerError struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewGetOwnInfoInternalServerError creates GetOwnInfoInternalServerError with default headers values
func NewGetOwnInfoInternalServerError() *GetOwnInfoInternalServerError {

	return &GetOwnInfoInternalServerError{}
}

// WithPayload adds the payload to the get own info internal server error response
func (o *GetOwnInfoInternalServerError) WithPayload(payload *models.ErrorResponse) *GetOwnInfoInternalServerError {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get own info internal server error response
func (o *GetOwnInfoInternalServerError) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetOwnInfoInternalServerError) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(500)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// GetOwnInfoNotImplementedCode is the HTTP code returned for type GetOwnInfoNotImplemented
const GetOwnInfoNotImplementedCode int = 501

/*
GetOwnInfoNotImplemented Replica movement operations are disabled.

swagger:response getOwnInfoNotImplemented
*/
type GetOwnInfoNotImplemented struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewGetOwnInfoNotImplemented creates GetOwnInfoNotImplemented with default headers values
func NewGetOwnInfoNotImplemented() *GetOwnInfoNotImplemented {

	return &GetOwnInfoNotImplemented{}
}

// WithPayload adds the payload to the get own info not implemented response
func (o *GetOwnInfoNotImplemented) WithPayload(payload *models.ErrorResponse) *GetOwnInfoNotImplemented {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get own info not implemented response
func (o *GetOwnInfoNotImplemented) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetOwnInfoNotImplemented) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(501)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
