//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package users

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/runtime/middleware"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewListAllUsersParams creates a new ListAllUsersParams object
// with the default values initialized.
func NewListAllUsersParams() ListAllUsersParams {

	var (
		// initialize parameters with default values

		includeLastUsedTimeDefault = bool(false)
	)

	return ListAllUsersParams{
		IncludeLastUsedTime: &includeLastUsedTimeDefault,
	}
}

// ListAllUsersParams contains all the bound params for the list all users operation
// typically these are obtained from a http.Request
//
// swagger:parameters listAllUsers
type ListAllUsersParams struct {

	// HTTP Request Object
	HTTPRequest *http.Request `json:"-"`

	/*Whether to include the last time the users were utilized.
	  In: query
	  Default: false
	*/
	IncludeLastUsedTime *bool
}

// BindRequest both binds and validates a request, it assumes that complex things implement a Validatable(strfmt.Registry) error interface
// for simple values it will use straight method calls.
//
// To ensure default values, the struct must have been initialized with NewListAllUsersParams() beforehand.
func (o *ListAllUsersParams) BindRequest(r *http.Request, route *middleware.MatchedRoute) error {
	var res []error

	o.HTTPRequest = r

	qs := runtime.Values(r.URL.Query())

	qIncludeLastUsedTime, qhkIncludeLastUsedTime, _ := qs.GetOK("includeLastUsedTime")
	if err := o.bindIncludeLastUsedTime(qIncludeLastUsedTime, qhkIncludeLastUsedTime, route.Formats); err != nil {
		res = append(res, err)
	}
	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindIncludeLastUsedTime binds and validates parameter IncludeLastUsedTime from query.
func (o *ListAllUsersParams) bindIncludeLastUsedTime(rawData []string, hasKey bool, formats strfmt.Registry) error {
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}

	// Required: false
	// AllowEmptyValue: false

	if raw == "" { // empty values pass all other validations
		// Default values have been previously initialized by NewListAllUsersParams()
		return nil
	}

	value, err := swag.ConvertBool(raw)
	if err != nil {
		return errors.InvalidType("includeLastUsedTime", "query", "bool", raw)
	}
	o.IncludeLastUsedTime = &value

	return nil
}
