//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package operations

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"net/http"
	"strings"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/loads"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/runtime/middleware"
	"github.com/go-openapi/runtime/security"
	"github.com/go-openapi/runtime/yamlpc"
	"github.com/go-openapi/spec"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/weaviate/weaviate/adapters/handlers/rest/operations/authz"
	"github.com/weaviate/weaviate/adapters/handlers/rest/operations/backups"
	"github.com/weaviate/weaviate/adapters/handlers/rest/operations/batch"
	"github.com/weaviate/weaviate/adapters/handlers/rest/operations/classifications"
	"github.com/weaviate/weaviate/adapters/handlers/rest/operations/cluster"
	"github.com/weaviate/weaviate/adapters/handlers/rest/operations/distributed_tasks"
	"github.com/weaviate/weaviate/adapters/handlers/rest/operations/graphql"
	"github.com/weaviate/weaviate/adapters/handlers/rest/operations/meta"
	"github.com/weaviate/weaviate/adapters/handlers/rest/operations/nodes"
	"github.com/weaviate/weaviate/adapters/handlers/rest/operations/objects"
	"github.com/weaviate/weaviate/adapters/handlers/rest/operations/replication"
	"github.com/weaviate/weaviate/adapters/handlers/rest/operations/schema"
	"github.com/weaviate/weaviate/adapters/handlers/rest/operations/users"
	"github.com/weaviate/weaviate/adapters/handlers/rest/operations/well_known"
	"github.com/weaviate/weaviate/entities/models"
)

// NewWeaviateAPI creates a new Weaviate instance
func NewWeaviateAPI(spec *loads.Document) *WeaviateAPI {
	return &WeaviateAPI{
		handlers:            make(map[string]map[string]http.Handler),
		formats:             strfmt.Default,
		defaultConsumes:     "application/json",
		defaultProduces:     "application/json",
		customConsumers:     make(map[string]runtime.Consumer),
		customProducers:     make(map[string]runtime.Producer),
		PreServerShutdown:   func() {},
		ServerShutdown:      func() {},
		spec:                spec,
		useSwaggerUI:        false,
		ServeError:          errors.ServeError,
		BasicAuthenticator:  security.BasicAuth,
		APIKeyAuthenticator: security.APIKeyAuth,
		BearerAuthenticator: security.BearerAuth,

		JSONConsumer: runtime.JSONConsumer(),
		YamlConsumer: yamlpc.YAMLConsumer(),

		JSONProducer: runtime.JSONProducer(),

		WellKnownGetWellKnownOpenidConfigurationHandler: well_known.GetWellKnownOpenidConfigurationHandlerFunc(func(params well_known.GetWellKnownOpenidConfigurationParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation well_known.GetWellKnownOpenidConfiguration has not yet been implemented")
		}),
		UsersActivateUserHandler: users.ActivateUserHandlerFunc(func(params users.ActivateUserParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation users.ActivateUser has not yet been implemented")
		}),
		AuthzAddPermissionsHandler: authz.AddPermissionsHandlerFunc(func(params authz.AddPermissionsParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation authz.AddPermissions has not yet been implemented")
		}),
		SchemaAliasesCreateHandler: schema.AliasesCreateHandlerFunc(func(params schema.AliasesCreateParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation schema.AliasesCreate has not yet been implemented")
		}),
		SchemaAliasesDeleteHandler: schema.AliasesDeleteHandlerFunc(func(params schema.AliasesDeleteParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation schema.AliasesDelete has not yet been implemented")
		}),
		SchemaAliasesGetHandler: schema.AliasesGetHandlerFunc(func(params schema.AliasesGetParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation schema.AliasesGet has not yet been implemented")
		}),
		SchemaAliasesGetAliasHandler: schema.AliasesGetAliasHandlerFunc(func(params schema.AliasesGetAliasParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation schema.AliasesGetAlias has not yet been implemented")
		}),
		SchemaAliasesUpdateHandler: schema.AliasesUpdateHandlerFunc(func(params schema.AliasesUpdateParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation schema.AliasesUpdate has not yet been implemented")
		}),
		ReplicationApplyReplicationScalePlanHandler: replication.ApplyReplicationScalePlanHandlerFunc(func(params replication.ApplyReplicationScalePlanParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation replication.ApplyReplicationScalePlan has not yet been implemented")
		}),
		AuthzAssignRoleToGroupHandler: authz.AssignRoleToGroupHandlerFunc(func(params authz.AssignRoleToGroupParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation authz.AssignRoleToGroup has not yet been implemented")
		}),
		AuthzAssignRoleToUserHandler: authz.AssignRoleToUserHandlerFunc(func(params authz.AssignRoleToUserParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation authz.AssignRoleToUser has not yet been implemented")
		}),
		BackupsBackupsCancelHandler: backups.BackupsCancelHandlerFunc(func(params backups.BackupsCancelParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation backups.BackupsCancel has not yet been implemented")
		}),
		BackupsBackupsCreateHandler: backups.BackupsCreateHandlerFunc(func(params backups.BackupsCreateParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation backups.BackupsCreate has not yet been implemented")
		}),
		BackupsBackupsCreateStatusHandler: backups.BackupsCreateStatusHandlerFunc(func(params backups.BackupsCreateStatusParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation backups.BackupsCreateStatus has not yet been implemented")
		}),
		BackupsBackupsListHandler: backups.BackupsListHandlerFunc(func(params backups.BackupsListParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation backups.BackupsList has not yet been implemented")
		}),
		BackupsBackupsRestoreHandler: backups.BackupsRestoreHandlerFunc(func(params backups.BackupsRestoreParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation backups.BackupsRestore has not yet been implemented")
		}),
		BackupsBackupsRestoreStatusHandler: backups.BackupsRestoreStatusHandlerFunc(func(params backups.BackupsRestoreStatusParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation backups.BackupsRestoreStatus has not yet been implemented")
		}),
		BatchBatchObjectsCreateHandler: batch.BatchObjectsCreateHandlerFunc(func(params batch.BatchObjectsCreateParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation batch.BatchObjectsCreate has not yet been implemented")
		}),
		BatchBatchObjectsDeleteHandler: batch.BatchObjectsDeleteHandlerFunc(func(params batch.BatchObjectsDeleteParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation batch.BatchObjectsDelete has not yet been implemented")
		}),
		BatchBatchReferencesCreateHandler: batch.BatchReferencesCreateHandlerFunc(func(params batch.BatchReferencesCreateParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation batch.BatchReferencesCreate has not yet been implemented")
		}),
		ReplicationCancelReplicationHandler: replication.CancelReplicationHandlerFunc(func(params replication.CancelReplicationParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation replication.CancelReplication has not yet been implemented")
		}),
		ClassificationsClassificationsGetHandler: classifications.ClassificationsGetHandlerFunc(func(params classifications.ClassificationsGetParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation classifications.ClassificationsGet has not yet been implemented")
		}),
		ClassificationsClassificationsPostHandler: classifications.ClassificationsPostHandlerFunc(func(params classifications.ClassificationsPostParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation classifications.ClassificationsPost has not yet been implemented")
		}),
		ClusterClusterGetStatisticsHandler: cluster.ClusterGetStatisticsHandlerFunc(func(params cluster.ClusterGetStatisticsParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation cluster.ClusterGetStatistics has not yet been implemented")
		}),
		AuthzCreateRoleHandler: authz.CreateRoleHandlerFunc(func(params authz.CreateRoleParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation authz.CreateRole has not yet been implemented")
		}),
		UsersCreateUserHandler: users.CreateUserHandlerFunc(func(params users.CreateUserParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation users.CreateUser has not yet been implemented")
		}),
		UsersDeactivateUserHandler: users.DeactivateUserHandlerFunc(func(params users.DeactivateUserParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation users.DeactivateUser has not yet been implemented")
		}),
		ReplicationDeleteAllReplicationsHandler: replication.DeleteAllReplicationsHandlerFunc(func(params replication.DeleteAllReplicationsParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation replication.DeleteAllReplications has not yet been implemented")
		}),
		ReplicationDeleteReplicationHandler: replication.DeleteReplicationHandlerFunc(func(params replication.DeleteReplicationParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation replication.DeleteReplication has not yet been implemented")
		}),
		AuthzDeleteRoleHandler: authz.DeleteRoleHandlerFunc(func(params authz.DeleteRoleParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation authz.DeleteRole has not yet been implemented")
		}),
		UsersDeleteUserHandler: users.DeleteUserHandlerFunc(func(params users.DeleteUserParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation users.DeleteUser has not yet been implemented")
		}),
		DistributedTasksDistributedTasksGetHandler: distributed_tasks.DistributedTasksGetHandlerFunc(func(params distributed_tasks.DistributedTasksGetParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation distributed_tasks.DistributedTasksGet has not yet been implemented")
		}),
		ReplicationForceDeleteReplicationsHandler: replication.ForceDeleteReplicationsHandlerFunc(func(params replication.ForceDeleteReplicationsParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation replication.ForceDeleteReplications has not yet been implemented")
		}),
		ReplicationGetCollectionShardingStateHandler: replication.GetCollectionShardingStateHandlerFunc(func(params replication.GetCollectionShardingStateParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation replication.GetCollectionShardingState has not yet been implemented")
		}),
		AuthzGetGroupsHandler: authz.GetGroupsHandlerFunc(func(params authz.GetGroupsParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation authz.GetGroups has not yet been implemented")
		}),
		AuthzGetGroupsForRoleHandler: authz.GetGroupsForRoleHandlerFunc(func(params authz.GetGroupsForRoleParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation authz.GetGroupsForRole has not yet been implemented")
		}),
		UsersGetOwnInfoHandler: users.GetOwnInfoHandlerFunc(func(params users.GetOwnInfoParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation users.GetOwnInfo has not yet been implemented")
		}),
		ReplicationGetReplicationScalePlanHandler: replication.GetReplicationScalePlanHandlerFunc(func(params replication.GetReplicationScalePlanParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation replication.GetReplicationScalePlan has not yet been implemented")
		}),
		AuthzGetRoleHandler: authz.GetRoleHandlerFunc(func(params authz.GetRoleParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation authz.GetRole has not yet been implemented")
		}),
		AuthzGetRolesHandler: authz.GetRolesHandlerFunc(func(params authz.GetRolesParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation authz.GetRoles has not yet been implemented")
		}),
		AuthzGetRolesForGroupHandler: authz.GetRolesForGroupHandlerFunc(func(params authz.GetRolesForGroupParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation authz.GetRolesForGroup has not yet been implemented")
		}),
		AuthzGetRolesForUserHandler: authz.GetRolesForUserHandlerFunc(func(params authz.GetRolesForUserParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation authz.GetRolesForUser has not yet been implemented")
		}),
		AuthzGetRolesForUserDeprecatedHandler: authz.GetRolesForUserDeprecatedHandlerFunc(func(params authz.GetRolesForUserDeprecatedParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation authz.GetRolesForUserDeprecated has not yet been implemented")
		}),
		UsersGetUserInfoHandler: users.GetUserInfoHandlerFunc(func(params users.GetUserInfoParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation users.GetUserInfo has not yet been implemented")
		}),
		AuthzGetUsersForRoleHandler: authz.GetUsersForRoleHandlerFunc(func(params authz.GetUsersForRoleParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation authz.GetUsersForRole has not yet been implemented")
		}),
		AuthzGetUsersForRoleDeprecatedHandler: authz.GetUsersForRoleDeprecatedHandlerFunc(func(params authz.GetUsersForRoleDeprecatedParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation authz.GetUsersForRoleDeprecated has not yet been implemented")
		}),
		GraphqlGraphqlBatchHandler: graphql.GraphqlBatchHandlerFunc(func(params graphql.GraphqlBatchParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation graphql.GraphqlBatch has not yet been implemented")
		}),
		GraphqlGraphqlPostHandler: graphql.GraphqlPostHandlerFunc(func(params graphql.GraphqlPostParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation graphql.GraphqlPost has not yet been implemented")
		}),
		AuthzHasPermissionHandler: authz.HasPermissionHandlerFunc(func(params authz.HasPermissionParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation authz.HasPermission has not yet been implemented")
		}),
		UsersListAllUsersHandler: users.ListAllUsersHandlerFunc(func(params users.ListAllUsersParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation users.ListAllUsers has not yet been implemented")
		}),
		ReplicationListReplicationHandler: replication.ListReplicationHandlerFunc(func(params replication.ListReplicationParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation replication.ListReplication has not yet been implemented")
		}),
		MetaMetaGetHandler: meta.MetaGetHandlerFunc(func(params meta.MetaGetParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation meta.MetaGet has not yet been implemented")
		}),
		NodesNodesGetHandler: nodes.NodesGetHandlerFunc(func(params nodes.NodesGetParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation nodes.NodesGet has not yet been implemented")
		}),
		NodesNodesGetClassHandler: nodes.NodesGetClassHandlerFunc(func(params nodes.NodesGetClassParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation nodes.NodesGetClass has not yet been implemented")
		}),
		ObjectsObjectsClassDeleteHandler: objects.ObjectsClassDeleteHandlerFunc(func(params objects.ObjectsClassDeleteParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation objects.ObjectsClassDelete has not yet been implemented")
		}),
		ObjectsObjectsClassGetHandler: objects.ObjectsClassGetHandlerFunc(func(params objects.ObjectsClassGetParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation objects.ObjectsClassGet has not yet been implemented")
		}),
		ObjectsObjectsClassHeadHandler: objects.ObjectsClassHeadHandlerFunc(func(params objects.ObjectsClassHeadParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation objects.ObjectsClassHead has not yet been implemented")
		}),
		ObjectsObjectsClassPatchHandler: objects.ObjectsClassPatchHandlerFunc(func(params objects.ObjectsClassPatchParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation objects.ObjectsClassPatch has not yet been implemented")
		}),
		ObjectsObjectsClassPutHandler: objects.ObjectsClassPutHandlerFunc(func(params objects.ObjectsClassPutParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation objects.ObjectsClassPut has not yet been implemented")
		}),
		ObjectsObjectsClassReferencesCreateHandler: objects.ObjectsClassReferencesCreateHandlerFunc(func(params objects.ObjectsClassReferencesCreateParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation objects.ObjectsClassReferencesCreate has not yet been implemented")
		}),
		ObjectsObjectsClassReferencesDeleteHandler: objects.ObjectsClassReferencesDeleteHandlerFunc(func(params objects.ObjectsClassReferencesDeleteParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation objects.ObjectsClassReferencesDelete has not yet been implemented")
		}),
		ObjectsObjectsClassReferencesPutHandler: objects.ObjectsClassReferencesPutHandlerFunc(func(params objects.ObjectsClassReferencesPutParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation objects.ObjectsClassReferencesPut has not yet been implemented")
		}),
		ObjectsObjectsCreateHandler: objects.ObjectsCreateHandlerFunc(func(params objects.ObjectsCreateParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation objects.ObjectsCreate has not yet been implemented")
		}),
		ObjectsObjectsDeleteHandler: objects.ObjectsDeleteHandlerFunc(func(params objects.ObjectsDeleteParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation objects.ObjectsDelete has not yet been implemented")
		}),
		ObjectsObjectsGetHandler: objects.ObjectsGetHandlerFunc(func(params objects.ObjectsGetParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation objects.ObjectsGet has not yet been implemented")
		}),
		ObjectsObjectsHeadHandler: objects.ObjectsHeadHandlerFunc(func(params objects.ObjectsHeadParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation objects.ObjectsHead has not yet been implemented")
		}),
		ObjectsObjectsListHandler: objects.ObjectsListHandlerFunc(func(params objects.ObjectsListParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation objects.ObjectsList has not yet been implemented")
		}),
		ObjectsObjectsPatchHandler: objects.ObjectsPatchHandlerFunc(func(params objects.ObjectsPatchParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation objects.ObjectsPatch has not yet been implemented")
		}),
		ObjectsObjectsReferencesCreateHandler: objects.ObjectsReferencesCreateHandlerFunc(func(params objects.ObjectsReferencesCreateParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation objects.ObjectsReferencesCreate has not yet been implemented")
		}),
		ObjectsObjectsReferencesDeleteHandler: objects.ObjectsReferencesDeleteHandlerFunc(func(params objects.ObjectsReferencesDeleteParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation objects.ObjectsReferencesDelete has not yet been implemented")
		}),
		ObjectsObjectsReferencesUpdateHandler: objects.ObjectsReferencesUpdateHandlerFunc(func(params objects.ObjectsReferencesUpdateParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation objects.ObjectsReferencesUpdate has not yet been implemented")
		}),
		ObjectsObjectsUpdateHandler: objects.ObjectsUpdateHandlerFunc(func(params objects.ObjectsUpdateParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation objects.ObjectsUpdate has not yet been implemented")
		}),
		ObjectsObjectsValidateHandler: objects.ObjectsValidateHandlerFunc(func(params objects.ObjectsValidateParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation objects.ObjectsValidate has not yet been implemented")
		}),
		AuthzRemovePermissionsHandler: authz.RemovePermissionsHandlerFunc(func(params authz.RemovePermissionsParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation authz.RemovePermissions has not yet been implemented")
		}),
		ReplicationReplicateHandler: replication.ReplicateHandlerFunc(func(params replication.ReplicateParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation replication.Replicate has not yet been implemented")
		}),
		ReplicationReplicationDetailsHandler: replication.ReplicationDetailsHandlerFunc(func(params replication.ReplicationDetailsParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation replication.ReplicationDetails has not yet been implemented")
		}),
		AuthzRevokeRoleFromGroupHandler: authz.RevokeRoleFromGroupHandlerFunc(func(params authz.RevokeRoleFromGroupParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation authz.RevokeRoleFromGroup has not yet been implemented")
		}),
		AuthzRevokeRoleFromUserHandler: authz.RevokeRoleFromUserHandlerFunc(func(params authz.RevokeRoleFromUserParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation authz.RevokeRoleFromUser has not yet been implemented")
		}),
		UsersRotateUserAPIKeyHandler: users.RotateUserAPIKeyHandlerFunc(func(params users.RotateUserAPIKeyParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation users.RotateUserAPIKey has not yet been implemented")
		}),
		SchemaSchemaDumpHandler: schema.SchemaDumpHandlerFunc(func(params schema.SchemaDumpParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation schema.SchemaDump has not yet been implemented")
		}),
		SchemaSchemaObjectsCreateHandler: schema.SchemaObjectsCreateHandlerFunc(func(params schema.SchemaObjectsCreateParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation schema.SchemaObjectsCreate has not yet been implemented")
		}),
		SchemaSchemaObjectsDeleteHandler: schema.SchemaObjectsDeleteHandlerFunc(func(params schema.SchemaObjectsDeleteParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation schema.SchemaObjectsDelete has not yet been implemented")
		}),
		SchemaSchemaObjectsGetHandler: schema.SchemaObjectsGetHandlerFunc(func(params schema.SchemaObjectsGetParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation schema.SchemaObjectsGet has not yet been implemented")
		}),
		SchemaSchemaObjectsPropertiesAddHandler: schema.SchemaObjectsPropertiesAddHandlerFunc(func(params schema.SchemaObjectsPropertiesAddParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation schema.SchemaObjectsPropertiesAdd has not yet been implemented")
		}),
		SchemaSchemaObjectsShardsGetHandler: schema.SchemaObjectsShardsGetHandlerFunc(func(params schema.SchemaObjectsShardsGetParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation schema.SchemaObjectsShardsGet has not yet been implemented")
		}),
		SchemaSchemaObjectsShardsUpdateHandler: schema.SchemaObjectsShardsUpdateHandlerFunc(func(params schema.SchemaObjectsShardsUpdateParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation schema.SchemaObjectsShardsUpdate has not yet been implemented")
		}),
		SchemaSchemaObjectsUpdateHandler: schema.SchemaObjectsUpdateHandlerFunc(func(params schema.SchemaObjectsUpdateParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation schema.SchemaObjectsUpdate has not yet been implemented")
		}),
		SchemaTenantExistsHandler: schema.TenantExistsHandlerFunc(func(params schema.TenantExistsParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation schema.TenantExists has not yet been implemented")
		}),
		SchemaTenantsCreateHandler: schema.TenantsCreateHandlerFunc(func(params schema.TenantsCreateParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation schema.TenantsCreate has not yet been implemented")
		}),
		SchemaTenantsDeleteHandler: schema.TenantsDeleteHandlerFunc(func(params schema.TenantsDeleteParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation schema.TenantsDelete has not yet been implemented")
		}),
		SchemaTenantsGetHandler: schema.TenantsGetHandlerFunc(func(params schema.TenantsGetParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation schema.TenantsGet has not yet been implemented")
		}),
		SchemaTenantsGetOneHandler: schema.TenantsGetOneHandlerFunc(func(params schema.TenantsGetOneParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation schema.TenantsGetOne has not yet been implemented")
		}),
		SchemaTenantsUpdateHandler: schema.TenantsUpdateHandlerFunc(func(params schema.TenantsUpdateParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation schema.TenantsUpdate has not yet been implemented")
		}),
		WeaviateRootHandler: WeaviateRootHandlerFunc(func(params WeaviateRootParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation WeaviateRoot has not yet been implemented")
		}),
		WeaviateWellknownLivenessHandler: WeaviateWellknownLivenessHandlerFunc(func(params WeaviateWellknownLivenessParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation WeaviateWellknownLiveness has not yet been implemented")
		}),
		WeaviateWellknownReadinessHandler: WeaviateWellknownReadinessHandlerFunc(func(params WeaviateWellknownReadinessParams, principal *models.Principal) middleware.Responder {
			return middleware.NotImplemented("operation WeaviateWellknownReadiness has not yet been implemented")
		}),

		OidcAuth: func(token string, scopes []string) (*models.Principal, error) {
			return nil, errors.NotImplemented("oauth2 bearer auth (oidc) has not yet been implemented")
		},
		// default authorizer is authorized meaning no requests are blocked
		APIAuthorizer: security.Authorized(),
	}
}

/*WeaviateAPI # Introduction<br/> Weaviate is an open source, AI-native vector database that helps developers create intuitive and reliable AI-powered applications. <br/> ### Base Path <br/>The base path for the Weaviate server is structured as `[YOUR-WEAVIATE-HOST]:[PORT]/v1`. As an example, if you wish to access the `schema` endpoint on a local instance, you would navigate to `http://localhost:8080/v1/schema`. Ensure you replace `[YOUR-WEAVIATE-HOST]` and `[PORT]` with your actual server host and port number respectively. <br/> ### Questions? <br/>If you have any comments or questions, please feel free to reach out to us at the community forum [https://forum.weaviate.io/](https://forum.weaviate.io/). <br/>### Issues? <br/>If you find a bug or want to file a feature request, please open an issue on our GitHub repository for [Weaviate](https://github.com/weaviate/weaviate). <br/>### Need more documentation? <br/>For a quickstart, code examples, concepts and more, please visit our [documentation page](https://docs.weaviate.io/weaviate). */
type WeaviateAPI struct {
	spec            *loads.Document
	context         *middleware.Context
	handlers        map[string]map[string]http.Handler
	formats         strfmt.Registry
	customConsumers map[string]runtime.Consumer
	customProducers map[string]runtime.Producer
	defaultConsumes string
	defaultProduces string
	Middleware      func(middleware.Builder) http.Handler
	useSwaggerUI    bool

	// BasicAuthenticator generates a runtime.Authenticator from the supplied basic auth function.
	// It has a default implementation in the security package, however you can replace it for your particular usage.
	BasicAuthenticator func(security.UserPassAuthentication) runtime.Authenticator

	// APIKeyAuthenticator generates a runtime.Authenticator from the supplied token auth function.
	// It has a default implementation in the security package, however you can replace it for your particular usage.
	APIKeyAuthenticator func(string, string, security.TokenAuthentication) runtime.Authenticator

	// BearerAuthenticator generates a runtime.Authenticator from the supplied bearer token auth function.
	// It has a default implementation in the security package, however you can replace it for your particular usage.
	BearerAuthenticator func(string, security.ScopedTokenAuthentication) runtime.Authenticator

	// JSONConsumer registers a consumer for the following mime types:
	//   - application/json
	JSONConsumer runtime.Consumer
	// YamlConsumer registers a consumer for the following mime types:
	//   - application/yaml
	YamlConsumer runtime.Consumer

	// JSONProducer registers a producer for the following mime types:
	//   - application/json
	JSONProducer runtime.Producer

	// OidcAuth registers a function that takes an access token and a collection of required scopes and returns a principal
	// it performs authentication based on an oauth2 bearer token provided in the request
	OidcAuth func(string, []string) (*models.Principal, error)

	// APIAuthorizer provides access control (ACL/RBAC/ABAC) by providing access to the request and authenticated principal
	APIAuthorizer runtime.Authorizer

	// WellKnownGetWellKnownOpenidConfigurationHandler sets the operation handler for the get well known openid configuration operation
	WellKnownGetWellKnownOpenidConfigurationHandler well_known.GetWellKnownOpenidConfigurationHandler
	// UsersActivateUserHandler sets the operation handler for the activate user operation
	UsersActivateUserHandler users.ActivateUserHandler
	// AuthzAddPermissionsHandler sets the operation handler for the add permissions operation
	AuthzAddPermissionsHandler authz.AddPermissionsHandler
	// SchemaAliasesCreateHandler sets the operation handler for the aliases create operation
	SchemaAliasesCreateHandler schema.AliasesCreateHandler
	// SchemaAliasesDeleteHandler sets the operation handler for the aliases delete operation
	SchemaAliasesDeleteHandler schema.AliasesDeleteHandler
	// SchemaAliasesGetHandler sets the operation handler for the aliases get operation
	SchemaAliasesGetHandler schema.AliasesGetHandler
	// SchemaAliasesGetAliasHandler sets the operation handler for the aliases get alias operation
	SchemaAliasesGetAliasHandler schema.AliasesGetAliasHandler
	// SchemaAliasesUpdateHandler sets the operation handler for the aliases update operation
	SchemaAliasesUpdateHandler schema.AliasesUpdateHandler
	// ReplicationApplyReplicationScalePlanHandler sets the operation handler for the apply replication scale plan operation
	ReplicationApplyReplicationScalePlanHandler replication.ApplyReplicationScalePlanHandler
	// AuthzAssignRoleToGroupHandler sets the operation handler for the assign role to group operation
	AuthzAssignRoleToGroupHandler authz.AssignRoleToGroupHandler
	// AuthzAssignRoleToUserHandler sets the operation handler for the assign role to user operation
	AuthzAssignRoleToUserHandler authz.AssignRoleToUserHandler
	// BackupsBackupsCancelHandler sets the operation handler for the backups cancel operation
	BackupsBackupsCancelHandler backups.BackupsCancelHandler
	// BackupsBackupsCreateHandler sets the operation handler for the backups create operation
	BackupsBackupsCreateHandler backups.BackupsCreateHandler
	// BackupsBackupsCreateStatusHandler sets the operation handler for the backups create status operation
	BackupsBackupsCreateStatusHandler backups.BackupsCreateStatusHandler
	// BackupsBackupsListHandler sets the operation handler for the backups list operation
	BackupsBackupsListHandler backups.BackupsListHandler
	// BackupsBackupsRestoreHandler sets the operation handler for the backups restore operation
	BackupsBackupsRestoreHandler backups.BackupsRestoreHandler
	// BackupsBackupsRestoreStatusHandler sets the operation handler for the backups restore status operation
	BackupsBackupsRestoreStatusHandler backups.BackupsRestoreStatusHandler
	// BatchBatchObjectsCreateHandler sets the operation handler for the batch objects create operation
	BatchBatchObjectsCreateHandler batch.BatchObjectsCreateHandler
	// BatchBatchObjectsDeleteHandler sets the operation handler for the batch objects delete operation
	BatchBatchObjectsDeleteHandler batch.BatchObjectsDeleteHandler
	// BatchBatchReferencesCreateHandler sets the operation handler for the batch references create operation
	BatchBatchReferencesCreateHandler batch.BatchReferencesCreateHandler
	// ReplicationCancelReplicationHandler sets the operation handler for the cancel replication operation
	ReplicationCancelReplicationHandler replication.CancelReplicationHandler
	// ClassificationsClassificationsGetHandler sets the operation handler for the classifications get operation
	ClassificationsClassificationsGetHandler classifications.ClassificationsGetHandler
	// ClassificationsClassificationsPostHandler sets the operation handler for the classifications post operation
	ClassificationsClassificationsPostHandler classifications.ClassificationsPostHandler
	// ClusterClusterGetStatisticsHandler sets the operation handler for the cluster get statistics operation
	ClusterClusterGetStatisticsHandler cluster.ClusterGetStatisticsHandler
	// AuthzCreateRoleHandler sets the operation handler for the create role operation
	AuthzCreateRoleHandler authz.CreateRoleHandler
	// UsersCreateUserHandler sets the operation handler for the create user operation
	UsersCreateUserHandler users.CreateUserHandler
	// UsersDeactivateUserHandler sets the operation handler for the deactivate user operation
	UsersDeactivateUserHandler users.DeactivateUserHandler
	// ReplicationDeleteAllReplicationsHandler sets the operation handler for the delete all replications operation
	ReplicationDeleteAllReplicationsHandler replication.DeleteAllReplicationsHandler
	// ReplicationDeleteReplicationHandler sets the operation handler for the delete replication operation
	ReplicationDeleteReplicationHandler replication.DeleteReplicationHandler
	// AuthzDeleteRoleHandler sets the operation handler for the delete role operation
	AuthzDeleteRoleHandler authz.DeleteRoleHandler
	// UsersDeleteUserHandler sets the operation handler for the delete user operation
	UsersDeleteUserHandler users.DeleteUserHandler
	// DistributedTasksDistributedTasksGetHandler sets the operation handler for the distributed tasks get operation
	DistributedTasksDistributedTasksGetHandler distributed_tasks.DistributedTasksGetHandler
	// ReplicationForceDeleteReplicationsHandler sets the operation handler for the force delete replications operation
	ReplicationForceDeleteReplicationsHandler replication.ForceDeleteReplicationsHandler
	// ReplicationGetCollectionShardingStateHandler sets the operation handler for the get collection sharding state operation
	ReplicationGetCollectionShardingStateHandler replication.GetCollectionShardingStateHandler
	// AuthzGetGroupsHandler sets the operation handler for the get groups operation
	AuthzGetGroupsHandler authz.GetGroupsHandler
	// AuthzGetGroupsForRoleHandler sets the operation handler for the get groups for role operation
	AuthzGetGroupsForRoleHandler authz.GetGroupsForRoleHandler
	// UsersGetOwnInfoHandler sets the operation handler for the get own info operation
	UsersGetOwnInfoHandler users.GetOwnInfoHandler
	// ReplicationGetReplicationScalePlanHandler sets the operation handler for the get replication scale plan operation
	ReplicationGetReplicationScalePlanHandler replication.GetReplicationScalePlanHandler
	// AuthzGetRoleHandler sets the operation handler for the get role operation
	AuthzGetRoleHandler authz.GetRoleHandler
	// AuthzGetRolesHandler sets the operation handler for the get roles operation
	AuthzGetRolesHandler authz.GetRolesHandler
	// AuthzGetRolesForGroupHandler sets the operation handler for the get roles for group operation
	AuthzGetRolesForGroupHandler authz.GetRolesForGroupHandler
	// AuthzGetRolesForUserHandler sets the operation handler for the get roles for user operation
	AuthzGetRolesForUserHandler authz.GetRolesForUserHandler
	// AuthzGetRolesForUserDeprecatedHandler sets the operation handler for the get roles for user deprecated operation
	AuthzGetRolesForUserDeprecatedHandler authz.GetRolesForUserDeprecatedHandler
	// UsersGetUserInfoHandler sets the operation handler for the get user info operation
	UsersGetUserInfoHandler users.GetUserInfoHandler
	// AuthzGetUsersForRoleHandler sets the operation handler for the get users for role operation
	AuthzGetUsersForRoleHandler authz.GetUsersForRoleHandler
	// AuthzGetUsersForRoleDeprecatedHandler sets the operation handler for the get users for role deprecated operation
	AuthzGetUsersForRoleDeprecatedHandler authz.GetUsersForRoleDeprecatedHandler
	// GraphqlGraphqlBatchHandler sets the operation handler for the graphql batch operation
	GraphqlGraphqlBatchHandler graphql.GraphqlBatchHandler
	// GraphqlGraphqlPostHandler sets the operation handler for the graphql post operation
	GraphqlGraphqlPostHandler graphql.GraphqlPostHandler
	// AuthzHasPermissionHandler sets the operation handler for the has permission operation
	AuthzHasPermissionHandler authz.HasPermissionHandler
	// UsersListAllUsersHandler sets the operation handler for the list all users operation
	UsersListAllUsersHandler users.ListAllUsersHandler
	// ReplicationListReplicationHandler sets the operation handler for the list replication operation
	ReplicationListReplicationHandler replication.ListReplicationHandler
	// MetaMetaGetHandler sets the operation handler for the meta get operation
	MetaMetaGetHandler meta.MetaGetHandler
	// NodesNodesGetHandler sets the operation handler for the nodes get operation
	NodesNodesGetHandler nodes.NodesGetHandler
	// NodesNodesGetClassHandler sets the operation handler for the nodes get class operation
	NodesNodesGetClassHandler nodes.NodesGetClassHandler
	// ObjectsObjectsClassDeleteHandler sets the operation handler for the objects class delete operation
	ObjectsObjectsClassDeleteHandler objects.ObjectsClassDeleteHandler
	// ObjectsObjectsClassGetHandler sets the operation handler for the objects class get operation
	ObjectsObjectsClassGetHandler objects.ObjectsClassGetHandler
	// ObjectsObjectsClassHeadHandler sets the operation handler for the objects class head operation
	ObjectsObjectsClassHeadHandler objects.ObjectsClassHeadHandler
	// ObjectsObjectsClassPatchHandler sets the operation handler for the objects class patch operation
	ObjectsObjectsClassPatchHandler objects.ObjectsClassPatchHandler
	// ObjectsObjectsClassPutHandler sets the operation handler for the objects class put operation
	ObjectsObjectsClassPutHandler objects.ObjectsClassPutHandler
	// ObjectsObjectsClassReferencesCreateHandler sets the operation handler for the objects class references create operation
	ObjectsObjectsClassReferencesCreateHandler objects.ObjectsClassReferencesCreateHandler
	// ObjectsObjectsClassReferencesDeleteHandler sets the operation handler for the objects class references delete operation
	ObjectsObjectsClassReferencesDeleteHandler objects.ObjectsClassReferencesDeleteHandler
	// ObjectsObjectsClassReferencesPutHandler sets the operation handler for the objects class references put operation
	ObjectsObjectsClassReferencesPutHandler objects.ObjectsClassReferencesPutHandler
	// ObjectsObjectsCreateHandler sets the operation handler for the objects create operation
	ObjectsObjectsCreateHandler objects.ObjectsCreateHandler
	// ObjectsObjectsDeleteHandler sets the operation handler for the objects delete operation
	ObjectsObjectsDeleteHandler objects.ObjectsDeleteHandler
	// ObjectsObjectsGetHandler sets the operation handler for the objects get operation
	ObjectsObjectsGetHandler objects.ObjectsGetHandler
	// ObjectsObjectsHeadHandler sets the operation handler for the objects head operation
	ObjectsObjectsHeadHandler objects.ObjectsHeadHandler
	// ObjectsObjectsListHandler sets the operation handler for the objects list operation
	ObjectsObjectsListHandler objects.ObjectsListHandler
	// ObjectsObjectsPatchHandler sets the operation handler for the objects patch operation
	ObjectsObjectsPatchHandler objects.ObjectsPatchHandler
	// ObjectsObjectsReferencesCreateHandler sets the operation handler for the objects references create operation
	ObjectsObjectsReferencesCreateHandler objects.ObjectsReferencesCreateHandler
	// ObjectsObjectsReferencesDeleteHandler sets the operation handler for the objects references delete operation
	ObjectsObjectsReferencesDeleteHandler objects.ObjectsReferencesDeleteHandler
	// ObjectsObjectsReferencesUpdateHandler sets the operation handler for the objects references update operation
	ObjectsObjectsReferencesUpdateHandler objects.ObjectsReferencesUpdateHandler
	// ObjectsObjectsUpdateHandler sets the operation handler for the objects update operation
	ObjectsObjectsUpdateHandler objects.ObjectsUpdateHandler
	// ObjectsObjectsValidateHandler sets the operation handler for the objects validate operation
	ObjectsObjectsValidateHandler objects.ObjectsValidateHandler
	// AuthzRemovePermissionsHandler sets the operation handler for the remove permissions operation
	AuthzRemovePermissionsHandler authz.RemovePermissionsHandler
	// ReplicationReplicateHandler sets the operation handler for the replicate operation
	ReplicationReplicateHandler replication.ReplicateHandler
	// ReplicationReplicationDetailsHandler sets the operation handler for the replication details operation
	ReplicationReplicationDetailsHandler replication.ReplicationDetailsHandler
	// AuthzRevokeRoleFromGroupHandler sets the operation handler for the revoke role from group operation
	AuthzRevokeRoleFromGroupHandler authz.RevokeRoleFromGroupHandler
	// AuthzRevokeRoleFromUserHandler sets the operation handler for the revoke role from user operation
	AuthzRevokeRoleFromUserHandler authz.RevokeRoleFromUserHandler
	// UsersRotateUserAPIKeyHandler sets the operation handler for the rotate user Api key operation
	UsersRotateUserAPIKeyHandler users.RotateUserAPIKeyHandler
	// SchemaSchemaDumpHandler sets the operation handler for the schema dump operation
	SchemaSchemaDumpHandler schema.SchemaDumpHandler
	// SchemaSchemaObjectsCreateHandler sets the operation handler for the schema objects create operation
	SchemaSchemaObjectsCreateHandler schema.SchemaObjectsCreateHandler
	// SchemaSchemaObjectsDeleteHandler sets the operation handler for the schema objects delete operation
	SchemaSchemaObjectsDeleteHandler schema.SchemaObjectsDeleteHandler
	// SchemaSchemaObjectsGetHandler sets the operation handler for the schema objects get operation
	SchemaSchemaObjectsGetHandler schema.SchemaObjectsGetHandler
	// SchemaSchemaObjectsPropertiesAddHandler sets the operation handler for the schema objects properties add operation
	SchemaSchemaObjectsPropertiesAddHandler schema.SchemaObjectsPropertiesAddHandler
	// SchemaSchemaObjectsShardsGetHandler sets the operation handler for the schema objects shards get operation
	SchemaSchemaObjectsShardsGetHandler schema.SchemaObjectsShardsGetHandler
	// SchemaSchemaObjectsShardsUpdateHandler sets the operation handler for the schema objects shards update operation
	SchemaSchemaObjectsShardsUpdateHandler schema.SchemaObjectsShardsUpdateHandler
	// SchemaSchemaObjectsUpdateHandler sets the operation handler for the schema objects update operation
	SchemaSchemaObjectsUpdateHandler schema.SchemaObjectsUpdateHandler
	// SchemaTenantExistsHandler sets the operation handler for the tenant exists operation
	SchemaTenantExistsHandler schema.TenantExistsHandler
	// SchemaTenantsCreateHandler sets the operation handler for the tenants create operation
	SchemaTenantsCreateHandler schema.TenantsCreateHandler
	// SchemaTenantsDeleteHandler sets the operation handler for the tenants delete operation
	SchemaTenantsDeleteHandler schema.TenantsDeleteHandler
	// SchemaTenantsGetHandler sets the operation handler for the tenants get operation
	SchemaTenantsGetHandler schema.TenantsGetHandler
	// SchemaTenantsGetOneHandler sets the operation handler for the tenants get one operation
	SchemaTenantsGetOneHandler schema.TenantsGetOneHandler
	// SchemaTenantsUpdateHandler sets the operation handler for the tenants update operation
	SchemaTenantsUpdateHandler schema.TenantsUpdateHandler
	// WeaviateRootHandler sets the operation handler for the weaviate root operation
	WeaviateRootHandler WeaviateRootHandler
	// WeaviateWellknownLivenessHandler sets the operation handler for the weaviate wellknown liveness operation
	WeaviateWellknownLivenessHandler WeaviateWellknownLivenessHandler
	// WeaviateWellknownReadinessHandler sets the operation handler for the weaviate wellknown readiness operation
	WeaviateWellknownReadinessHandler WeaviateWellknownReadinessHandler

	// ServeError is called when an error is received, there is a default handler
	// but you can set your own with this
	ServeError func(http.ResponseWriter, *http.Request, error)

	// PreServerShutdown is called before the HTTP(S) server is shutdown
	// This allows for custom functions to get executed before the HTTP(S) server stops accepting traffic
	PreServerShutdown func()

	// ServerShutdown is called when the HTTP(S) server is shut down and done
	// handling all active connections and does not accept connections any more
	ServerShutdown func()

	// Custom command line argument groups with their descriptions
	CommandLineOptionsGroups []swag.CommandLineOptionsGroup

	// User defined logger function.
	Logger func(string, ...interface{})
}

// UseRedoc for documentation at /docs
func (o *WeaviateAPI) UseRedoc() {
	o.useSwaggerUI = false
}

// UseSwaggerUI for documentation at /docs
func (o *WeaviateAPI) UseSwaggerUI() {
	o.useSwaggerUI = true
}

// SetDefaultProduces sets the default produces media type
func (o *WeaviateAPI) SetDefaultProduces(mediaType string) {
	o.defaultProduces = mediaType
}

// SetDefaultConsumes returns the default consumes media type
func (o *WeaviateAPI) SetDefaultConsumes(mediaType string) {
	o.defaultConsumes = mediaType
}

// SetSpec sets a spec that will be served for the clients.
func (o *WeaviateAPI) SetSpec(spec *loads.Document) {
	o.spec = spec
}

// DefaultProduces returns the default produces media type
func (o *WeaviateAPI) DefaultProduces() string {
	return o.defaultProduces
}

// DefaultConsumes returns the default consumes media type
func (o *WeaviateAPI) DefaultConsumes() string {
	return o.defaultConsumes
}

// Formats returns the registered string formats
func (o *WeaviateAPI) Formats() strfmt.Registry {
	return o.formats
}

// RegisterFormat registers a custom format validator
func (o *WeaviateAPI) RegisterFormat(name string, format strfmt.Format, validator strfmt.Validator) {
	o.formats.Add(name, format, validator)
}

// Validate validates the registrations in the WeaviateAPI
func (o *WeaviateAPI) Validate() error {
	var unregistered []string

	if o.JSONConsumer == nil {
		unregistered = append(unregistered, "JSONConsumer")
	}
	if o.YamlConsumer == nil {
		unregistered = append(unregistered, "YamlConsumer")
	}

	if o.JSONProducer == nil {
		unregistered = append(unregistered, "JSONProducer")
	}

	if o.OidcAuth == nil {
		unregistered = append(unregistered, "OidcAuth")
	}

	if o.WellKnownGetWellKnownOpenidConfigurationHandler == nil {
		unregistered = append(unregistered, "well_known.GetWellKnownOpenidConfigurationHandler")
	}
	if o.UsersActivateUserHandler == nil {
		unregistered = append(unregistered, "users.ActivateUserHandler")
	}
	if o.AuthzAddPermissionsHandler == nil {
		unregistered = append(unregistered, "authz.AddPermissionsHandler")
	}
	if o.SchemaAliasesCreateHandler == nil {
		unregistered = append(unregistered, "schema.AliasesCreateHandler")
	}
	if o.SchemaAliasesDeleteHandler == nil {
		unregistered = append(unregistered, "schema.AliasesDeleteHandler")
	}
	if o.SchemaAliasesGetHandler == nil {
		unregistered = append(unregistered, "schema.AliasesGetHandler")
	}
	if o.SchemaAliasesGetAliasHandler == nil {
		unregistered = append(unregistered, "schema.AliasesGetAliasHandler")
	}
	if o.SchemaAliasesUpdateHandler == nil {
		unregistered = append(unregistered, "schema.AliasesUpdateHandler")
	}
	if o.ReplicationApplyReplicationScalePlanHandler == nil {
		unregistered = append(unregistered, "replication.ApplyReplicationScalePlanHandler")
	}
	if o.AuthzAssignRoleToGroupHandler == nil {
		unregistered = append(unregistered, "authz.AssignRoleToGroupHandler")
	}
	if o.AuthzAssignRoleToUserHandler == nil {
		unregistered = append(unregistered, "authz.AssignRoleToUserHandler")
	}
	if o.BackupsBackupsCancelHandler == nil {
		unregistered = append(unregistered, "backups.BackupsCancelHandler")
	}
	if o.BackupsBackupsCreateHandler == nil {
		unregistered = append(unregistered, "backups.BackupsCreateHandler")
	}
	if o.BackupsBackupsCreateStatusHandler == nil {
		unregistered = append(unregistered, "backups.BackupsCreateStatusHandler")
	}
	if o.BackupsBackupsListHandler == nil {
		unregistered = append(unregistered, "backups.BackupsListHandler")
	}
	if o.BackupsBackupsRestoreHandler == nil {
		unregistered = append(unregistered, "backups.BackupsRestoreHandler")
	}
	if o.BackupsBackupsRestoreStatusHandler == nil {
		unregistered = append(unregistered, "backups.BackupsRestoreStatusHandler")
	}
	if o.BatchBatchObjectsCreateHandler == nil {
		unregistered = append(unregistered, "batch.BatchObjectsCreateHandler")
	}
	if o.BatchBatchObjectsDeleteHandler == nil {
		unregistered = append(unregistered, "batch.BatchObjectsDeleteHandler")
	}
	if o.BatchBatchReferencesCreateHandler == nil {
		unregistered = append(unregistered, "batch.BatchReferencesCreateHandler")
	}
	if o.ReplicationCancelReplicationHandler == nil {
		unregistered = append(unregistered, "replication.CancelReplicationHandler")
	}
	if o.ClassificationsClassificationsGetHandler == nil {
		unregistered = append(unregistered, "classifications.ClassificationsGetHandler")
	}
	if o.ClassificationsClassificationsPostHandler == nil {
		unregistered = append(unregistered, "classifications.ClassificationsPostHandler")
	}
	if o.ClusterClusterGetStatisticsHandler == nil {
		unregistered = append(unregistered, "cluster.ClusterGetStatisticsHandler")
	}
	if o.AuthzCreateRoleHandler == nil {
		unregistered = append(unregistered, "authz.CreateRoleHandler")
	}
	if o.UsersCreateUserHandler == nil {
		unregistered = append(unregistered, "users.CreateUserHandler")
	}
	if o.UsersDeactivateUserHandler == nil {
		unregistered = append(unregistered, "users.DeactivateUserHandler")
	}
	if o.ReplicationDeleteAllReplicationsHandler == nil {
		unregistered = append(unregistered, "replication.DeleteAllReplicationsHandler")
	}
	if o.ReplicationDeleteReplicationHandler == nil {
		unregistered = append(unregistered, "replication.DeleteReplicationHandler")
	}
	if o.AuthzDeleteRoleHandler == nil {
		unregistered = append(unregistered, "authz.DeleteRoleHandler")
	}
	if o.UsersDeleteUserHandler == nil {
		unregistered = append(unregistered, "users.DeleteUserHandler")
	}
	if o.DistributedTasksDistributedTasksGetHandler == nil {
		unregistered = append(unregistered, "distributed_tasks.DistributedTasksGetHandler")
	}
	if o.ReplicationForceDeleteReplicationsHandler == nil {
		unregistered = append(unregistered, "replication.ForceDeleteReplicationsHandler")
	}
	if o.ReplicationGetCollectionShardingStateHandler == nil {
		unregistered = append(unregistered, "replication.GetCollectionShardingStateHandler")
	}
	if o.AuthzGetGroupsHandler == nil {
		unregistered = append(unregistered, "authz.GetGroupsHandler")
	}
	if o.AuthzGetGroupsForRoleHandler == nil {
		unregistered = append(unregistered, "authz.GetGroupsForRoleHandler")
	}
	if o.UsersGetOwnInfoHandler == nil {
		unregistered = append(unregistered, "users.GetOwnInfoHandler")
	}
	if o.ReplicationGetReplicationScalePlanHandler == nil {
		unregistered = append(unregistered, "replication.GetReplicationScalePlanHandler")
	}
	if o.AuthzGetRoleHandler == nil {
		unregistered = append(unregistered, "authz.GetRoleHandler")
	}
	if o.AuthzGetRolesHandler == nil {
		unregistered = append(unregistered, "authz.GetRolesHandler")
	}
	if o.AuthzGetRolesForGroupHandler == nil {
		unregistered = append(unregistered, "authz.GetRolesForGroupHandler")
	}
	if o.AuthzGetRolesForUserHandler == nil {
		unregistered = append(unregistered, "authz.GetRolesForUserHandler")
	}
	if o.AuthzGetRolesForUserDeprecatedHandler == nil {
		unregistered = append(unregistered, "authz.GetRolesForUserDeprecatedHandler")
	}
	if o.UsersGetUserInfoHandler == nil {
		unregistered = append(unregistered, "users.GetUserInfoHandler")
	}
	if o.AuthzGetUsersForRoleHandler == nil {
		unregistered = append(unregistered, "authz.GetUsersForRoleHandler")
	}
	if o.AuthzGetUsersForRoleDeprecatedHandler == nil {
		unregistered = append(unregistered, "authz.GetUsersForRoleDeprecatedHandler")
	}
	if o.GraphqlGraphqlBatchHandler == nil {
		unregistered = append(unregistered, "graphql.GraphqlBatchHandler")
	}
	if o.GraphqlGraphqlPostHandler == nil {
		unregistered = append(unregistered, "graphql.GraphqlPostHandler")
	}
	if o.AuthzHasPermissionHandler == nil {
		unregistered = append(unregistered, "authz.HasPermissionHandler")
	}
	if o.UsersListAllUsersHandler == nil {
		unregistered = append(unregistered, "users.ListAllUsersHandler")
	}
	if o.ReplicationListReplicationHandler == nil {
		unregistered = append(unregistered, "replication.ListReplicationHandler")
	}
	if o.MetaMetaGetHandler == nil {
		unregistered = append(unregistered, "meta.MetaGetHandler")
	}
	if o.NodesNodesGetHandler == nil {
		unregistered = append(unregistered, "nodes.NodesGetHandler")
	}
	if o.NodesNodesGetClassHandler == nil {
		unregistered = append(unregistered, "nodes.NodesGetClassHandler")
	}
	if o.ObjectsObjectsClassDeleteHandler == nil {
		unregistered = append(unregistered, "objects.ObjectsClassDeleteHandler")
	}
	if o.ObjectsObjectsClassGetHandler == nil {
		unregistered = append(unregistered, "objects.ObjectsClassGetHandler")
	}
	if o.ObjectsObjectsClassHeadHandler == nil {
		unregistered = append(unregistered, "objects.ObjectsClassHeadHandler")
	}
	if o.ObjectsObjectsClassPatchHandler == nil {
		unregistered = append(unregistered, "objects.ObjectsClassPatchHandler")
	}
	if o.ObjectsObjectsClassPutHandler == nil {
		unregistered = append(unregistered, "objects.ObjectsClassPutHandler")
	}
	if o.ObjectsObjectsClassReferencesCreateHandler == nil {
		unregistered = append(unregistered, "objects.ObjectsClassReferencesCreateHandler")
	}
	if o.ObjectsObjectsClassReferencesDeleteHandler == nil {
		unregistered = append(unregistered, "objects.ObjectsClassReferencesDeleteHandler")
	}
	if o.ObjectsObjectsClassReferencesPutHandler == nil {
		unregistered = append(unregistered, "objects.ObjectsClassReferencesPutHandler")
	}
	if o.ObjectsObjectsCreateHandler == nil {
		unregistered = append(unregistered, "objects.ObjectsCreateHandler")
	}
	if o.ObjectsObjectsDeleteHandler == nil {
		unregistered = append(unregistered, "objects.ObjectsDeleteHandler")
	}
	if o.ObjectsObjectsGetHandler == nil {
		unregistered = append(unregistered, "objects.ObjectsGetHandler")
	}
	if o.ObjectsObjectsHeadHandler == nil {
		unregistered = append(unregistered, "objects.ObjectsHeadHandler")
	}
	if o.ObjectsObjectsListHandler == nil {
		unregistered = append(unregistered, "objects.ObjectsListHandler")
	}
	if o.ObjectsObjectsPatchHandler == nil {
		unregistered = append(unregistered, "objects.ObjectsPatchHandler")
	}
	if o.ObjectsObjectsReferencesCreateHandler == nil {
		unregistered = append(unregistered, "objects.ObjectsReferencesCreateHandler")
	}
	if o.ObjectsObjectsReferencesDeleteHandler == nil {
		unregistered = append(unregistered, "objects.ObjectsReferencesDeleteHandler")
	}
	if o.ObjectsObjectsReferencesUpdateHandler == nil {
		unregistered = append(unregistered, "objects.ObjectsReferencesUpdateHandler")
	}
	if o.ObjectsObjectsUpdateHandler == nil {
		unregistered = append(unregistered, "objects.ObjectsUpdateHandler")
	}
	if o.ObjectsObjectsValidateHandler == nil {
		unregistered = append(unregistered, "objects.ObjectsValidateHandler")
	}
	if o.AuthzRemovePermissionsHandler == nil {
		unregistered = append(unregistered, "authz.RemovePermissionsHandler")
	}
	if o.ReplicationReplicateHandler == nil {
		unregistered = append(unregistered, "replication.ReplicateHandler")
	}
	if o.ReplicationReplicationDetailsHandler == nil {
		unregistered = append(unregistered, "replication.ReplicationDetailsHandler")
	}
	if o.AuthzRevokeRoleFromGroupHandler == nil {
		unregistered = append(unregistered, "authz.RevokeRoleFromGroupHandler")
	}
	if o.AuthzRevokeRoleFromUserHandler == nil {
		unregistered = append(unregistered, "authz.RevokeRoleFromUserHandler")
	}
	if o.UsersRotateUserAPIKeyHandler == nil {
		unregistered = append(unregistered, "users.RotateUserAPIKeyHandler")
	}
	if o.SchemaSchemaDumpHandler == nil {
		unregistered = append(unregistered, "schema.SchemaDumpHandler")
	}
	if o.SchemaSchemaObjectsCreateHandler == nil {
		unregistered = append(unregistered, "schema.SchemaObjectsCreateHandler")
	}
	if o.SchemaSchemaObjectsDeleteHandler == nil {
		unregistered = append(unregistered, "schema.SchemaObjectsDeleteHandler")
	}
	if o.SchemaSchemaObjectsGetHandler == nil {
		unregistered = append(unregistered, "schema.SchemaObjectsGetHandler")
	}
	if o.SchemaSchemaObjectsPropertiesAddHandler == nil {
		unregistered = append(unregistered, "schema.SchemaObjectsPropertiesAddHandler")
	}
	if o.SchemaSchemaObjectsShardsGetHandler == nil {
		unregistered = append(unregistered, "schema.SchemaObjectsShardsGetHandler")
	}
	if o.SchemaSchemaObjectsShardsUpdateHandler == nil {
		unregistered = append(unregistered, "schema.SchemaObjectsShardsUpdateHandler")
	}
	if o.SchemaSchemaObjectsUpdateHandler == nil {
		unregistered = append(unregistered, "schema.SchemaObjectsUpdateHandler")
	}
	if o.SchemaTenantExistsHandler == nil {
		unregistered = append(unregistered, "schema.TenantExistsHandler")
	}
	if o.SchemaTenantsCreateHandler == nil {
		unregistered = append(unregistered, "schema.TenantsCreateHandler")
	}
	if o.SchemaTenantsDeleteHandler == nil {
		unregistered = append(unregistered, "schema.TenantsDeleteHandler")
	}
	if o.SchemaTenantsGetHandler == nil {
		unregistered = append(unregistered, "schema.TenantsGetHandler")
	}
	if o.SchemaTenantsGetOneHandler == nil {
		unregistered = append(unregistered, "schema.TenantsGetOneHandler")
	}
	if o.SchemaTenantsUpdateHandler == nil {
		unregistered = append(unregistered, "schema.TenantsUpdateHandler")
	}
	if o.WeaviateRootHandler == nil {
		unregistered = append(unregistered, "WeaviateRootHandler")
	}
	if o.WeaviateWellknownLivenessHandler == nil {
		unregistered = append(unregistered, "WeaviateWellknownLivenessHandler")
	}
	if o.WeaviateWellknownReadinessHandler == nil {
		unregistered = append(unregistered, "WeaviateWellknownReadinessHandler")
	}

	if len(unregistered) > 0 {
		return fmt.Errorf("missing registration: %s", strings.Join(unregistered, ", "))
	}

	return nil
}

// ServeErrorFor gets a error handler for a given operation id
func (o *WeaviateAPI) ServeErrorFor(operationID string) func(http.ResponseWriter, *http.Request, error) {
	return o.ServeError
}

// AuthenticatorsFor gets the authenticators for the specified security schemes
func (o *WeaviateAPI) AuthenticatorsFor(schemes map[string]spec.SecurityScheme) map[string]runtime.Authenticator {
	result := make(map[string]runtime.Authenticator)
	for name := range schemes {
		switch name {
		case "oidc":
			result[name] = o.BearerAuthenticator(name, func(token string, scopes []string) (interface{}, error) {
				return o.OidcAuth(token, scopes)
			})

		}
	}
	return result
}

// Authorizer returns the registered authorizer
func (o *WeaviateAPI) Authorizer() runtime.Authorizer {
	return o.APIAuthorizer
}

// ConsumersFor gets the consumers for the specified media types.
// MIME type parameters are ignored here.
func (o *WeaviateAPI) ConsumersFor(mediaTypes []string) map[string]runtime.Consumer {
	result := make(map[string]runtime.Consumer, len(mediaTypes))
	for _, mt := range mediaTypes {
		switch mt {
		case "application/json":
			result["application/json"] = o.JSONConsumer
		case "application/yaml":
			result["application/yaml"] = o.YamlConsumer
		}

		if c, ok := o.customConsumers[mt]; ok {
			result[mt] = c
		}
	}
	return result
}

// ProducersFor gets the producers for the specified media types.
// MIME type parameters are ignored here.
func (o *WeaviateAPI) ProducersFor(mediaTypes []string) map[string]runtime.Producer {
	result := make(map[string]runtime.Producer, len(mediaTypes))
	for _, mt := range mediaTypes {
		switch mt {
		case "application/json":
			result["application/json"] = o.JSONProducer
		}

		if p, ok := o.customProducers[mt]; ok {
			result[mt] = p
		}
	}
	return result
}

// HandlerFor gets a http.Handler for the provided operation method and path
func (o *WeaviateAPI) HandlerFor(method, path string) (http.Handler, bool) {
	if o.handlers == nil {
		return nil, false
	}
	um := strings.ToUpper(method)
	if _, ok := o.handlers[um]; !ok {
		return nil, false
	}
	if path == "/" {
		path = ""
	}
	h, ok := o.handlers[um][path]
	return h, ok
}

// Context returns the middleware context for the weaviate API
func (o *WeaviateAPI) Context() *middleware.Context {
	if o.context == nil {
		o.context = middleware.NewRoutableContext(o.spec, o, nil)
	}

	return o.context
}

func (o *WeaviateAPI) initHandlerCache() {
	o.Context() // don't care about the result, just that the initialization happened
	if o.handlers == nil {
		o.handlers = make(map[string]map[string]http.Handler)
	}

	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/.well-known/openid-configuration"] = well_known.NewGetWellKnownOpenidConfiguration(o.context, o.WellKnownGetWellKnownOpenidConfigurationHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/users/db/{user_id}/activate"] = users.NewActivateUser(o.context, o.UsersActivateUserHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/authz/roles/{id}/add-permissions"] = authz.NewAddPermissions(o.context, o.AuthzAddPermissionsHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/aliases"] = schema.NewAliasesCreate(o.context, o.SchemaAliasesCreateHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/aliases/{aliasName}"] = schema.NewAliasesDelete(o.context, o.SchemaAliasesDeleteHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/aliases"] = schema.NewAliasesGet(o.context, o.SchemaAliasesGetHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/aliases/{aliasName}"] = schema.NewAliasesGetAlias(o.context, o.SchemaAliasesGetAliasHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/aliases/{aliasName}"] = schema.NewAliasesUpdate(o.context, o.SchemaAliasesUpdateHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/replication/scale"] = replication.NewApplyReplicationScalePlan(o.context, o.ReplicationApplyReplicationScalePlanHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/authz/groups/{id}/assign"] = authz.NewAssignRoleToGroup(o.context, o.AuthzAssignRoleToGroupHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/authz/users/{id}/assign"] = authz.NewAssignRoleToUser(o.context, o.AuthzAssignRoleToUserHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/backups/{backend}/{id}"] = backups.NewBackupsCancel(o.context, o.BackupsBackupsCancelHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/backups/{backend}"] = backups.NewBackupsCreate(o.context, o.BackupsBackupsCreateHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/backups/{backend}/{id}"] = backups.NewBackupsCreateStatus(o.context, o.BackupsBackupsCreateStatusHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/backups/{backend}"] = backups.NewBackupsList(o.context, o.BackupsBackupsListHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/backups/{backend}/{id}/restore"] = backups.NewBackupsRestore(o.context, o.BackupsBackupsRestoreHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/backups/{backend}/{id}/restore"] = backups.NewBackupsRestoreStatus(o.context, o.BackupsBackupsRestoreStatusHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/batch/objects"] = batch.NewBatchObjectsCreate(o.context, o.BatchBatchObjectsCreateHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/batch/objects"] = batch.NewBatchObjectsDelete(o.context, o.BatchBatchObjectsDeleteHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/batch/references"] = batch.NewBatchReferencesCreate(o.context, o.BatchBatchReferencesCreateHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/replication/replicate/{id}/cancel"] = replication.NewCancelReplication(o.context, o.ReplicationCancelReplicationHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/classifications/{id}"] = classifications.NewClassificationsGet(o.context, o.ClassificationsClassificationsGetHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/classifications"] = classifications.NewClassificationsPost(o.context, o.ClassificationsClassificationsPostHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/cluster/statistics"] = cluster.NewClusterGetStatistics(o.context, o.ClusterClusterGetStatisticsHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/authz/roles"] = authz.NewCreateRole(o.context, o.AuthzCreateRoleHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/users/db/{user_id}"] = users.NewCreateUser(o.context, o.UsersCreateUserHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/users/db/{user_id}/deactivate"] = users.NewDeactivateUser(o.context, o.UsersDeactivateUserHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/replication/replicate"] = replication.NewDeleteAllReplications(o.context, o.ReplicationDeleteAllReplicationsHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/replication/replicate/{id}"] = replication.NewDeleteReplication(o.context, o.ReplicationDeleteReplicationHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/authz/roles/{id}"] = authz.NewDeleteRole(o.context, o.AuthzDeleteRoleHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/users/db/{user_id}"] = users.NewDeleteUser(o.context, o.UsersDeleteUserHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/tasks"] = distributed_tasks.NewDistributedTasksGet(o.context, o.DistributedTasksDistributedTasksGetHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/replication/replicate/force-delete"] = replication.NewForceDeleteReplications(o.context, o.ReplicationForceDeleteReplicationsHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/replication/sharding-state"] = replication.NewGetCollectionShardingState(o.context, o.ReplicationGetCollectionShardingStateHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/authz/groups/{groupType}"] = authz.NewGetGroups(o.context, o.AuthzGetGroupsHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/authz/roles/{id}/group-assignments"] = authz.NewGetGroupsForRole(o.context, o.AuthzGetGroupsForRoleHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/users/own-info"] = users.NewGetOwnInfo(o.context, o.UsersGetOwnInfoHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/replication/scale"] = replication.NewGetReplicationScalePlan(o.context, o.ReplicationGetReplicationScalePlanHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/authz/roles/{id}"] = authz.NewGetRole(o.context, o.AuthzGetRoleHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/authz/roles"] = authz.NewGetRoles(o.context, o.AuthzGetRolesHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/authz/groups/{id}/roles/{groupType}"] = authz.NewGetRolesForGroup(o.context, o.AuthzGetRolesForGroupHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/authz/users/{id}/roles/{userType}"] = authz.NewGetRolesForUser(o.context, o.AuthzGetRolesForUserHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/authz/users/{id}/roles"] = authz.NewGetRolesForUserDeprecated(o.context, o.AuthzGetRolesForUserDeprecatedHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/users/db/{user_id}"] = users.NewGetUserInfo(o.context, o.UsersGetUserInfoHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/authz/roles/{id}/user-assignments"] = authz.NewGetUsersForRole(o.context, o.AuthzGetUsersForRoleHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/authz/roles/{id}/users"] = authz.NewGetUsersForRoleDeprecated(o.context, o.AuthzGetUsersForRoleDeprecatedHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/graphql/batch"] = graphql.NewGraphqlBatch(o.context, o.GraphqlGraphqlBatchHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/graphql"] = graphql.NewGraphqlPost(o.context, o.GraphqlGraphqlPostHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/authz/roles/{id}/has-permission"] = authz.NewHasPermission(o.context, o.AuthzHasPermissionHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/users/db"] = users.NewListAllUsers(o.context, o.UsersListAllUsersHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/replication/replicate/list"] = replication.NewListReplication(o.context, o.ReplicationListReplicationHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/meta"] = meta.NewMetaGet(o.context, o.MetaMetaGetHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/nodes"] = nodes.NewNodesGet(o.context, o.NodesNodesGetHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/nodes/{className}"] = nodes.NewNodesGetClass(o.context, o.NodesNodesGetClassHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/objects/{className}/{id}"] = objects.NewObjectsClassDelete(o.context, o.ObjectsObjectsClassDeleteHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/objects/{className}/{id}"] = objects.NewObjectsClassGet(o.context, o.ObjectsObjectsClassGetHandler)
	if o.handlers["HEAD"] == nil {
		o.handlers["HEAD"] = make(map[string]http.Handler)
	}
	o.handlers["HEAD"]["/objects/{className}/{id}"] = objects.NewObjectsClassHead(o.context, o.ObjectsObjectsClassHeadHandler)
	if o.handlers["PATCH"] == nil {
		o.handlers["PATCH"] = make(map[string]http.Handler)
	}
	o.handlers["PATCH"]["/objects/{className}/{id}"] = objects.NewObjectsClassPatch(o.context, o.ObjectsObjectsClassPatchHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/objects/{className}/{id}"] = objects.NewObjectsClassPut(o.context, o.ObjectsObjectsClassPutHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/objects/{className}/{id}/references/{propertyName}"] = objects.NewObjectsClassReferencesCreate(o.context, o.ObjectsObjectsClassReferencesCreateHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/objects/{className}/{id}/references/{propertyName}"] = objects.NewObjectsClassReferencesDelete(o.context, o.ObjectsObjectsClassReferencesDeleteHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/objects/{className}/{id}/references/{propertyName}"] = objects.NewObjectsClassReferencesPut(o.context, o.ObjectsObjectsClassReferencesPutHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/objects"] = objects.NewObjectsCreate(o.context, o.ObjectsObjectsCreateHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/objects/{id}"] = objects.NewObjectsDelete(o.context, o.ObjectsObjectsDeleteHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/objects/{id}"] = objects.NewObjectsGet(o.context, o.ObjectsObjectsGetHandler)
	if o.handlers["HEAD"] == nil {
		o.handlers["HEAD"] = make(map[string]http.Handler)
	}
	o.handlers["HEAD"]["/objects/{id}"] = objects.NewObjectsHead(o.context, o.ObjectsObjectsHeadHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/objects"] = objects.NewObjectsList(o.context, o.ObjectsObjectsListHandler)
	if o.handlers["PATCH"] == nil {
		o.handlers["PATCH"] = make(map[string]http.Handler)
	}
	o.handlers["PATCH"]["/objects/{id}"] = objects.NewObjectsPatch(o.context, o.ObjectsObjectsPatchHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/objects/{id}/references/{propertyName}"] = objects.NewObjectsReferencesCreate(o.context, o.ObjectsObjectsReferencesCreateHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/objects/{id}/references/{propertyName}"] = objects.NewObjectsReferencesDelete(o.context, o.ObjectsObjectsReferencesDeleteHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/objects/{id}/references/{propertyName}"] = objects.NewObjectsReferencesUpdate(o.context, o.ObjectsObjectsReferencesUpdateHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/objects/{id}"] = objects.NewObjectsUpdate(o.context, o.ObjectsObjectsUpdateHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/objects/validate"] = objects.NewObjectsValidate(o.context, o.ObjectsObjectsValidateHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/authz/roles/{id}/remove-permissions"] = authz.NewRemovePermissions(o.context, o.AuthzRemovePermissionsHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/replication/replicate"] = replication.NewReplicate(o.context, o.ReplicationReplicateHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/replication/replicate/{id}"] = replication.NewReplicationDetails(o.context, o.ReplicationReplicationDetailsHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/authz/groups/{id}/revoke"] = authz.NewRevokeRoleFromGroup(o.context, o.AuthzRevokeRoleFromGroupHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/authz/users/{id}/revoke"] = authz.NewRevokeRoleFromUser(o.context, o.AuthzRevokeRoleFromUserHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/users/db/{user_id}/rotate-key"] = users.NewRotateUserAPIKey(o.context, o.UsersRotateUserAPIKeyHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/schema"] = schema.NewSchemaDump(o.context, o.SchemaSchemaDumpHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/schema"] = schema.NewSchemaObjectsCreate(o.context, o.SchemaSchemaObjectsCreateHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/schema/{className}"] = schema.NewSchemaObjectsDelete(o.context, o.SchemaSchemaObjectsDeleteHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/schema/{className}"] = schema.NewSchemaObjectsGet(o.context, o.SchemaSchemaObjectsGetHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/schema/{className}/properties"] = schema.NewSchemaObjectsPropertiesAdd(o.context, o.SchemaSchemaObjectsPropertiesAddHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/schema/{className}/shards"] = schema.NewSchemaObjectsShardsGet(o.context, o.SchemaSchemaObjectsShardsGetHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/schema/{className}/shards/{shardName}"] = schema.NewSchemaObjectsShardsUpdate(o.context, o.SchemaSchemaObjectsShardsUpdateHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/schema/{className}"] = schema.NewSchemaObjectsUpdate(o.context, o.SchemaSchemaObjectsUpdateHandler)
	if o.handlers["HEAD"] == nil {
		o.handlers["HEAD"] = make(map[string]http.Handler)
	}
	o.handlers["HEAD"]["/schema/{className}/tenants/{tenantName}"] = schema.NewTenantExists(o.context, o.SchemaTenantExistsHandler)
	if o.handlers["POST"] == nil {
		o.handlers["POST"] = make(map[string]http.Handler)
	}
	o.handlers["POST"]["/schema/{className}/tenants"] = schema.NewTenantsCreate(o.context, o.SchemaTenantsCreateHandler)
	if o.handlers["DELETE"] == nil {
		o.handlers["DELETE"] = make(map[string]http.Handler)
	}
	o.handlers["DELETE"]["/schema/{className}/tenants"] = schema.NewTenantsDelete(o.context, o.SchemaTenantsDeleteHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/schema/{className}/tenants"] = schema.NewTenantsGet(o.context, o.SchemaTenantsGetHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/schema/{className}/tenants/{tenantName}"] = schema.NewTenantsGetOne(o.context, o.SchemaTenantsGetOneHandler)
	if o.handlers["PUT"] == nil {
		o.handlers["PUT"] = make(map[string]http.Handler)
	}
	o.handlers["PUT"]["/schema/{className}/tenants"] = schema.NewTenantsUpdate(o.context, o.SchemaTenantsUpdateHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"][""] = NewWeaviateRoot(o.context, o.WeaviateRootHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/.well-known/live"] = NewWeaviateWellknownLiveness(o.context, o.WeaviateWellknownLivenessHandler)
	if o.handlers["GET"] == nil {
		o.handlers["GET"] = make(map[string]http.Handler)
	}
	o.handlers["GET"]["/.well-known/ready"] = NewWeaviateWellknownReadiness(o.context, o.WeaviateWellknownReadinessHandler)
}

// Serve creates a http handler to serve the API over HTTP
// can be used directly in http.ListenAndServe(":8000", api.Serve(nil))
func (o *WeaviateAPI) Serve(builder middleware.Builder) http.Handler {
	o.Init()

	if o.Middleware != nil {
		return o.Middleware(builder)
	}
	if o.useSwaggerUI {
		return o.context.APIHandlerSwaggerUI(builder)
	}
	return o.context.APIHandler(builder)
}

// Init allows you to just initialize the handler cache, you can then recompose the middleware as you see fit
func (o *WeaviateAPI) Init() {
	if len(o.handlers) == 0 {
		o.initHandlerCache()
	}
}

// RegisterConsumer allows you to add (or override) a consumer for a media type.
func (o *WeaviateAPI) RegisterConsumer(mediaType string, consumer runtime.Consumer) {
	o.customConsumers[mediaType] = consumer
}

// RegisterProducer allows you to add (or override) a producer for a media type.
func (o *WeaviateAPI) RegisterProducer(mediaType string, producer runtime.Producer) {
	o.customProducers[mediaType] = producer
}

// AddMiddlewareFor adds a http middleware to existing handler
func (o *WeaviateAPI) AddMiddlewareFor(method, path string, builder middleware.Builder) {
	um := strings.ToUpper(method)
	if path == "/" {
		path = ""
	}
	o.Init()
	if h, ok := o.handlers[um][path]; ok {
		o.handlers[method][path] = builder(h)
	}
}
