//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package authz

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewAssignRoleToGroupParams creates a new AssignRoleToGroupParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewAssignRoleToGroupParams() *AssignRoleToGroupParams {
	return &AssignRoleToGroupParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewAssignRoleToGroupParamsWithTimeout creates a new AssignRoleToGroupParams object
// with the ability to set a timeout on a request.
func NewAssignRoleToGroupParamsWithTimeout(timeout time.Duration) *AssignRoleToGroupParams {
	return &AssignRoleToGroupParams{
		timeout: timeout,
	}
}

// NewAssignRoleToGroupParamsWithContext creates a new AssignRoleToGroupParams object
// with the ability to set a context for a request.
func NewAssignRoleToGroupParamsWithContext(ctx context.Context) *AssignRoleToGroupParams {
	return &AssignRoleToGroupParams{
		Context: ctx,
	}
}

// NewAssignRoleToGroupParamsWithHTTPClient creates a new AssignRoleToGroupParams object
// with the ability to set a custom HTTPClient for a request.
func NewAssignRoleToGroupParamsWithHTTPClient(client *http.Client) *AssignRoleToGroupParams {
	return &AssignRoleToGroupParams{
		HTTPClient: client,
	}
}

/*
AssignRoleToGroupParams contains all the parameters to send to the API endpoint

	for the assign role to group operation.

	Typically these are written to a http.Request.
*/
type AssignRoleToGroupParams struct {

	// Body.
	Body AssignRoleToGroupBody

	/* ID.

	   The name of the group.
	*/
	ID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the assign role to group params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AssignRoleToGroupParams) WithDefaults() *AssignRoleToGroupParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the assign role to group params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AssignRoleToGroupParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the assign role to group params
func (o *AssignRoleToGroupParams) WithTimeout(timeout time.Duration) *AssignRoleToGroupParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the assign role to group params
func (o *AssignRoleToGroupParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the assign role to group params
func (o *AssignRoleToGroupParams) WithContext(ctx context.Context) *AssignRoleToGroupParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the assign role to group params
func (o *AssignRoleToGroupParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the assign role to group params
func (o *AssignRoleToGroupParams) WithHTTPClient(client *http.Client) *AssignRoleToGroupParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the assign role to group params
func (o *AssignRoleToGroupParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the assign role to group params
func (o *AssignRoleToGroupParams) WithBody(body AssignRoleToGroupBody) *AssignRoleToGroupParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the assign role to group params
func (o *AssignRoleToGroupParams) SetBody(body AssignRoleToGroupBody) {
	o.Body = body
}

// WithID adds the id to the assign role to group params
func (o *AssignRoleToGroupParams) WithID(id string) *AssignRoleToGroupParams {
	o.SetID(id)
	return o
}

// SetID adds the id to the assign role to group params
func (o *AssignRoleToGroupParams) SetID(id string) {
	o.ID = id
}

// WriteToRequest writes these params to a swagger request
func (o *AssignRoleToGroupParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if err := r.SetBodyParam(o.Body); err != nil {
		return err
	}

	// path param id
	if err := r.SetPathParam("id", o.ID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
