//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package authz

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/weaviate/weaviate/entities/models"
)

// AssignRoleToGroupReader is a Reader for the AssignRoleToGroup structure.
type AssignRoleToGroupReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *AssignRoleToGroupReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewAssignRoleToGroupOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewAssignRoleToGroupBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewAssignRoleToGroupUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewAssignRoleToGroupForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewAssignRoleToGroupNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewAssignRoleToGroupInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewAssignRoleToGroupOK creates a AssignRoleToGroupOK with default headers values
func NewAssignRoleToGroupOK() *AssignRoleToGroupOK {
	return &AssignRoleToGroupOK{}
}

/*
AssignRoleToGroupOK describes a response with status code 200, with default header values.

Roles assigned successfully.
*/
type AssignRoleToGroupOK struct {
}

// IsSuccess returns true when this assign role to group o k response has a 2xx status code
func (o *AssignRoleToGroupOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this assign role to group o k response has a 3xx status code
func (o *AssignRoleToGroupOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this assign role to group o k response has a 4xx status code
func (o *AssignRoleToGroupOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this assign role to group o k response has a 5xx status code
func (o *AssignRoleToGroupOK) IsServerError() bool {
	return false
}

// IsCode returns true when this assign role to group o k response a status code equal to that given
func (o *AssignRoleToGroupOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the assign role to group o k response
func (o *AssignRoleToGroupOK) Code() int {
	return 200
}

func (o *AssignRoleToGroupOK) Error() string {
	return fmt.Sprintf("[POST /authz/groups/{id}/assign][%d] assignRoleToGroupOK ", 200)
}

func (o *AssignRoleToGroupOK) String() string {
	return fmt.Sprintf("[POST /authz/groups/{id}/assign][%d] assignRoleToGroupOK ", 200)
}

func (o *AssignRoleToGroupOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewAssignRoleToGroupBadRequest creates a AssignRoleToGroupBadRequest with default headers values
func NewAssignRoleToGroupBadRequest() *AssignRoleToGroupBadRequest {
	return &AssignRoleToGroupBadRequest{}
}

/*
AssignRoleToGroupBadRequest describes a response with status code 400, with default header values.

Malformed request.
*/
type AssignRoleToGroupBadRequest struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this assign role to group bad request response has a 2xx status code
func (o *AssignRoleToGroupBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this assign role to group bad request response has a 3xx status code
func (o *AssignRoleToGroupBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this assign role to group bad request response has a 4xx status code
func (o *AssignRoleToGroupBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this assign role to group bad request response has a 5xx status code
func (o *AssignRoleToGroupBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this assign role to group bad request response a status code equal to that given
func (o *AssignRoleToGroupBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the assign role to group bad request response
func (o *AssignRoleToGroupBadRequest) Code() int {
	return 400
}

func (o *AssignRoleToGroupBadRequest) Error() string {
	return fmt.Sprintf("[POST /authz/groups/{id}/assign][%d] assignRoleToGroupBadRequest  %+v", 400, o.Payload)
}

func (o *AssignRoleToGroupBadRequest) String() string {
	return fmt.Sprintf("[POST /authz/groups/{id}/assign][%d] assignRoleToGroupBadRequest  %+v", 400, o.Payload)
}

func (o *AssignRoleToGroupBadRequest) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *AssignRoleToGroupBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAssignRoleToGroupUnauthorized creates a AssignRoleToGroupUnauthorized with default headers values
func NewAssignRoleToGroupUnauthorized() *AssignRoleToGroupUnauthorized {
	return &AssignRoleToGroupUnauthorized{}
}

/*
AssignRoleToGroupUnauthorized describes a response with status code 401, with default header values.

Unauthorized or invalid credentials.
*/
type AssignRoleToGroupUnauthorized struct {
}

// IsSuccess returns true when this assign role to group unauthorized response has a 2xx status code
func (o *AssignRoleToGroupUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this assign role to group unauthorized response has a 3xx status code
func (o *AssignRoleToGroupUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this assign role to group unauthorized response has a 4xx status code
func (o *AssignRoleToGroupUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this assign role to group unauthorized response has a 5xx status code
func (o *AssignRoleToGroupUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this assign role to group unauthorized response a status code equal to that given
func (o *AssignRoleToGroupUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the assign role to group unauthorized response
func (o *AssignRoleToGroupUnauthorized) Code() int {
	return 401
}

func (o *AssignRoleToGroupUnauthorized) Error() string {
	return fmt.Sprintf("[POST /authz/groups/{id}/assign][%d] assignRoleToGroupUnauthorized ", 401)
}

func (o *AssignRoleToGroupUnauthorized) String() string {
	return fmt.Sprintf("[POST /authz/groups/{id}/assign][%d] assignRoleToGroupUnauthorized ", 401)
}

func (o *AssignRoleToGroupUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewAssignRoleToGroupForbidden creates a AssignRoleToGroupForbidden with default headers values
func NewAssignRoleToGroupForbidden() *AssignRoleToGroupForbidden {
	return &AssignRoleToGroupForbidden{}
}

/*
AssignRoleToGroupForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type AssignRoleToGroupForbidden struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this assign role to group forbidden response has a 2xx status code
func (o *AssignRoleToGroupForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this assign role to group forbidden response has a 3xx status code
func (o *AssignRoleToGroupForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this assign role to group forbidden response has a 4xx status code
func (o *AssignRoleToGroupForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this assign role to group forbidden response has a 5xx status code
func (o *AssignRoleToGroupForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this assign role to group forbidden response a status code equal to that given
func (o *AssignRoleToGroupForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the assign role to group forbidden response
func (o *AssignRoleToGroupForbidden) Code() int {
	return 403
}

func (o *AssignRoleToGroupForbidden) Error() string {
	return fmt.Sprintf("[POST /authz/groups/{id}/assign][%d] assignRoleToGroupForbidden  %+v", 403, o.Payload)
}

func (o *AssignRoleToGroupForbidden) String() string {
	return fmt.Sprintf("[POST /authz/groups/{id}/assign][%d] assignRoleToGroupForbidden  %+v", 403, o.Payload)
}

func (o *AssignRoleToGroupForbidden) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *AssignRoleToGroupForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAssignRoleToGroupNotFound creates a AssignRoleToGroupNotFound with default headers values
func NewAssignRoleToGroupNotFound() *AssignRoleToGroupNotFound {
	return &AssignRoleToGroupNotFound{}
}

/*
AssignRoleToGroupNotFound describes a response with status code 404, with default header values.

Role or group not found.
*/
type AssignRoleToGroupNotFound struct {
}

// IsSuccess returns true when this assign role to group not found response has a 2xx status code
func (o *AssignRoleToGroupNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this assign role to group not found response has a 3xx status code
func (o *AssignRoleToGroupNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this assign role to group not found response has a 4xx status code
func (o *AssignRoleToGroupNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this assign role to group not found response has a 5xx status code
func (o *AssignRoleToGroupNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this assign role to group not found response a status code equal to that given
func (o *AssignRoleToGroupNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the assign role to group not found response
func (o *AssignRoleToGroupNotFound) Code() int {
	return 404
}

func (o *AssignRoleToGroupNotFound) Error() string {
	return fmt.Sprintf("[POST /authz/groups/{id}/assign][%d] assignRoleToGroupNotFound ", 404)
}

func (o *AssignRoleToGroupNotFound) String() string {
	return fmt.Sprintf("[POST /authz/groups/{id}/assign][%d] assignRoleToGroupNotFound ", 404)
}

func (o *AssignRoleToGroupNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewAssignRoleToGroupInternalServerError creates a AssignRoleToGroupInternalServerError with default headers values
func NewAssignRoleToGroupInternalServerError() *AssignRoleToGroupInternalServerError {
	return &AssignRoleToGroupInternalServerError{}
}

/*
AssignRoleToGroupInternalServerError describes a response with status code 500, with default header values.

An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.
*/
type AssignRoleToGroupInternalServerError struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this assign role to group internal server error response has a 2xx status code
func (o *AssignRoleToGroupInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this assign role to group internal server error response has a 3xx status code
func (o *AssignRoleToGroupInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this assign role to group internal server error response has a 4xx status code
func (o *AssignRoleToGroupInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this assign role to group internal server error response has a 5xx status code
func (o *AssignRoleToGroupInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this assign role to group internal server error response a status code equal to that given
func (o *AssignRoleToGroupInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the assign role to group internal server error response
func (o *AssignRoleToGroupInternalServerError) Code() int {
	return 500
}

func (o *AssignRoleToGroupInternalServerError) Error() string {
	return fmt.Sprintf("[POST /authz/groups/{id}/assign][%d] assignRoleToGroupInternalServerError  %+v", 500, o.Payload)
}

func (o *AssignRoleToGroupInternalServerError) String() string {
	return fmt.Sprintf("[POST /authz/groups/{id}/assign][%d] assignRoleToGroupInternalServerError  %+v", 500, o.Payload)
}

func (o *AssignRoleToGroupInternalServerError) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *AssignRoleToGroupInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
AssignRoleToGroupBody assign role to group body
swagger:model AssignRoleToGroupBody
*/
type AssignRoleToGroupBody struct {

	// group type
	GroupType models.GroupType `json:"groupType,omitempty"`

	// The roles to assign to the specified group.
	Roles []string `json:"roles"`
}

// Validate validates this assign role to group body
func (o *AssignRoleToGroupBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateGroupType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AssignRoleToGroupBody) validateGroupType(formats strfmt.Registry) error {
	if swag.IsZero(o.GroupType) { // not required
		return nil
	}

	if err := o.GroupType.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("body" + "." + "groupType")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("body" + "." + "groupType")
		}
		return err
	}

	return nil
}

// ContextValidate validate this assign role to group body based on the context it is used
func (o *AssignRoleToGroupBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateGroupType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AssignRoleToGroupBody) contextValidateGroupType(ctx context.Context, formats strfmt.Registry) error {

	if err := o.GroupType.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("body" + "." + "groupType")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("body" + "." + "groupType")
		}
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *AssignRoleToGroupBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *AssignRoleToGroupBody) UnmarshalBinary(b []byte) error {
	var res AssignRoleToGroupBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
