//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package authz

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewAssignRoleToUserParams creates a new AssignRoleToUserParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewAssignRoleToUserParams() *AssignRoleToUserParams {
	return &AssignRoleToUserParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewAssignRoleToUserParamsWithTimeout creates a new AssignRoleToUserParams object
// with the ability to set a timeout on a request.
func NewAssignRoleToUserParamsWithTimeout(timeout time.Duration) *AssignRoleToUserParams {
	return &AssignRoleToUserParams{
		timeout: timeout,
	}
}

// NewAssignRoleToUserParamsWithContext creates a new AssignRoleToUserParams object
// with the ability to set a context for a request.
func NewAssignRoleToUserParamsWithContext(ctx context.Context) *AssignRoleToUserParams {
	return &AssignRoleToUserParams{
		Context: ctx,
	}
}

// NewAssignRoleToUserParamsWithHTTPClient creates a new AssignRoleToUserParams object
// with the ability to set a custom HTTPClient for a request.
func NewAssignRoleToUserParamsWithHTTPClient(client *http.Client) *AssignRoleToUserParams {
	return &AssignRoleToUserParams{
		HTTPClient: client,
	}
}

/*
AssignRoleToUserParams contains all the parameters to send to the API endpoint

	for the assign role to user operation.

	Typically these are written to a http.Request.
*/
type AssignRoleToUserParams struct {

	// Body.
	Body AssignRoleToUserBody

	/* ID.

	   The name of the user.
	*/
	ID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the assign role to user params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AssignRoleToUserParams) WithDefaults() *AssignRoleToUserParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the assign role to user params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AssignRoleToUserParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the assign role to user params
func (o *AssignRoleToUserParams) WithTimeout(timeout time.Duration) *AssignRoleToUserParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the assign role to user params
func (o *AssignRoleToUserParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the assign role to user params
func (o *AssignRoleToUserParams) WithContext(ctx context.Context) *AssignRoleToUserParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the assign role to user params
func (o *AssignRoleToUserParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the assign role to user params
func (o *AssignRoleToUserParams) WithHTTPClient(client *http.Client) *AssignRoleToUserParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the assign role to user params
func (o *AssignRoleToUserParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the assign role to user params
func (o *AssignRoleToUserParams) WithBody(body AssignRoleToUserBody) *AssignRoleToUserParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the assign role to user params
func (o *AssignRoleToUserParams) SetBody(body AssignRoleToUserBody) {
	o.Body = body
}

// WithID adds the id to the assign role to user params
func (o *AssignRoleToUserParams) WithID(id string) *AssignRoleToUserParams {
	o.SetID(id)
	return o
}

// SetID adds the id to the assign role to user params
func (o *AssignRoleToUserParams) SetID(id string) {
	o.ID = id
}

// WriteToRequest writes these params to a swagger request
func (o *AssignRoleToUserParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if err := r.SetBodyParam(o.Body); err != nil {
		return err
	}

	// path param id
	if err := r.SetPathParam("id", o.ID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
