//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package authz

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/weaviate/weaviate/entities/models"
)

// GetGroupsForRoleReader is a Reader for the GetGroupsForRole structure.
type GetGroupsForRoleReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetGroupsForRoleReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetGroupsForRoleOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewGetGroupsForRoleBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewGetGroupsForRoleUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetGroupsForRoleForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewGetGroupsForRoleNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetGroupsForRoleInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewGetGroupsForRoleOK creates a GetGroupsForRoleOK with default headers values
func NewGetGroupsForRoleOK() *GetGroupsForRoleOK {
	return &GetGroupsForRoleOK{}
}

/*
GetGroupsForRoleOK describes a response with status code 200, with default header values.

Successfully retrieved the list of groups that have the role assigned.
*/
type GetGroupsForRoleOK struct {
	Payload []*GetGroupsForRoleOKBodyItems0
}

// IsSuccess returns true when this get groups for role o k response has a 2xx status code
func (o *GetGroupsForRoleOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get groups for role o k response has a 3xx status code
func (o *GetGroupsForRoleOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get groups for role o k response has a 4xx status code
func (o *GetGroupsForRoleOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get groups for role o k response has a 5xx status code
func (o *GetGroupsForRoleOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get groups for role o k response a status code equal to that given
func (o *GetGroupsForRoleOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get groups for role o k response
func (o *GetGroupsForRoleOK) Code() int {
	return 200
}

func (o *GetGroupsForRoleOK) Error() string {
	return fmt.Sprintf("[GET /authz/roles/{id}/group-assignments][%d] getGroupsForRoleOK  %+v", 200, o.Payload)
}

func (o *GetGroupsForRoleOK) String() string {
	return fmt.Sprintf("[GET /authz/roles/{id}/group-assignments][%d] getGroupsForRoleOK  %+v", 200, o.Payload)
}

func (o *GetGroupsForRoleOK) GetPayload() []*GetGroupsForRoleOKBodyItems0 {
	return o.Payload
}

func (o *GetGroupsForRoleOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetGroupsForRoleBadRequest creates a GetGroupsForRoleBadRequest with default headers values
func NewGetGroupsForRoleBadRequest() *GetGroupsForRoleBadRequest {
	return &GetGroupsForRoleBadRequest{}
}

/*
GetGroupsForRoleBadRequest describes a response with status code 400, with default header values.

Bad request
*/
type GetGroupsForRoleBadRequest struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this get groups for role bad request response has a 2xx status code
func (o *GetGroupsForRoleBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get groups for role bad request response has a 3xx status code
func (o *GetGroupsForRoleBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get groups for role bad request response has a 4xx status code
func (o *GetGroupsForRoleBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this get groups for role bad request response has a 5xx status code
func (o *GetGroupsForRoleBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this get groups for role bad request response a status code equal to that given
func (o *GetGroupsForRoleBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the get groups for role bad request response
func (o *GetGroupsForRoleBadRequest) Code() int {
	return 400
}

func (o *GetGroupsForRoleBadRequest) Error() string {
	return fmt.Sprintf("[GET /authz/roles/{id}/group-assignments][%d] getGroupsForRoleBadRequest  %+v", 400, o.Payload)
}

func (o *GetGroupsForRoleBadRequest) String() string {
	return fmt.Sprintf("[GET /authz/roles/{id}/group-assignments][%d] getGroupsForRoleBadRequest  %+v", 400, o.Payload)
}

func (o *GetGroupsForRoleBadRequest) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *GetGroupsForRoleBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetGroupsForRoleUnauthorized creates a GetGroupsForRoleUnauthorized with default headers values
func NewGetGroupsForRoleUnauthorized() *GetGroupsForRoleUnauthorized {
	return &GetGroupsForRoleUnauthorized{}
}

/*
GetGroupsForRoleUnauthorized describes a response with status code 401, with default header values.

Unauthorized or invalid credentials.
*/
type GetGroupsForRoleUnauthorized struct {
}

// IsSuccess returns true when this get groups for role unauthorized response has a 2xx status code
func (o *GetGroupsForRoleUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get groups for role unauthorized response has a 3xx status code
func (o *GetGroupsForRoleUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get groups for role unauthorized response has a 4xx status code
func (o *GetGroupsForRoleUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this get groups for role unauthorized response has a 5xx status code
func (o *GetGroupsForRoleUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this get groups for role unauthorized response a status code equal to that given
func (o *GetGroupsForRoleUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the get groups for role unauthorized response
func (o *GetGroupsForRoleUnauthorized) Code() int {
	return 401
}

func (o *GetGroupsForRoleUnauthorized) Error() string {
	return fmt.Sprintf("[GET /authz/roles/{id}/group-assignments][%d] getGroupsForRoleUnauthorized ", 401)
}

func (o *GetGroupsForRoleUnauthorized) String() string {
	return fmt.Sprintf("[GET /authz/roles/{id}/group-assignments][%d] getGroupsForRoleUnauthorized ", 401)
}

func (o *GetGroupsForRoleUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewGetGroupsForRoleForbidden creates a GetGroupsForRoleForbidden with default headers values
func NewGetGroupsForRoleForbidden() *GetGroupsForRoleForbidden {
	return &GetGroupsForRoleForbidden{}
}

/*
GetGroupsForRoleForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type GetGroupsForRoleForbidden struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this get groups for role forbidden response has a 2xx status code
func (o *GetGroupsForRoleForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get groups for role forbidden response has a 3xx status code
func (o *GetGroupsForRoleForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get groups for role forbidden response has a 4xx status code
func (o *GetGroupsForRoleForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get groups for role forbidden response has a 5xx status code
func (o *GetGroupsForRoleForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get groups for role forbidden response a status code equal to that given
func (o *GetGroupsForRoleForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get groups for role forbidden response
func (o *GetGroupsForRoleForbidden) Code() int {
	return 403
}

func (o *GetGroupsForRoleForbidden) Error() string {
	return fmt.Sprintf("[GET /authz/roles/{id}/group-assignments][%d] getGroupsForRoleForbidden  %+v", 403, o.Payload)
}

func (o *GetGroupsForRoleForbidden) String() string {
	return fmt.Sprintf("[GET /authz/roles/{id}/group-assignments][%d] getGroupsForRoleForbidden  %+v", 403, o.Payload)
}

func (o *GetGroupsForRoleForbidden) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *GetGroupsForRoleForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetGroupsForRoleNotFound creates a GetGroupsForRoleNotFound with default headers values
func NewGetGroupsForRoleNotFound() *GetGroupsForRoleNotFound {
	return &GetGroupsForRoleNotFound{}
}

/*
GetGroupsForRoleNotFound describes a response with status code 404, with default header values.

The specified role was not found.
*/
type GetGroupsForRoleNotFound struct {
}

// IsSuccess returns true when this get groups for role not found response has a 2xx status code
func (o *GetGroupsForRoleNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get groups for role not found response has a 3xx status code
func (o *GetGroupsForRoleNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get groups for role not found response has a 4xx status code
func (o *GetGroupsForRoleNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this get groups for role not found response has a 5xx status code
func (o *GetGroupsForRoleNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this get groups for role not found response a status code equal to that given
func (o *GetGroupsForRoleNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the get groups for role not found response
func (o *GetGroupsForRoleNotFound) Code() int {
	return 404
}

func (o *GetGroupsForRoleNotFound) Error() string {
	return fmt.Sprintf("[GET /authz/roles/{id}/group-assignments][%d] getGroupsForRoleNotFound ", 404)
}

func (o *GetGroupsForRoleNotFound) String() string {
	return fmt.Sprintf("[GET /authz/roles/{id}/group-assignments][%d] getGroupsForRoleNotFound ", 404)
}

func (o *GetGroupsForRoleNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewGetGroupsForRoleInternalServerError creates a GetGroupsForRoleInternalServerError with default headers values
func NewGetGroupsForRoleInternalServerError() *GetGroupsForRoleInternalServerError {
	return &GetGroupsForRoleInternalServerError{}
}

/*
GetGroupsForRoleInternalServerError describes a response with status code 500, with default header values.

An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.
*/
type GetGroupsForRoleInternalServerError struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this get groups for role internal server error response has a 2xx status code
func (o *GetGroupsForRoleInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get groups for role internal server error response has a 3xx status code
func (o *GetGroupsForRoleInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get groups for role internal server error response has a 4xx status code
func (o *GetGroupsForRoleInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get groups for role internal server error response has a 5xx status code
func (o *GetGroupsForRoleInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get groups for role internal server error response a status code equal to that given
func (o *GetGroupsForRoleInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get groups for role internal server error response
func (o *GetGroupsForRoleInternalServerError) Code() int {
	return 500
}

func (o *GetGroupsForRoleInternalServerError) Error() string {
	return fmt.Sprintf("[GET /authz/roles/{id}/group-assignments][%d] getGroupsForRoleInternalServerError  %+v", 500, o.Payload)
}

func (o *GetGroupsForRoleInternalServerError) String() string {
	return fmt.Sprintf("[GET /authz/roles/{id}/group-assignments][%d] getGroupsForRoleInternalServerError  %+v", 500, o.Payload)
}

func (o *GetGroupsForRoleInternalServerError) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *GetGroupsForRoleInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
GetGroupsForRoleOKBodyItems0 get groups for role o k body items0
swagger:model GetGroupsForRoleOKBodyItems0
*/
type GetGroupsForRoleOKBodyItems0 struct {

	// group Id
	GroupID string `json:"groupId,omitempty"`

	// group type
	// Required: true
	GroupType *models.GroupType `json:"groupType"`
}

// Validate validates this get groups for role o k body items0
func (o *GetGroupsForRoleOKBodyItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateGroupType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *GetGroupsForRoleOKBodyItems0) validateGroupType(formats strfmt.Registry) error {

	if err := validate.Required("groupType", "body", o.GroupType); err != nil {
		return err
	}

	if err := validate.Required("groupType", "body", o.GroupType); err != nil {
		return err
	}

	if o.GroupType != nil {
		if err := o.GroupType.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("groupType")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("groupType")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this get groups for role o k body items0 based on the context it is used
func (o *GetGroupsForRoleOKBodyItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateGroupType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *GetGroupsForRoleOKBodyItems0) contextValidateGroupType(ctx context.Context, formats strfmt.Registry) error {

	if o.GroupType != nil {
		if err := o.GroupType.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("groupType")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("groupType")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *GetGroupsForRoleOKBodyItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *GetGroupsForRoleOKBodyItems0) UnmarshalBinary(b []byte) error {
	var res GetGroupsForRoleOKBodyItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
