//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package authz

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewGetGroupsParams creates a new GetGroupsParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetGroupsParams() *GetGroupsParams {
	return &GetGroupsParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetGroupsParamsWithTimeout creates a new GetGroupsParams object
// with the ability to set a timeout on a request.
func NewGetGroupsParamsWithTimeout(timeout time.Duration) *GetGroupsParams {
	return &GetGroupsParams{
		timeout: timeout,
	}
}

// NewGetGroupsParamsWithContext creates a new GetGroupsParams object
// with the ability to set a context for a request.
func NewGetGroupsParamsWithContext(ctx context.Context) *GetGroupsParams {
	return &GetGroupsParams{
		Context: ctx,
	}
}

// NewGetGroupsParamsWithHTTPClient creates a new GetGroupsParams object
// with the ability to set a custom HTTPClient for a request.
func NewGetGroupsParamsWithHTTPClient(client *http.Client) *GetGroupsParams {
	return &GetGroupsParams{
		HTTPClient: client,
	}
}

/*
GetGroupsParams contains all the parameters to send to the API endpoint

	for the get groups operation.

	Typically these are written to a http.Request.
*/
type GetGroupsParams struct {

	/* GroupType.

	   The type of group to retrieve.
	*/
	GroupType string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get groups params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetGroupsParams) WithDefaults() *GetGroupsParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get groups params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetGroupsParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the get groups params
func (o *GetGroupsParams) WithTimeout(timeout time.Duration) *GetGroupsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get groups params
func (o *GetGroupsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get groups params
func (o *GetGroupsParams) WithContext(ctx context.Context) *GetGroupsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get groups params
func (o *GetGroupsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get groups params
func (o *GetGroupsParams) WithHTTPClient(client *http.Client) *GetGroupsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get groups params
func (o *GetGroupsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithGroupType adds the groupType to the get groups params
func (o *GetGroupsParams) WithGroupType(groupType string) *GetGroupsParams {
	o.SetGroupType(groupType)
	return o
}

// SetGroupType adds the groupType to the get groups params
func (o *GetGroupsParams) SetGroupType(groupType string) {
	o.GroupType = groupType
}

// WriteToRequest writes these params to a swagger request
func (o *GetGroupsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param groupType
	if err := r.SetPathParam("groupType", o.GroupType); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
