//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package authz

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/weaviate/weaviate/entities/models"
)

// GetRoleReader is a Reader for the GetRole structure.
type GetRoleReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetRoleReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetRoleOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewGetRoleBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewGetRoleUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetRoleForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewGetRoleNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetRoleInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewGetRoleOK creates a GetRoleOK with default headers values
func NewGetRoleOK() *GetRoleOK {
	return &GetRoleOK{}
}

/*
GetRoleOK describes a response with status code 200, with default header values.

Successful response.
*/
type GetRoleOK struct {
	Payload *models.Role
}

// IsSuccess returns true when this get role o k response has a 2xx status code
func (o *GetRoleOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get role o k response has a 3xx status code
func (o *GetRoleOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get role o k response has a 4xx status code
func (o *GetRoleOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get role o k response has a 5xx status code
func (o *GetRoleOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get role o k response a status code equal to that given
func (o *GetRoleOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get role o k response
func (o *GetRoleOK) Code() int {
	return 200
}

func (o *GetRoleOK) Error() string {
	return fmt.Sprintf("[GET /authz/roles/{id}][%d] getRoleOK  %+v", 200, o.Payload)
}

func (o *GetRoleOK) String() string {
	return fmt.Sprintf("[GET /authz/roles/{id}][%d] getRoleOK  %+v", 200, o.Payload)
}

func (o *GetRoleOK) GetPayload() *models.Role {
	return o.Payload
}

func (o *GetRoleOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Role)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetRoleBadRequest creates a GetRoleBadRequest with default headers values
func NewGetRoleBadRequest() *GetRoleBadRequest {
	return &GetRoleBadRequest{}
}

/*
GetRoleBadRequest describes a response with status code 400, with default header values.

Malformed request.
*/
type GetRoleBadRequest struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this get role bad request response has a 2xx status code
func (o *GetRoleBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get role bad request response has a 3xx status code
func (o *GetRoleBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get role bad request response has a 4xx status code
func (o *GetRoleBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this get role bad request response has a 5xx status code
func (o *GetRoleBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this get role bad request response a status code equal to that given
func (o *GetRoleBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the get role bad request response
func (o *GetRoleBadRequest) Code() int {
	return 400
}

func (o *GetRoleBadRequest) Error() string {
	return fmt.Sprintf("[GET /authz/roles/{id}][%d] getRoleBadRequest  %+v", 400, o.Payload)
}

func (o *GetRoleBadRequest) String() string {
	return fmt.Sprintf("[GET /authz/roles/{id}][%d] getRoleBadRequest  %+v", 400, o.Payload)
}

func (o *GetRoleBadRequest) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *GetRoleBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetRoleUnauthorized creates a GetRoleUnauthorized with default headers values
func NewGetRoleUnauthorized() *GetRoleUnauthorized {
	return &GetRoleUnauthorized{}
}

/*
GetRoleUnauthorized describes a response with status code 401, with default header values.

Unauthorized or invalid credentials.
*/
type GetRoleUnauthorized struct {
}

// IsSuccess returns true when this get role unauthorized response has a 2xx status code
func (o *GetRoleUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get role unauthorized response has a 3xx status code
func (o *GetRoleUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get role unauthorized response has a 4xx status code
func (o *GetRoleUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this get role unauthorized response has a 5xx status code
func (o *GetRoleUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this get role unauthorized response a status code equal to that given
func (o *GetRoleUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the get role unauthorized response
func (o *GetRoleUnauthorized) Code() int {
	return 401
}

func (o *GetRoleUnauthorized) Error() string {
	return fmt.Sprintf("[GET /authz/roles/{id}][%d] getRoleUnauthorized ", 401)
}

func (o *GetRoleUnauthorized) String() string {
	return fmt.Sprintf("[GET /authz/roles/{id}][%d] getRoleUnauthorized ", 401)
}

func (o *GetRoleUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewGetRoleForbidden creates a GetRoleForbidden with default headers values
func NewGetRoleForbidden() *GetRoleForbidden {
	return &GetRoleForbidden{}
}

/*
GetRoleForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type GetRoleForbidden struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this get role forbidden response has a 2xx status code
func (o *GetRoleForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get role forbidden response has a 3xx status code
func (o *GetRoleForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get role forbidden response has a 4xx status code
func (o *GetRoleForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get role forbidden response has a 5xx status code
func (o *GetRoleForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get role forbidden response a status code equal to that given
func (o *GetRoleForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get role forbidden response
func (o *GetRoleForbidden) Code() int {
	return 403
}

func (o *GetRoleForbidden) Error() string {
	return fmt.Sprintf("[GET /authz/roles/{id}][%d] getRoleForbidden  %+v", 403, o.Payload)
}

func (o *GetRoleForbidden) String() string {
	return fmt.Sprintf("[GET /authz/roles/{id}][%d] getRoleForbidden  %+v", 403, o.Payload)
}

func (o *GetRoleForbidden) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *GetRoleForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetRoleNotFound creates a GetRoleNotFound with default headers values
func NewGetRoleNotFound() *GetRoleNotFound {
	return &GetRoleNotFound{}
}

/*
GetRoleNotFound describes a response with status code 404, with default header values.

No role found.
*/
type GetRoleNotFound struct {
}

// IsSuccess returns true when this get role not found response has a 2xx status code
func (o *GetRoleNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get role not found response has a 3xx status code
func (o *GetRoleNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get role not found response has a 4xx status code
func (o *GetRoleNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this get role not found response has a 5xx status code
func (o *GetRoleNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this get role not found response a status code equal to that given
func (o *GetRoleNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the get role not found response
func (o *GetRoleNotFound) Code() int {
	return 404
}

func (o *GetRoleNotFound) Error() string {
	return fmt.Sprintf("[GET /authz/roles/{id}][%d] getRoleNotFound ", 404)
}

func (o *GetRoleNotFound) String() string {
	return fmt.Sprintf("[GET /authz/roles/{id}][%d] getRoleNotFound ", 404)
}

func (o *GetRoleNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewGetRoleInternalServerError creates a GetRoleInternalServerError with default headers values
func NewGetRoleInternalServerError() *GetRoleInternalServerError {
	return &GetRoleInternalServerError{}
}

/*
GetRoleInternalServerError describes a response with status code 500, with default header values.

An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.
*/
type GetRoleInternalServerError struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this get role internal server error response has a 2xx status code
func (o *GetRoleInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get role internal server error response has a 3xx status code
func (o *GetRoleInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get role internal server error response has a 4xx status code
func (o *GetRoleInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get role internal server error response has a 5xx status code
func (o *GetRoleInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get role internal server error response a status code equal to that given
func (o *GetRoleInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get role internal server error response
func (o *GetRoleInternalServerError) Code() int {
	return 500
}

func (o *GetRoleInternalServerError) Error() string {
	return fmt.Sprintf("[GET /authz/roles/{id}][%d] getRoleInternalServerError  %+v", 500, o.Payload)
}

func (o *GetRoleInternalServerError) String() string {
	return fmt.Sprintf("[GET /authz/roles/{id}][%d] getRoleInternalServerError  %+v", 500, o.Payload)
}

func (o *GetRoleInternalServerError) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *GetRoleInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
