//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package authz

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewGetRolesForGroupParams creates a new GetRolesForGroupParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetRolesForGroupParams() *GetRolesForGroupParams {
	return &GetRolesForGroupParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetRolesForGroupParamsWithTimeout creates a new GetRolesForGroupParams object
// with the ability to set a timeout on a request.
func NewGetRolesForGroupParamsWithTimeout(timeout time.Duration) *GetRolesForGroupParams {
	return &GetRolesForGroupParams{
		timeout: timeout,
	}
}

// NewGetRolesForGroupParamsWithContext creates a new GetRolesForGroupParams object
// with the ability to set a context for a request.
func NewGetRolesForGroupParamsWithContext(ctx context.Context) *GetRolesForGroupParams {
	return &GetRolesForGroupParams{
		Context: ctx,
	}
}

// NewGetRolesForGroupParamsWithHTTPClient creates a new GetRolesForGroupParams object
// with the ability to set a custom HTTPClient for a request.
func NewGetRolesForGroupParamsWithHTTPClient(client *http.Client) *GetRolesForGroupParams {
	return &GetRolesForGroupParams{
		HTTPClient: client,
	}
}

/*
GetRolesForGroupParams contains all the parameters to send to the API endpoint

	for the get roles for group operation.

	Typically these are written to a http.Request.
*/
type GetRolesForGroupParams struct {

	/* GroupType.

	   The type of the group.
	*/
	GroupType string

	/* ID.

	   The unique name of the group.
	*/
	ID string

	/* IncludeFullRoles.

	   If true, the response will include the full role definitions with all associated permissions. If false, only role names are returned.
	*/
	IncludeFullRoles *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get roles for group params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetRolesForGroupParams) WithDefaults() *GetRolesForGroupParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get roles for group params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetRolesForGroupParams) SetDefaults() {
	var (
		includeFullRolesDefault = bool(false)
	)

	val := GetRolesForGroupParams{
		IncludeFullRoles: &includeFullRolesDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the get roles for group params
func (o *GetRolesForGroupParams) WithTimeout(timeout time.Duration) *GetRolesForGroupParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get roles for group params
func (o *GetRolesForGroupParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get roles for group params
func (o *GetRolesForGroupParams) WithContext(ctx context.Context) *GetRolesForGroupParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get roles for group params
func (o *GetRolesForGroupParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get roles for group params
func (o *GetRolesForGroupParams) WithHTTPClient(client *http.Client) *GetRolesForGroupParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get roles for group params
func (o *GetRolesForGroupParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithGroupType adds the groupType to the get roles for group params
func (o *GetRolesForGroupParams) WithGroupType(groupType string) *GetRolesForGroupParams {
	o.SetGroupType(groupType)
	return o
}

// SetGroupType adds the groupType to the get roles for group params
func (o *GetRolesForGroupParams) SetGroupType(groupType string) {
	o.GroupType = groupType
}

// WithID adds the id to the get roles for group params
func (o *GetRolesForGroupParams) WithID(id string) *GetRolesForGroupParams {
	o.SetID(id)
	return o
}

// SetID adds the id to the get roles for group params
func (o *GetRolesForGroupParams) SetID(id string) {
	o.ID = id
}

// WithIncludeFullRoles adds the includeFullRoles to the get roles for group params
func (o *GetRolesForGroupParams) WithIncludeFullRoles(includeFullRoles *bool) *GetRolesForGroupParams {
	o.SetIncludeFullRoles(includeFullRoles)
	return o
}

// SetIncludeFullRoles adds the includeFullRoles to the get roles for group params
func (o *GetRolesForGroupParams) SetIncludeFullRoles(includeFullRoles *bool) {
	o.IncludeFullRoles = includeFullRoles
}

// WriteToRequest writes these params to a swagger request
func (o *GetRolesForGroupParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param groupType
	if err := r.SetPathParam("groupType", o.GroupType); err != nil {
		return err
	}

	// path param id
	if err := r.SetPathParam("id", o.ID); err != nil {
		return err
	}

	if o.IncludeFullRoles != nil {

		// query param includeFullRoles
		var qrIncludeFullRoles bool

		if o.IncludeFullRoles != nil {
			qrIncludeFullRoles = *o.IncludeFullRoles
		}
		qIncludeFullRoles := swag.FormatBool(qrIncludeFullRoles)
		if qIncludeFullRoles != "" {

			if err := r.SetQueryParam("includeFullRoles", qIncludeFullRoles); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
