//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package authz

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/weaviate/weaviate/entities/models"
)

// GetRolesForGroupReader is a Reader for the GetRolesForGroup structure.
type GetRolesForGroupReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetRolesForGroupReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetRolesForGroupOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewGetRolesForGroupBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewGetRolesForGroupUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetRolesForGroupForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewGetRolesForGroupNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 422:
		result := NewGetRolesForGroupUnprocessableEntity()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetRolesForGroupInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewGetRolesForGroupOK creates a GetRolesForGroupOK with default headers values
func NewGetRolesForGroupOK() *GetRolesForGroupOK {
	return &GetRolesForGroupOK{}
}

/*
GetRolesForGroupOK describes a response with status code 200, with default header values.

A list of roles assigned to the specified group.
*/
type GetRolesForGroupOK struct {
	Payload models.RolesListResponse
}

// IsSuccess returns true when this get roles for group o k response has a 2xx status code
func (o *GetRolesForGroupOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get roles for group o k response has a 3xx status code
func (o *GetRolesForGroupOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get roles for group o k response has a 4xx status code
func (o *GetRolesForGroupOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get roles for group o k response has a 5xx status code
func (o *GetRolesForGroupOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get roles for group o k response a status code equal to that given
func (o *GetRolesForGroupOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get roles for group o k response
func (o *GetRolesForGroupOK) Code() int {
	return 200
}

func (o *GetRolesForGroupOK) Error() string {
	return fmt.Sprintf("[GET /authz/groups/{id}/roles/{groupType}][%d] getRolesForGroupOK  %+v", 200, o.Payload)
}

func (o *GetRolesForGroupOK) String() string {
	return fmt.Sprintf("[GET /authz/groups/{id}/roles/{groupType}][%d] getRolesForGroupOK  %+v", 200, o.Payload)
}

func (o *GetRolesForGroupOK) GetPayload() models.RolesListResponse {
	return o.Payload
}

func (o *GetRolesForGroupOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetRolesForGroupBadRequest creates a GetRolesForGroupBadRequest with default headers values
func NewGetRolesForGroupBadRequest() *GetRolesForGroupBadRequest {
	return &GetRolesForGroupBadRequest{}
}

/*
GetRolesForGroupBadRequest describes a response with status code 400, with default header values.

Bad request
*/
type GetRolesForGroupBadRequest struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this get roles for group bad request response has a 2xx status code
func (o *GetRolesForGroupBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get roles for group bad request response has a 3xx status code
func (o *GetRolesForGroupBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get roles for group bad request response has a 4xx status code
func (o *GetRolesForGroupBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this get roles for group bad request response has a 5xx status code
func (o *GetRolesForGroupBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this get roles for group bad request response a status code equal to that given
func (o *GetRolesForGroupBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the get roles for group bad request response
func (o *GetRolesForGroupBadRequest) Code() int {
	return 400
}

func (o *GetRolesForGroupBadRequest) Error() string {
	return fmt.Sprintf("[GET /authz/groups/{id}/roles/{groupType}][%d] getRolesForGroupBadRequest  %+v", 400, o.Payload)
}

func (o *GetRolesForGroupBadRequest) String() string {
	return fmt.Sprintf("[GET /authz/groups/{id}/roles/{groupType}][%d] getRolesForGroupBadRequest  %+v", 400, o.Payload)
}

func (o *GetRolesForGroupBadRequest) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *GetRolesForGroupBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetRolesForGroupUnauthorized creates a GetRolesForGroupUnauthorized with default headers values
func NewGetRolesForGroupUnauthorized() *GetRolesForGroupUnauthorized {
	return &GetRolesForGroupUnauthorized{}
}

/*
GetRolesForGroupUnauthorized describes a response with status code 401, with default header values.

Unauthorized or invalid credentials.
*/
type GetRolesForGroupUnauthorized struct {
}

// IsSuccess returns true when this get roles for group unauthorized response has a 2xx status code
func (o *GetRolesForGroupUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get roles for group unauthorized response has a 3xx status code
func (o *GetRolesForGroupUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get roles for group unauthorized response has a 4xx status code
func (o *GetRolesForGroupUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this get roles for group unauthorized response has a 5xx status code
func (o *GetRolesForGroupUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this get roles for group unauthorized response a status code equal to that given
func (o *GetRolesForGroupUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the get roles for group unauthorized response
func (o *GetRolesForGroupUnauthorized) Code() int {
	return 401
}

func (o *GetRolesForGroupUnauthorized) Error() string {
	return fmt.Sprintf("[GET /authz/groups/{id}/roles/{groupType}][%d] getRolesForGroupUnauthorized ", 401)
}

func (o *GetRolesForGroupUnauthorized) String() string {
	return fmt.Sprintf("[GET /authz/groups/{id}/roles/{groupType}][%d] getRolesForGroupUnauthorized ", 401)
}

func (o *GetRolesForGroupUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewGetRolesForGroupForbidden creates a GetRolesForGroupForbidden with default headers values
func NewGetRolesForGroupForbidden() *GetRolesForGroupForbidden {
	return &GetRolesForGroupForbidden{}
}

/*
GetRolesForGroupForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type GetRolesForGroupForbidden struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this get roles for group forbidden response has a 2xx status code
func (o *GetRolesForGroupForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get roles for group forbidden response has a 3xx status code
func (o *GetRolesForGroupForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get roles for group forbidden response has a 4xx status code
func (o *GetRolesForGroupForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get roles for group forbidden response has a 5xx status code
func (o *GetRolesForGroupForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get roles for group forbidden response a status code equal to that given
func (o *GetRolesForGroupForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get roles for group forbidden response
func (o *GetRolesForGroupForbidden) Code() int {
	return 403
}

func (o *GetRolesForGroupForbidden) Error() string {
	return fmt.Sprintf("[GET /authz/groups/{id}/roles/{groupType}][%d] getRolesForGroupForbidden  %+v", 403, o.Payload)
}

func (o *GetRolesForGroupForbidden) String() string {
	return fmt.Sprintf("[GET /authz/groups/{id}/roles/{groupType}][%d] getRolesForGroupForbidden  %+v", 403, o.Payload)
}

func (o *GetRolesForGroupForbidden) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *GetRolesForGroupForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetRolesForGroupNotFound creates a GetRolesForGroupNotFound with default headers values
func NewGetRolesForGroupNotFound() *GetRolesForGroupNotFound {
	return &GetRolesForGroupNotFound{}
}

/*
GetRolesForGroupNotFound describes a response with status code 404, with default header values.

The specified group was not found.
*/
type GetRolesForGroupNotFound struct {
}

// IsSuccess returns true when this get roles for group not found response has a 2xx status code
func (o *GetRolesForGroupNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get roles for group not found response has a 3xx status code
func (o *GetRolesForGroupNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get roles for group not found response has a 4xx status code
func (o *GetRolesForGroupNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this get roles for group not found response has a 5xx status code
func (o *GetRolesForGroupNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this get roles for group not found response a status code equal to that given
func (o *GetRolesForGroupNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the get roles for group not found response
func (o *GetRolesForGroupNotFound) Code() int {
	return 404
}

func (o *GetRolesForGroupNotFound) Error() string {
	return fmt.Sprintf("[GET /authz/groups/{id}/roles/{groupType}][%d] getRolesForGroupNotFound ", 404)
}

func (o *GetRolesForGroupNotFound) String() string {
	return fmt.Sprintf("[GET /authz/groups/{id}/roles/{groupType}][%d] getRolesForGroupNotFound ", 404)
}

func (o *GetRolesForGroupNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewGetRolesForGroupUnprocessableEntity creates a GetRolesForGroupUnprocessableEntity with default headers values
func NewGetRolesForGroupUnprocessableEntity() *GetRolesForGroupUnprocessableEntity {
	return &GetRolesForGroupUnprocessableEntity{}
}

/*
GetRolesForGroupUnprocessableEntity describes a response with status code 422, with default header values.

The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request.
*/
type GetRolesForGroupUnprocessableEntity struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this get roles for group unprocessable entity response has a 2xx status code
func (o *GetRolesForGroupUnprocessableEntity) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get roles for group unprocessable entity response has a 3xx status code
func (o *GetRolesForGroupUnprocessableEntity) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get roles for group unprocessable entity response has a 4xx status code
func (o *GetRolesForGroupUnprocessableEntity) IsClientError() bool {
	return true
}

// IsServerError returns true when this get roles for group unprocessable entity response has a 5xx status code
func (o *GetRolesForGroupUnprocessableEntity) IsServerError() bool {
	return false
}

// IsCode returns true when this get roles for group unprocessable entity response a status code equal to that given
func (o *GetRolesForGroupUnprocessableEntity) IsCode(code int) bool {
	return code == 422
}

// Code gets the status code for the get roles for group unprocessable entity response
func (o *GetRolesForGroupUnprocessableEntity) Code() int {
	return 422
}

func (o *GetRolesForGroupUnprocessableEntity) Error() string {
	return fmt.Sprintf("[GET /authz/groups/{id}/roles/{groupType}][%d] getRolesForGroupUnprocessableEntity  %+v", 422, o.Payload)
}

func (o *GetRolesForGroupUnprocessableEntity) String() string {
	return fmt.Sprintf("[GET /authz/groups/{id}/roles/{groupType}][%d] getRolesForGroupUnprocessableEntity  %+v", 422, o.Payload)
}

func (o *GetRolesForGroupUnprocessableEntity) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *GetRolesForGroupUnprocessableEntity) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetRolesForGroupInternalServerError creates a GetRolesForGroupInternalServerError with default headers values
func NewGetRolesForGroupInternalServerError() *GetRolesForGroupInternalServerError {
	return &GetRolesForGroupInternalServerError{}
}

/*
GetRolesForGroupInternalServerError describes a response with status code 500, with default header values.

An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.
*/
type GetRolesForGroupInternalServerError struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this get roles for group internal server error response has a 2xx status code
func (o *GetRolesForGroupInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get roles for group internal server error response has a 3xx status code
func (o *GetRolesForGroupInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get roles for group internal server error response has a 4xx status code
func (o *GetRolesForGroupInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get roles for group internal server error response has a 5xx status code
func (o *GetRolesForGroupInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get roles for group internal server error response a status code equal to that given
func (o *GetRolesForGroupInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get roles for group internal server error response
func (o *GetRolesForGroupInternalServerError) Code() int {
	return 500
}

func (o *GetRolesForGroupInternalServerError) Error() string {
	return fmt.Sprintf("[GET /authz/groups/{id}/roles/{groupType}][%d] getRolesForGroupInternalServerError  %+v", 500, o.Payload)
}

func (o *GetRolesForGroupInternalServerError) String() string {
	return fmt.Sprintf("[GET /authz/groups/{id}/roles/{groupType}][%d] getRolesForGroupInternalServerError  %+v", 500, o.Payload)
}

func (o *GetRolesForGroupInternalServerError) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *GetRolesForGroupInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
