//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package authz

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewGetUsersForRoleParams creates a new GetUsersForRoleParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetUsersForRoleParams() *GetUsersForRoleParams {
	return &GetUsersForRoleParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetUsersForRoleParamsWithTimeout creates a new GetUsersForRoleParams object
// with the ability to set a timeout on a request.
func NewGetUsersForRoleParamsWithTimeout(timeout time.Duration) *GetUsersForRoleParams {
	return &GetUsersForRoleParams{
		timeout: timeout,
	}
}

// NewGetUsersForRoleParamsWithContext creates a new GetUsersForRoleParams object
// with the ability to set a context for a request.
func NewGetUsersForRoleParamsWithContext(ctx context.Context) *GetUsersForRoleParams {
	return &GetUsersForRoleParams{
		Context: ctx,
	}
}

// NewGetUsersForRoleParamsWithHTTPClient creates a new GetUsersForRoleParams object
// with the ability to set a custom HTTPClient for a request.
func NewGetUsersForRoleParamsWithHTTPClient(client *http.Client) *GetUsersForRoleParams {
	return &GetUsersForRoleParams{
		HTTPClient: client,
	}
}

/*
GetUsersForRoleParams contains all the parameters to send to the API endpoint

	for the get users for role operation.

	Typically these are written to a http.Request.
*/
type GetUsersForRoleParams struct {

	/* ID.

	   The name (ID) of the role.
	*/
	ID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get users for role params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetUsersForRoleParams) WithDefaults() *GetUsersForRoleParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get users for role params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetUsersForRoleParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the get users for role params
func (o *GetUsersForRoleParams) WithTimeout(timeout time.Duration) *GetUsersForRoleParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get users for role params
func (o *GetUsersForRoleParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get users for role params
func (o *GetUsersForRoleParams) WithContext(ctx context.Context) *GetUsersForRoleParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get users for role params
func (o *GetUsersForRoleParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get users for role params
func (o *GetUsersForRoleParams) WithHTTPClient(client *http.Client) *GetUsersForRoleParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get users for role params
func (o *GetUsersForRoleParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithID adds the id to the get users for role params
func (o *GetUsersForRoleParams) WithID(id string) *GetUsersForRoleParams {
	o.SetID(id)
	return o
}

// SetID adds the id to the get users for role params
func (o *GetUsersForRoleParams) SetID(id string) {
	o.ID = id
}

// WriteToRequest writes these params to a swagger request
func (o *GetUsersForRoleParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param id
	if err := r.SetPathParam("id", o.ID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
