//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package authz

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewRevokeRoleFromGroupParams creates a new RevokeRoleFromGroupParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewRevokeRoleFromGroupParams() *RevokeRoleFromGroupParams {
	return &RevokeRoleFromGroupParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewRevokeRoleFromGroupParamsWithTimeout creates a new RevokeRoleFromGroupParams object
// with the ability to set a timeout on a request.
func NewRevokeRoleFromGroupParamsWithTimeout(timeout time.Duration) *RevokeRoleFromGroupParams {
	return &RevokeRoleFromGroupParams{
		timeout: timeout,
	}
}

// NewRevokeRoleFromGroupParamsWithContext creates a new RevokeRoleFromGroupParams object
// with the ability to set a context for a request.
func NewRevokeRoleFromGroupParamsWithContext(ctx context.Context) *RevokeRoleFromGroupParams {
	return &RevokeRoleFromGroupParams{
		Context: ctx,
	}
}

// NewRevokeRoleFromGroupParamsWithHTTPClient creates a new RevokeRoleFromGroupParams object
// with the ability to set a custom HTTPClient for a request.
func NewRevokeRoleFromGroupParamsWithHTTPClient(client *http.Client) *RevokeRoleFromGroupParams {
	return &RevokeRoleFromGroupParams{
		HTTPClient: client,
	}
}

/*
RevokeRoleFromGroupParams contains all the parameters to send to the API endpoint

	for the revoke role from group operation.

	Typically these are written to a http.Request.
*/
type RevokeRoleFromGroupParams struct {

	// Body.
	Body RevokeRoleFromGroupBody

	/* ID.

	   The name of the group.
	*/
	ID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the revoke role from group params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *RevokeRoleFromGroupParams) WithDefaults() *RevokeRoleFromGroupParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the revoke role from group params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *RevokeRoleFromGroupParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the revoke role from group params
func (o *RevokeRoleFromGroupParams) WithTimeout(timeout time.Duration) *RevokeRoleFromGroupParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the revoke role from group params
func (o *RevokeRoleFromGroupParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the revoke role from group params
func (o *RevokeRoleFromGroupParams) WithContext(ctx context.Context) *RevokeRoleFromGroupParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the revoke role from group params
func (o *RevokeRoleFromGroupParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the revoke role from group params
func (o *RevokeRoleFromGroupParams) WithHTTPClient(client *http.Client) *RevokeRoleFromGroupParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the revoke role from group params
func (o *RevokeRoleFromGroupParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the revoke role from group params
func (o *RevokeRoleFromGroupParams) WithBody(body RevokeRoleFromGroupBody) *RevokeRoleFromGroupParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the revoke role from group params
func (o *RevokeRoleFromGroupParams) SetBody(body RevokeRoleFromGroupBody) {
	o.Body = body
}

// WithID adds the id to the revoke role from group params
func (o *RevokeRoleFromGroupParams) WithID(id string) *RevokeRoleFromGroupParams {
	o.SetID(id)
	return o
}

// SetID adds the id to the revoke role from group params
func (o *RevokeRoleFromGroupParams) SetID(id string) {
	o.ID = id
}

// WriteToRequest writes these params to a swagger request
func (o *RevokeRoleFromGroupParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if err := r.SetBodyParam(o.Body); err != nil {
		return err
	}

	// path param id
	if err := r.SetPathParam("id", o.ID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
