//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package authz

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/weaviate/weaviate/entities/models"
)

// RevokeRoleFromGroupReader is a Reader for the RevokeRoleFromGroup structure.
type RevokeRoleFromGroupReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *RevokeRoleFromGroupReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewRevokeRoleFromGroupOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewRevokeRoleFromGroupBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewRevokeRoleFromGroupUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewRevokeRoleFromGroupForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewRevokeRoleFromGroupNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewRevokeRoleFromGroupInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewRevokeRoleFromGroupOK creates a RevokeRoleFromGroupOK with default headers values
func NewRevokeRoleFromGroupOK() *RevokeRoleFromGroupOK {
	return &RevokeRoleFromGroupOK{}
}

/*
RevokeRoleFromGroupOK describes a response with status code 200, with default header values.

Roles revoked successfully.
*/
type RevokeRoleFromGroupOK struct {
}

// IsSuccess returns true when this revoke role from group o k response has a 2xx status code
func (o *RevokeRoleFromGroupOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this revoke role from group o k response has a 3xx status code
func (o *RevokeRoleFromGroupOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this revoke role from group o k response has a 4xx status code
func (o *RevokeRoleFromGroupOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this revoke role from group o k response has a 5xx status code
func (o *RevokeRoleFromGroupOK) IsServerError() bool {
	return false
}

// IsCode returns true when this revoke role from group o k response a status code equal to that given
func (o *RevokeRoleFromGroupOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the revoke role from group o k response
func (o *RevokeRoleFromGroupOK) Code() int {
	return 200
}

func (o *RevokeRoleFromGroupOK) Error() string {
	return fmt.Sprintf("[POST /authz/groups/{id}/revoke][%d] revokeRoleFromGroupOK ", 200)
}

func (o *RevokeRoleFromGroupOK) String() string {
	return fmt.Sprintf("[POST /authz/groups/{id}/revoke][%d] revokeRoleFromGroupOK ", 200)
}

func (o *RevokeRoleFromGroupOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewRevokeRoleFromGroupBadRequest creates a RevokeRoleFromGroupBadRequest with default headers values
func NewRevokeRoleFromGroupBadRequest() *RevokeRoleFromGroupBadRequest {
	return &RevokeRoleFromGroupBadRequest{}
}

/*
RevokeRoleFromGroupBadRequest describes a response with status code 400, with default header values.

Malformed request.
*/
type RevokeRoleFromGroupBadRequest struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this revoke role from group bad request response has a 2xx status code
func (o *RevokeRoleFromGroupBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this revoke role from group bad request response has a 3xx status code
func (o *RevokeRoleFromGroupBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this revoke role from group bad request response has a 4xx status code
func (o *RevokeRoleFromGroupBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this revoke role from group bad request response has a 5xx status code
func (o *RevokeRoleFromGroupBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this revoke role from group bad request response a status code equal to that given
func (o *RevokeRoleFromGroupBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the revoke role from group bad request response
func (o *RevokeRoleFromGroupBadRequest) Code() int {
	return 400
}

func (o *RevokeRoleFromGroupBadRequest) Error() string {
	return fmt.Sprintf("[POST /authz/groups/{id}/revoke][%d] revokeRoleFromGroupBadRequest  %+v", 400, o.Payload)
}

func (o *RevokeRoleFromGroupBadRequest) String() string {
	return fmt.Sprintf("[POST /authz/groups/{id}/revoke][%d] revokeRoleFromGroupBadRequest  %+v", 400, o.Payload)
}

func (o *RevokeRoleFromGroupBadRequest) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *RevokeRoleFromGroupBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewRevokeRoleFromGroupUnauthorized creates a RevokeRoleFromGroupUnauthorized with default headers values
func NewRevokeRoleFromGroupUnauthorized() *RevokeRoleFromGroupUnauthorized {
	return &RevokeRoleFromGroupUnauthorized{}
}

/*
RevokeRoleFromGroupUnauthorized describes a response with status code 401, with default header values.

Unauthorized or invalid credentials.
*/
type RevokeRoleFromGroupUnauthorized struct {
}

// IsSuccess returns true when this revoke role from group unauthorized response has a 2xx status code
func (o *RevokeRoleFromGroupUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this revoke role from group unauthorized response has a 3xx status code
func (o *RevokeRoleFromGroupUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this revoke role from group unauthorized response has a 4xx status code
func (o *RevokeRoleFromGroupUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this revoke role from group unauthorized response has a 5xx status code
func (o *RevokeRoleFromGroupUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this revoke role from group unauthorized response a status code equal to that given
func (o *RevokeRoleFromGroupUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the revoke role from group unauthorized response
func (o *RevokeRoleFromGroupUnauthorized) Code() int {
	return 401
}

func (o *RevokeRoleFromGroupUnauthorized) Error() string {
	return fmt.Sprintf("[POST /authz/groups/{id}/revoke][%d] revokeRoleFromGroupUnauthorized ", 401)
}

func (o *RevokeRoleFromGroupUnauthorized) String() string {
	return fmt.Sprintf("[POST /authz/groups/{id}/revoke][%d] revokeRoleFromGroupUnauthorized ", 401)
}

func (o *RevokeRoleFromGroupUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewRevokeRoleFromGroupForbidden creates a RevokeRoleFromGroupForbidden with default headers values
func NewRevokeRoleFromGroupForbidden() *RevokeRoleFromGroupForbidden {
	return &RevokeRoleFromGroupForbidden{}
}

/*
RevokeRoleFromGroupForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type RevokeRoleFromGroupForbidden struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this revoke role from group forbidden response has a 2xx status code
func (o *RevokeRoleFromGroupForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this revoke role from group forbidden response has a 3xx status code
func (o *RevokeRoleFromGroupForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this revoke role from group forbidden response has a 4xx status code
func (o *RevokeRoleFromGroupForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this revoke role from group forbidden response has a 5xx status code
func (o *RevokeRoleFromGroupForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this revoke role from group forbidden response a status code equal to that given
func (o *RevokeRoleFromGroupForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the revoke role from group forbidden response
func (o *RevokeRoleFromGroupForbidden) Code() int {
	return 403
}

func (o *RevokeRoleFromGroupForbidden) Error() string {
	return fmt.Sprintf("[POST /authz/groups/{id}/revoke][%d] revokeRoleFromGroupForbidden  %+v", 403, o.Payload)
}

func (o *RevokeRoleFromGroupForbidden) String() string {
	return fmt.Sprintf("[POST /authz/groups/{id}/revoke][%d] revokeRoleFromGroupForbidden  %+v", 403, o.Payload)
}

func (o *RevokeRoleFromGroupForbidden) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *RevokeRoleFromGroupForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewRevokeRoleFromGroupNotFound creates a RevokeRoleFromGroupNotFound with default headers values
func NewRevokeRoleFromGroupNotFound() *RevokeRoleFromGroupNotFound {
	return &RevokeRoleFromGroupNotFound{}
}

/*
RevokeRoleFromGroupNotFound describes a response with status code 404, with default header values.

Role or group not found.
*/
type RevokeRoleFromGroupNotFound struct {
}

// IsSuccess returns true when this revoke role from group not found response has a 2xx status code
func (o *RevokeRoleFromGroupNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this revoke role from group not found response has a 3xx status code
func (o *RevokeRoleFromGroupNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this revoke role from group not found response has a 4xx status code
func (o *RevokeRoleFromGroupNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this revoke role from group not found response has a 5xx status code
func (o *RevokeRoleFromGroupNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this revoke role from group not found response a status code equal to that given
func (o *RevokeRoleFromGroupNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the revoke role from group not found response
func (o *RevokeRoleFromGroupNotFound) Code() int {
	return 404
}

func (o *RevokeRoleFromGroupNotFound) Error() string {
	return fmt.Sprintf("[POST /authz/groups/{id}/revoke][%d] revokeRoleFromGroupNotFound ", 404)
}

func (o *RevokeRoleFromGroupNotFound) String() string {
	return fmt.Sprintf("[POST /authz/groups/{id}/revoke][%d] revokeRoleFromGroupNotFound ", 404)
}

func (o *RevokeRoleFromGroupNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewRevokeRoleFromGroupInternalServerError creates a RevokeRoleFromGroupInternalServerError with default headers values
func NewRevokeRoleFromGroupInternalServerError() *RevokeRoleFromGroupInternalServerError {
	return &RevokeRoleFromGroupInternalServerError{}
}

/*
RevokeRoleFromGroupInternalServerError describes a response with status code 500, with default header values.

An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.
*/
type RevokeRoleFromGroupInternalServerError struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this revoke role from group internal server error response has a 2xx status code
func (o *RevokeRoleFromGroupInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this revoke role from group internal server error response has a 3xx status code
func (o *RevokeRoleFromGroupInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this revoke role from group internal server error response has a 4xx status code
func (o *RevokeRoleFromGroupInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this revoke role from group internal server error response has a 5xx status code
func (o *RevokeRoleFromGroupInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this revoke role from group internal server error response a status code equal to that given
func (o *RevokeRoleFromGroupInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the revoke role from group internal server error response
func (o *RevokeRoleFromGroupInternalServerError) Code() int {
	return 500
}

func (o *RevokeRoleFromGroupInternalServerError) Error() string {
	return fmt.Sprintf("[POST /authz/groups/{id}/revoke][%d] revokeRoleFromGroupInternalServerError  %+v", 500, o.Payload)
}

func (o *RevokeRoleFromGroupInternalServerError) String() string {
	return fmt.Sprintf("[POST /authz/groups/{id}/revoke][%d] revokeRoleFromGroupInternalServerError  %+v", 500, o.Payload)
}

func (o *RevokeRoleFromGroupInternalServerError) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *RevokeRoleFromGroupInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
RevokeRoleFromGroupBody revoke role from group body
swagger:model RevokeRoleFromGroupBody
*/
type RevokeRoleFromGroupBody struct {

	// group type
	GroupType models.GroupType `json:"groupType,omitempty"`

	// The roles to revoke from the specified group.
	Roles []string `json:"roles"`
}

// Validate validates this revoke role from group body
func (o *RevokeRoleFromGroupBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateGroupType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *RevokeRoleFromGroupBody) validateGroupType(formats strfmt.Registry) error {
	if swag.IsZero(o.GroupType) { // not required
		return nil
	}

	if err := o.GroupType.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("body" + "." + "groupType")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("body" + "." + "groupType")
		}
		return err
	}

	return nil
}

// ContextValidate validate this revoke role from group body based on the context it is used
func (o *RevokeRoleFromGroupBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateGroupType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *RevokeRoleFromGroupBody) contextValidateGroupType(ctx context.Context, formats strfmt.Registry) error {

	if err := o.GroupType.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("body" + "." + "groupType")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("body" + "." + "groupType")
		}
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *RevokeRoleFromGroupBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *RevokeRoleFromGroupBody) UnmarshalBinary(b []byte) error {
	var res RevokeRoleFromGroupBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
