//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package authz

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/weaviate/weaviate/entities/models"
)

// RevokeRoleFromUserReader is a Reader for the RevokeRoleFromUser structure.
type RevokeRoleFromUserReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *RevokeRoleFromUserReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewRevokeRoleFromUserOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewRevokeRoleFromUserBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewRevokeRoleFromUserUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewRevokeRoleFromUserForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewRevokeRoleFromUserNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewRevokeRoleFromUserInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewRevokeRoleFromUserOK creates a RevokeRoleFromUserOK with default headers values
func NewRevokeRoleFromUserOK() *RevokeRoleFromUserOK {
	return &RevokeRoleFromUserOK{}
}

/*
RevokeRoleFromUserOK describes a response with status code 200, with default header values.

Roles revoked successfully.
*/
type RevokeRoleFromUserOK struct {
}

// IsSuccess returns true when this revoke role from user o k response has a 2xx status code
func (o *RevokeRoleFromUserOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this revoke role from user o k response has a 3xx status code
func (o *RevokeRoleFromUserOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this revoke role from user o k response has a 4xx status code
func (o *RevokeRoleFromUserOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this revoke role from user o k response has a 5xx status code
func (o *RevokeRoleFromUserOK) IsServerError() bool {
	return false
}

// IsCode returns true when this revoke role from user o k response a status code equal to that given
func (o *RevokeRoleFromUserOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the revoke role from user o k response
func (o *RevokeRoleFromUserOK) Code() int {
	return 200
}

func (o *RevokeRoleFromUserOK) Error() string {
	return fmt.Sprintf("[POST /authz/users/{id}/revoke][%d] revokeRoleFromUserOK ", 200)
}

func (o *RevokeRoleFromUserOK) String() string {
	return fmt.Sprintf("[POST /authz/users/{id}/revoke][%d] revokeRoleFromUserOK ", 200)
}

func (o *RevokeRoleFromUserOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewRevokeRoleFromUserBadRequest creates a RevokeRoleFromUserBadRequest with default headers values
func NewRevokeRoleFromUserBadRequest() *RevokeRoleFromUserBadRequest {
	return &RevokeRoleFromUserBadRequest{}
}

/*
RevokeRoleFromUserBadRequest describes a response with status code 400, with default header values.

Malformed request.
*/
type RevokeRoleFromUserBadRequest struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this revoke role from user bad request response has a 2xx status code
func (o *RevokeRoleFromUserBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this revoke role from user bad request response has a 3xx status code
func (o *RevokeRoleFromUserBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this revoke role from user bad request response has a 4xx status code
func (o *RevokeRoleFromUserBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this revoke role from user bad request response has a 5xx status code
func (o *RevokeRoleFromUserBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this revoke role from user bad request response a status code equal to that given
func (o *RevokeRoleFromUserBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the revoke role from user bad request response
func (o *RevokeRoleFromUserBadRequest) Code() int {
	return 400
}

func (o *RevokeRoleFromUserBadRequest) Error() string {
	return fmt.Sprintf("[POST /authz/users/{id}/revoke][%d] revokeRoleFromUserBadRequest  %+v", 400, o.Payload)
}

func (o *RevokeRoleFromUserBadRequest) String() string {
	return fmt.Sprintf("[POST /authz/users/{id}/revoke][%d] revokeRoleFromUserBadRequest  %+v", 400, o.Payload)
}

func (o *RevokeRoleFromUserBadRequest) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *RevokeRoleFromUserBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewRevokeRoleFromUserUnauthorized creates a RevokeRoleFromUserUnauthorized with default headers values
func NewRevokeRoleFromUserUnauthorized() *RevokeRoleFromUserUnauthorized {
	return &RevokeRoleFromUserUnauthorized{}
}

/*
RevokeRoleFromUserUnauthorized describes a response with status code 401, with default header values.

Unauthorized or invalid credentials.
*/
type RevokeRoleFromUserUnauthorized struct {
}

// IsSuccess returns true when this revoke role from user unauthorized response has a 2xx status code
func (o *RevokeRoleFromUserUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this revoke role from user unauthorized response has a 3xx status code
func (o *RevokeRoleFromUserUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this revoke role from user unauthorized response has a 4xx status code
func (o *RevokeRoleFromUserUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this revoke role from user unauthorized response has a 5xx status code
func (o *RevokeRoleFromUserUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this revoke role from user unauthorized response a status code equal to that given
func (o *RevokeRoleFromUserUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the revoke role from user unauthorized response
func (o *RevokeRoleFromUserUnauthorized) Code() int {
	return 401
}

func (o *RevokeRoleFromUserUnauthorized) Error() string {
	return fmt.Sprintf("[POST /authz/users/{id}/revoke][%d] revokeRoleFromUserUnauthorized ", 401)
}

func (o *RevokeRoleFromUserUnauthorized) String() string {
	return fmt.Sprintf("[POST /authz/users/{id}/revoke][%d] revokeRoleFromUserUnauthorized ", 401)
}

func (o *RevokeRoleFromUserUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewRevokeRoleFromUserForbidden creates a RevokeRoleFromUserForbidden with default headers values
func NewRevokeRoleFromUserForbidden() *RevokeRoleFromUserForbidden {
	return &RevokeRoleFromUserForbidden{}
}

/*
RevokeRoleFromUserForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type RevokeRoleFromUserForbidden struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this revoke role from user forbidden response has a 2xx status code
func (o *RevokeRoleFromUserForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this revoke role from user forbidden response has a 3xx status code
func (o *RevokeRoleFromUserForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this revoke role from user forbidden response has a 4xx status code
func (o *RevokeRoleFromUserForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this revoke role from user forbidden response has a 5xx status code
func (o *RevokeRoleFromUserForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this revoke role from user forbidden response a status code equal to that given
func (o *RevokeRoleFromUserForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the revoke role from user forbidden response
func (o *RevokeRoleFromUserForbidden) Code() int {
	return 403
}

func (o *RevokeRoleFromUserForbidden) Error() string {
	return fmt.Sprintf("[POST /authz/users/{id}/revoke][%d] revokeRoleFromUserForbidden  %+v", 403, o.Payload)
}

func (o *RevokeRoleFromUserForbidden) String() string {
	return fmt.Sprintf("[POST /authz/users/{id}/revoke][%d] revokeRoleFromUserForbidden  %+v", 403, o.Payload)
}

func (o *RevokeRoleFromUserForbidden) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *RevokeRoleFromUserForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewRevokeRoleFromUserNotFound creates a RevokeRoleFromUserNotFound with default headers values
func NewRevokeRoleFromUserNotFound() *RevokeRoleFromUserNotFound {
	return &RevokeRoleFromUserNotFound{}
}

/*
RevokeRoleFromUserNotFound describes a response with status code 404, with default header values.

Specified role or user not found.
*/
type RevokeRoleFromUserNotFound struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this revoke role from user not found response has a 2xx status code
func (o *RevokeRoleFromUserNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this revoke role from user not found response has a 3xx status code
func (o *RevokeRoleFromUserNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this revoke role from user not found response has a 4xx status code
func (o *RevokeRoleFromUserNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this revoke role from user not found response has a 5xx status code
func (o *RevokeRoleFromUserNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this revoke role from user not found response a status code equal to that given
func (o *RevokeRoleFromUserNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the revoke role from user not found response
func (o *RevokeRoleFromUserNotFound) Code() int {
	return 404
}

func (o *RevokeRoleFromUserNotFound) Error() string {
	return fmt.Sprintf("[POST /authz/users/{id}/revoke][%d] revokeRoleFromUserNotFound  %+v", 404, o.Payload)
}

func (o *RevokeRoleFromUserNotFound) String() string {
	return fmt.Sprintf("[POST /authz/users/{id}/revoke][%d] revokeRoleFromUserNotFound  %+v", 404, o.Payload)
}

func (o *RevokeRoleFromUserNotFound) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *RevokeRoleFromUserNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewRevokeRoleFromUserInternalServerError creates a RevokeRoleFromUserInternalServerError with default headers values
func NewRevokeRoleFromUserInternalServerError() *RevokeRoleFromUserInternalServerError {
	return &RevokeRoleFromUserInternalServerError{}
}

/*
RevokeRoleFromUserInternalServerError describes a response with status code 500, with default header values.

An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.
*/
type RevokeRoleFromUserInternalServerError struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this revoke role from user internal server error response has a 2xx status code
func (o *RevokeRoleFromUserInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this revoke role from user internal server error response has a 3xx status code
func (o *RevokeRoleFromUserInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this revoke role from user internal server error response has a 4xx status code
func (o *RevokeRoleFromUserInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this revoke role from user internal server error response has a 5xx status code
func (o *RevokeRoleFromUserInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this revoke role from user internal server error response a status code equal to that given
func (o *RevokeRoleFromUserInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the revoke role from user internal server error response
func (o *RevokeRoleFromUserInternalServerError) Code() int {
	return 500
}

func (o *RevokeRoleFromUserInternalServerError) Error() string {
	return fmt.Sprintf("[POST /authz/users/{id}/revoke][%d] revokeRoleFromUserInternalServerError  %+v", 500, o.Payload)
}

func (o *RevokeRoleFromUserInternalServerError) String() string {
	return fmt.Sprintf("[POST /authz/users/{id}/revoke][%d] revokeRoleFromUserInternalServerError  %+v", 500, o.Payload)
}

func (o *RevokeRoleFromUserInternalServerError) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *RevokeRoleFromUserInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
RevokeRoleFromUserBody revoke role from user body
swagger:model RevokeRoleFromUserBody
*/
type RevokeRoleFromUserBody struct {

	// The roles to revoke from the specified user.
	Roles []string `json:"roles"`

	// user type
	UserType models.UserTypeInput `json:"userType,omitempty"`
}

// Validate validates this revoke role from user body
func (o *RevokeRoleFromUserBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateUserType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *RevokeRoleFromUserBody) validateUserType(formats strfmt.Registry) error {
	if swag.IsZero(o.UserType) { // not required
		return nil
	}

	if err := o.UserType.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("body" + "." + "userType")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("body" + "." + "userType")
		}
		return err
	}

	return nil
}

// ContextValidate validate this revoke role from user body based on the context it is used
func (o *RevokeRoleFromUserBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateUserType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *RevokeRoleFromUserBody) contextValidateUserType(ctx context.Context, formats strfmt.Registry) error {

	if err := o.UserType.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("body" + "." + "userType")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("body" + "." + "userType")
		}
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *RevokeRoleFromUserBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *RevokeRoleFromUserBody) UnmarshalBinary(b []byte) error {
	var res RevokeRoleFromUserBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
